/************************************************************************/
/* voc.c, voc loader code.                                              */
/************************************************************************/
#include "voc.h"

extern unsigned char error[]; // error string
extern samrec samples[];
extern output_type _output;

#define pakattu __attribute__ ((packed))
#pragma pack(1)
struct
{
/* file header */
 char ignore1[20] pakattu; /* creative voice file+1A+stuff */
 unsigned short data_start pakattu;
 unsigned short ver pakattu;
 unsigned short id pakattu;

/* data block header, we'll just assume that there's only one of these in
   the file */
 unsigned char d_id pakattu;
 unsigned char len[3] pakattu;
 unsigned char time_c pakattu;
 unsigned char pack pakattu;
} voc_header;
#pragma pack()

signed int load_voc(char *filename, int samplenro) /* 0 ok, -1 fail */
{
 FILE *f = fopen(filename, "rb");
 ulong pit;

 if (f == NULL)
 {
   strcat(error, "load_voc: file not found.\n");
   return -1;
 }

 if (fread(&voc_header, 1, sizeof(voc_header),f) == -1)
 {
   strcat(error, "load_voc: unable to load file.\n");
   fclose(f);
   return -1;
 }

 if ((int)strstr(voc_header.ignore1, "Creative Voice File") == 0)
 {
   strcat(error, "load_voc: not a voc.\n");
   fclose(f);
   return -1;
 }

 pit = voc_header.len[0] +
       voc_header.len[1] * 256L +
       voc_header.len[2] * 65536L;

 samples[samplenro].loop_type = 0;
 samples[samplenro].volume    = 64;
 strncpy(samples[samplenro].name, filename, 20);

 if (-1 == _output.loadsample_8_bits_raw_from_opened_file_curpos(f,
   samplenro, 1000000 / (256 - voc_header.time_c), 128, 0, 0,
   pit,0x00))
 {
   strcat(error, "load_voc: load error.\n");
   fclose(f);
   return -1;
 }

 fclose(f);
 return 0;
}

// end of file
