/************************************************************************/
/* vali.h, selection bar code.                                          */
/************************************************************************/
#include "vali.h"
#include "ialot.h"
extern unsigned char error[]; /* error string */

void piirra_ikkuna(int x, int y, int xsize, int ysize, unsigned char color)
{
 unsigned char palat[6] = {201,205,187,186,188,200};
 int i, a, ap;

 // fill with the color
 ap = x * 2 + y * 160 + 0xb8000;
 for (i = 0; i < ysize; i++)
  for (a = 0; a < xsize; a++)
   _farpokew(_dos_ds, ap + a * 2 + i * 160,
     32 + (256 * (unsigned short)color));

 // the high border
 for (i = 0; i < xsize; i++)
  _farpokew(_dos_ds, ap + i * 2, palat[1] + (256 * (unsigned short)color));

 // the low border
 for (i = 0; i < xsize; i++)
  _farpokew(_dos_ds, ap + i * 2 + (ysize - 1) * 160,
    palat[1] + (256 * (unsigned short)color));

 // the left border
 for (i = 0; i < ysize; i++)
  _farpokew(_dos_ds, ap + i * 160,palat[3] + (256 * (unsigned short)color));

 // the right border
 for (i = 0; i < ysize; i++)
  _farpokew(_dos_ds, ap + i * 160 + (xsize - 1) * 2,
    palat[3] + (256 * (unsigned short)color));

 // high corners
 _farpokew(_dos_ds, 0xb8000 + x * 2 + y * 160,
   palat[0] + (256 * (unsigned short)color));
 _farpokew(_dos_ds, 0xb8000 + (x + xsize - 1) * 2 + y * 160,
   palat[2] + (256 * (unsigned short)color));

 // low corners
 _farpokew(_dos_ds, 0xb8000 + x * 2 + (y + ysize - 1) * 160,
   palat[5] + (256 * (unsigned short)color));
 _farpokew(_dos_ds, 0xb8000 + (x + xsize - 1) * 2 + (y + ysize - 1) * 160,
   palat[4] + (256 * (unsigned short)color));
}

void hidecursor()
{
 __dpmi_regs r;
 memset(&r, 0, sizeof(__dpmi_regs));
 r.x.ax = 0x0100;
 r.x.cx = 0x2607;
 __dpmi_int(0x10, &r);
}

void showcursor()
{
 __dpmi_regs r;
 memset(&r, 0, sizeof(__dpmi_regs));
 r.x.ax = 0x0100;
 r.x.cx = 0x0506;
 __dpmi_int(0x10, &r);
}

void mwrite(unsigned char *text, unsigned int x,
            unsigned int y, unsigned char color)
{
 unsigned int i = 0, c = (256 * (unsigned short)color);
 x *= 2; y *= 160;
 while ((text[i] != 0) && (x < 160))
 {
   _farpokew(_dos_ds, 0xb8000 + x + y,(unsigned short)text[i++] + c);
   x += 2;
 }
}

int valintabar(vali_t *list, char count, char *otsikko, char defa) // -1 if aborted
{
 int i, cha;
 unsigned int a;
 int xpos, ypos, color;
 char *saveta = (char *)alloca(4000);
 if (saveta == NULL) { strcat(error, "out of memory.\n"); return -1;}

 for (i = 0; i < 4000; i++) saveta[i] = _farpeekb(_dos_ds, 0xb8000 + i);
 hidecursor();

 a = 0;
 for (i = 0; i < count; i++)
  if (strlen(list[i].menutext) > a) a = strlen(list[i].menutext);

 if (strlen(otsikko) > a) a = strlen(otsikko);

 xpos = 80 / 2 - (a + 4) / 2;
 ypos = (25 - (count + 2)) / 2;

 piirra_ikkuna(xpos, ypos, a + 4, count + 2, 16 + 15);
 mwrite(otsikko, 40 - (strlen(otsikko) / 2), ypos, 16 + 14);
 cha = 255;
 i = defa - 1;
 while ( (cha != 13)||(list[i].selectable == 0) )
 {
  for (a = 0; a < count; a++)
  {
    if (list[a].selectable == 1)
    {
      if (a == i) color = 5 * 16 + 15; else color = 16 + 7;
    }
    else
    {
      if (a == i) color = 5 * 16 + 8; else color = 16 + 8;
    }
    mwrite(list[a].menutext, xpos + 2, ypos + 1 + a, color);
  }

  cha = getch();
  if (cha == 27)
  {
    for (a = 0; a < 4000; a++) _farpokeb(_dos_ds, 0xb8000 + a, saveta[a]);
    showcursor();
    return -1;
  }

  if (cha == 0)
   switch (getch())
   {
    case 72: if (i > 0) i--; break;
    case 80: if (i < count-1) i++; break;
   }
 }

 for (a = 0;a < 4000; a++) _farpokeb(_dos_ds, 0xb8000 + a, saveta[a]);
 showcursor();
 return i;
}
