#ifndef _hmod_usdev_h
#define _hmod_usdev_h
/************************************************************************/
/*usdev.h, gravis UltraSound device. channels are 1-32, NOT 0-31        */
/************************************************************************/
#include "ialot.h"
#include "structs.h"

gpoke_type gpoke;

struct
{
 unsigned int base;
} gus_settings;

struct
{
 unsigned int base,totalmem,usedmem,channels,mode;
} gus;

int gus_get_settings();

int gus_loadsample_8_bits_raw_from_opened_file_curpos(FILE *f, int samplenro,
  int frequ, int pan, int loopstart, int loopend, int read_length,
  char ssigned);

int gus_loadsample_signed_8_bits_raw(char *filename, int samplenro, int frequ,
  int pan, int loopstart, int loopend);

int gus_loadsample_8_bits_raw_from_memory(sbyte *data, int samplenro,
  int frequ, int pan, int loopstart, int loopend, int length, char ssigned);

void gus_set_freq(unsigned int voice,unsigned int hz);
void gus_set_pan(int v,int b);
void gus_set_volume(int channaa, int _volume);
void gus_stopchannel(int chan);
int gus_playsample(int channaa, int sample, int volume, int frequ, int ppan,
  int __offset);
int gus_get_channels();
void gus_set_channels(int __channels);
int gus_init(int dummy);
int gus_deinit();
void gus_freeallsamples();
int gus_memory();

/* end of usdev.h */
#endif
