#ifndef _hmod_sbdev_h
#define _hmod_sbdev_h
/************************************************************************/
/* sbdev.h, the sound blaster device                                    */
/************************************************************************/
#include "ialot.h"
#include "structs.h"
#include "vali.h"

struct
{
 unsigned int base,irq,dma,hdma;
} sb_settings;

int sb_init(int askuser);
int sb_deinit();

int sb_loadsample_8_bits_raw_from_opened_file_curpos(FILE *f,
      int samplenro,
      int frequ,
      int pan,
      int loopstart,
      int loopend,
      int read_length,
      char ssigned);

int sb_loadsample_signed_8_bits_raw(char *filename,
      int samplenro,
      int frequ,
      int pan,
      int loopstart,
      int loopend);

int sb_loadsample_8_bits_raw_from_memory(sbyte *data,
      int samplenro,
      int frequ,
      int pan,
      int loopstart,
      int loopend,
      int length,
      char ssigned);

int sb_freesample(int samplenro);


int sb_get_channels();
int sb_get_settings();

int sb_playsample(int channaa,
      int sample,
      int volume,
      int frequ,
      int ppan,
      int __offset);

void sb_stopchannel(int chan);
void sb_set_channels(int __channels);
void sb_set_freq(unsigned int voice, unsigned int hz);
void sb_set_pan(int v,int b);
void sb_set_volume(int channaa, int _volume);
int sb_memory();

/* end of sbdev.h */
#endif
