/************************************************************************/
/* hmp.c, Hubris Module Player. Copyright (c) 1997 by Chem of Hubris.   */
/* see 'hmpdoc.txt' for more info.                                      */
/*                                                                      */
/* remember to link hub_mp.a!                                           */
/************************************************************************/

#include "interfac.h" // player, devices and loaders
#include "crt0.h"

void example_void(int paramcount, char **paramstr)
{
 int initi/*, sfx_handle*/;
 char *command_com = getenv("COMSPEC"); // get the command.com name

 HubrisModulePlayer();                  // do some internal initializing

 if ( (paramcount > 2) && (strncasecmp("setup", paramstr[2], 5) == 0) )
   initi = 1; else initi = 0;           // does user want a manual setup?

 if (init_device(initi) == -1)          // initialize the sound device
 {
   strcat(error, "could not initialize the sound device.\n");
   lopeta(1);
 }

 module.file_offset  = 0;               // load from file offset 0
/*
 module.sample_space = 25000;           // reserve space for sfx.
*/
 module.sample_space = 0;

 if ( load_tune(paramstr[1]) != 0 )     // load module
 {
   strcat(error, "bye.\n");
   deinit_device();                     // not a valid mod, s3m or xm.
   lopeta(1);                           // halt on error.
 }

 __init_sam_engine();                   // initialize the sample engine.
/*
 __init_sfx_engine(1);                  // how many channels for sfx.
*/
 __init_sfx_engine(0);

                                        // now load all samples:
/*
 sfx_handle = __get_smp_nro();
 if (load_voc("byebye.voc", sfx_handle) == -1)
 {
   strcat(error, "byebye.\n");
   deinit_device();
   lopeta(1);
 }
*/

 // set a proper amount of active channels :
 _output.set_channels(module.channels + __get_sfx_channels_res());

 init_playing();                         // start playing (module)

 // play a sample using the handle given at load time :
/*
 _output.playsample(__get_sfx_chan(), sfx_handle, 64, -1, -1, 0);
*/

 if (command_com != NULL) system(command_com);
  else system("command.com");           // shell to dos.

 while (kbhit()) getch();               // flush keyboard input
 while ((!kbhit()) && (play.playing))
 {
   printf("pat: %d, order: %d, row: %d, speed: %d, bpm: %d, t: %d  \r",
     play.physpatta, play.order, play.row, play.speed, play.bpm,
     kello.kelloja);                    // show some info.

   fflush(stdout);                      // flush standard output.
 }
 while (kbhit()) getch();               // we could use a toilet here.
 printf("\n");

 deinit_playing();                      // stop playing
 free_mod();                            // release module
 deinit_device();                       // deinitialize output device
}

void main(int paramcount,char *paramstr[])
{
 _crt0_startup_flags |= _CRT0_FLAG_LOCK_MEMORY; // not necessary

 if (paramcount >= 2) // if module name is given
   example_void(paramcount, paramstr);

 strcat(error,"usage: hmp.exe [path]module[.MOD/.S3M] [setup] \n");
 lopeta(0);
}

// end of file
