/************************************************************************/
/* usdev.c, gravis UltraSound device code. channels are 1-32, NOT 0-31  */
/************************************************************************/
#include "usdev.h"

extern unsigned char error[];
extern samrec samples[];
extern channelinforec channel[];
extern unsigned int master;
extern void mastervolume(signed int vol);

/************************************************************************/
/* OUT: -1 failed                                                       */
/*       0 ok                                                           */
/************************************************************************/

int gus_get_settings()
{
 int len, pos;
 char *guse = getenv("ULTRASND");
 if (guse == NULL) // no env. variable
 {
   strcat(error,"env. read: no ultrasnd env. variable\n");
   return -1;
 }
 gus_settings.base = 0;

 len = strlen(guse);
 pos = strcspn(guse,",");
 if (pos >= len) // no base
 {
   strcat(error,"env. read: no base. (220 etc.)\n");
   return -1;
 }

 gus_settings.base = (guse[pos - 3] - 48) * 0x100 +
                     (guse[pos - 2] - 48) * 0x010 +
                     (guse[pos - 1] - 48); // am i too proud to use atoi?-)

 if ( (gus_settings.base < 0x210) || (gus_settings.base > 0x290) )
 {
   gus_settings.base = 0xFFFF;
   strcat(error,"env. read: no base. (220 etc.)\n"); // no base
   return -1;
 }

 return 0;
}

#define io 8192

int divide[19] =
{ 44100,
  41160,38587,36317,34300,32494,30870,29400,28063,26843,
  25725,24696,23746,22866,22050,21289,20580,19916,19293
};

int volumet[65] =
{ 0x1500,
  0x9490,0xA3D0,0xAFB0,0xB380,0xBB50,0xBF80,0xC170,0xC360,
  0xCA00,0xCB40,0xCE70,0xCF80,0xD080,0xD180,0xD270,0xD370,
  0xD960,0xDA10,0xDAB0,0xDB60,0xDBF0,0xDE90,0xDF10,0xDF90,
  0xE010,0xE0A0,0xE110,0xE1A0,0xE210,0xE2A0,0xE310,0xE390,
  0xE410,0xE990,0xE9E0,0xEA30,0xEA80,0xEAD0,0xEB30,0xEB80,
  0xEBD0,0xEC20,0xEE70,0xEEB0,0xEEF0,0xEF30,0xEF80,0xEFC0,
  0xF000,0xF040,0xF080,0xF0C0,0xF100,0xF140,0xF180,0xF1D0,
  0xF200,0xF240,0xF280,0xF2C0,0xF300,0xF340,0xF380,0xF3B0
};

void gusdelay()
{
 char _al;
 _al = inportb(0x300);
 _al = inportb(0x300);
 _al = inportb(0x300);
 _al = inportb(0x300);
 _al = inportb(0x300);
 _al = inportb(0x300);
 _al = inportb(0x300);
}

int ultravoiceinuse(int voic) //0 no, 1 yes
{
 int ret, voice = voic - 1;
 asm volatile (
  "pushfl
   cli");
 outportb(gus.base + 0x102, voice);
 outportb(gus.base + 0x102, voice);
 outportb(gus.base + 0x102, voice);
 outportb(gus.base + 0x103, 0x80);
 ret = ((inportb(gus.base + 0x105) & 3) == 0);
 gusdelay();
 asm volatile ("popfl");
 return ret;
}

int voicepos(int vo)
{
 unsigned int i, temp0, temp1, v = vo - 1;
 asm volatile (
  "pushfl
   cli");
 outportb(gus.base + 0x102, v);
 outportb(gus.base + 0x102, v);
 outportb(gus.base + 0x102, v);
 outportb(gus.base + 0x103, 0x8A);
 temp0 = inportw(gus.base + 0x104);
 outportw(gus.base + 0x103, 0x8B);
 temp1 = inportw(gus.base + 0x104);
 asm volatile("popfl");
 for (i = 0; i < 10; i++) gusdelay();
 return ((temp0 << 7) + (temp1 >> 8));
}

char guspeek(unsigned int loc)
{
 char b;
 unsigned int addlo = (loc & 0xFFFF), addhi = ((loc & 0xFF0000) >> 16);
 asm volatile (
  "pushfl
   cli");
 outportb(gus.base + 0x103, 0x43);
 outportw(gus.base + 0x104, addlo);
 outportb(gus.base + 0x103, 0x44),
 outportb(gus.base + 0x105, addhi);
 b = inportb(gus.base + 0x107);
 asm volatile ("popfl");
 return b;
}

inline void guspoke(unsigned int loc, char b)
{
 unsigned int addlo = (loc & 0xFFFF), addhi = ((loc & 0xFF0000) >> 16);
 asm volatile (
  "pushfl
   cli");
 outportb(gus.base + 0x103, 0x43);
 outportw(gus.base + 0x104, addlo);
 outportb(gus.base + 0x103, 0x44),
 outportb(gus.base + 0x105, addhi);
 outportb(gus.base + 0x107, b);
 asm volatile ("popfl");
}

unsigned int guppoke(unsigned int gus_pos, signed char *buf,
                     unsigned int count, unsigned char ssigned)
{
 gus.usedmem += count;
 if (gus.usedmem >= gus.totalmem)
 {
   strcat(error, "guppoke: out of GUS memory.\n");
   return -1;
 }
 ssigned ^= 0x80;
 do {
  guspoke(gus_pos++, *(buf++) ^ ssigned);
 } while (--count);
 return 0;
}

inline signed char __2pintrplt(signed char oo1, signed char oo2,
                        uhuge wei)
{
 shuge o1 = (shuge)oo1,
       o2 = (shuge)oo2,
       retu;

 wei &=   0xFFFFFFFF;
 retu =   ( o2 * wei + o1 * (0xFFFFFFFF - wei) );
 retu >>= 32;
 if (retu < -128) retu = -128; else
 if (retu > 127)  retu = 127;

 return (sbyte)retu;
}

int guppoke_crunch(int gus_pos, signed char *buf,
  unsigned int count,unsigned char ssigned)
{
 uhuge gup_step = ((uhuge)gpoke.total << 32) /
                                 gus.totalmem;

 gpoke.gup_pos &= 0xFFFFFFFF; /* only the decimal part */

 ssigned ^= 0x80;
 while ( ((gpoke.gup_pos >> 32) < count) && (gus.usedmem < gus.totalmem) ) {

  guspoke( gus_pos++, /* poke a byte to gus mem */
           __2pintrplt(buf[(gpoke.gup_pos >> 32)] ^ ssigned,
                       buf[(gpoke.gup_pos >> 32) + 1] ^ ssigned,
                       gpoke.gup_pos) );

  gpoke.gup_pos += gup_step; /* increase 32.32 fixp. source pointer */
  gus.usedmem++;

 };

 if (gus.usedmem >= gus.totalmem)
 {
   strcat(error, "guppoke_crunch: out of GUS memory!\n");
   return -1;
 }

 return gus_pos;
}

int gus_loadsample_8_bits_raw_from_memory(sbyte *data, int samplenro,
      int frequ, int pan, int loopstart, int loopend,
      int length, char ssigned)
{
  int gp;
  char nollia[4] =
  {
    0, 0, 0, 0
  };

  if (data == NULL)
  {
    strcat(error, "gus_lsmp_mem: no data.\n");
    return -1;
  }

  if (gpoke.total < gus.totalmem) gpoke.total = gus.totalmem;

  samples[samplenro].length   = length;
  samples[samplenro].gus_data = gus.usedmem;
  gpoke.gup_pos = 0;
  gp = samples[samplenro].gus_data;
  gp = guppoke_crunch(gp, data, length, ssigned); // upload with crunching
  if (gp == -1) // out of gus memory
  {
    strcat(error, "gus_lsmp: unable to upload samples to GUS memory.\n");
    strcat(error, "gus_lsmp: (out of gus memory!)\n");
    return -1;
  }

  guppoke(gp, nollia, 4, 0x80); // pad the end of the sample with zeroes
  if (loopend > 0) guspoke(gp, guspeek(samples[samplenro].gus_data));

  gus.usedmem = (gus.usedmem + 31) & 0xFFFFFFE0; // align the next sample on a 32 byte boundary

  /* adjust pitch and lengths to the crunched values */
  samples[samplenro].c2spd       = ((uhuge)frequ*(uhuge)gus.totalmem)/gpoke.total;
  samples[samplenro].length      = ((uhuge)samples[samplenro].length*(uhuge)gus.totalmem)/gpoke.total;
  samples[samplenro].loop_start  = ((uhuge)loopstart*(uhuge)gus.totalmem)/gpoke.total;
  samples[samplenro].loop_endi   = ((uhuge)loopend*(uhuge)gus.totalmem)/gpoke.total;
  samples[samplenro].loop_length = samples[samplenro].loop_endi-samples[samplenro].loop_start;
  samples[samplenro].pan         = pan;
  samples[samplenro].used        = 1;

  return 0;
}

int gus_loadsample_8_bits_raw_from_opened_file_curpos(FILE *f,
  int samplenro, int frequ, int pan, int loopstart, int loopend,
  int read_length, char ssigned)
{
  int read,get;
  char disk[io+2];
  int tst;
  int gp;

  if (f == NULL)
  {
    strcat(error,"gus_lsmp: file not open.\n");
    return -1;
  }

  if (gpoke.total < gus.totalmem) gpoke.total=gus.totalmem;
   /* don't decruch (=enlargen) the samples :) */

  samples[samplenro].length = read_length;
//  printf("loading %ld bytes.\n",samples[samplenro].length);
//  samples[samplenro].data=(char *)malloc(samples[samplenro].length+4);
  samples[samplenro].gus_data = gus.usedmem;
  tst  = io;
  read = 0;
  gpoke.gup_pos = 0;
  gp = samples[samplenro].gus_data;
  while (read < samples[samplenro].length)
  {
    get = samples[samplenro].length - read;
    if (get > io) get = io;
    tst = fread(&disk, 1, get, f);
    if (tst == -1)
    {
      strcat(error,"gus_lsmp: load error.\n");
//      fclose(f);
      return -1;
    }
    if ((samples[samplenro].length - read - get) > 0) // bytes left to read?
    {
      fread(&disk[io],1,1,f);
      fseek(f,(ftell(f) - 1),SEEK_SET);
    } else disk[io] = disk[io-1];

    gp = guppoke_crunch(gp,disk,get,ssigned); // upload with crunching
    if (gp == -1) /* out of mem */
    {
      strcat(error,"gus_lsmp: unable to upload samples to GUS memory.\n");
      strcat(error,"gus_lsmp: (out of gus memory!)\n");
//      fclose(f);
      return -1;
    }

    read+=get;
  }

  memset(&disk[0],0,4);
  guppoke(gp,disk,4,0x80); /* pad the end of the sample with zeroes */

  /* if looped, then the byte next to the last one should equal the 1st..*/
  /* because gus interpolates past the end of the sample */
  if (loopend > 0) guspoke(gp,guspeek(samples[samplenro].gus_data));

  gus.usedmem=(gus.usedmem+31)&0xFFFFFFE0; /* align the next sample on a 32 byte boundary */

  /* adjust pitch and lengths to the crunched values */
  samples[samplenro].c2spd       = ((uhuge)frequ * (uhuge)gus.totalmem) / gpoke.total;
  samples[samplenro].length      = ((uhuge)samples[samplenro].length*(uhuge)gus.totalmem)/gpoke.total;
  samples[samplenro].loop_start  = ((uhuge)loopstart*(uhuge)gus.totalmem)/gpoke.total;
  samples[samplenro].loop_endi   = ((uhuge)loopend*(uhuge)gus.totalmem)/gpoke.total;
  samples[samplenro].loop_length = samples[samplenro].loop_endi - samples[samplenro].loop_start;
  samples[samplenro].pan         = pan;
  samples[samplenro].used        = 1;

  return 0;
}

int gus_loadsample_signed_8_bits_raw(char *filename, int samplenro,
  int frequ, int pan, int loopstart, int loopend)
{
  FILE *f;
  signed int rr;

  if (samples[samplenro].used==1)
  {
    strcat(error,"gus_lsmp: sample slot already in use.\n");
    return -1;
  }
  f = fopen(filename,"rb");
  if (f == NULL)
  {
    unsigned char tempp[50]="gus_lsmp: file ("; // hard?
    strcat(tempp,filename);
    strcat(tempp,") not found.\n");
    strcat(error,tempp);
    return -1;
  }
  samples[samplenro].loop_type = 0;
  samples[samplenro].length    = filelength(fileno(f));
  rr = gus_loadsample_8_bits_raw_from_opened_file_curpos(f,samplenro,frequ,
    pan,loopstart,loopend,samples[samplenro].length,0x80);

  fclose(f);
  return rr;
}

int gusprobe() // 0 found, -1 not found
{
 unsigned char b;
 asm volatile (
 "pushfl
  cli");
 outportb(gus.base+0x103,0x4C);
 outportb(gus.base+0x105,0);
 gusdelay();
 gusdelay();
 outportb(gus.base+0x103,0x4C);
 outportb(gus.base+0x105,1);
 guspoke(0,0xAA);
 guspoke(0x100,0x55);
 b = guspeek(0);
 asm volatile ("popfl");
 if (b == 0xAA) return 0;
 return -1;
}

void gusfind()
{
 int i;
 for (i=1;i<9;i++)
  {
   gus.base=0x200+i*0x10;
   if (gusprobe() == 0) return;
  }
 gus.base = 0xFFFF;
}

int gusfindmem()
{
 int gp=0;
 asm volatile(
 "pushfl
  cli");
 do{
  gp+=0x40000;
  gusdelay();
  gusdelay();
  gusdelay();
  guspoke(gp,0xAA);
  gusdelay();
  gusdelay();
  gusdelay();
 }while((gp<0x100000)&&(((unsigned char)guspeek(gp))==0xAA));
 asm volatile ("popfl");
 return (gp-1);
}

void gus_set_freq(unsigned int voic,unsigned int hz)
{
 unsigned int f,tmp, voice = voic - 1;
 tmp=divide[gus.channels-14];
 f=(((hz<<9)+(tmp>>1))/tmp)*2;
 asm volatile(
 "pushfl
  cli");
 outportb(gus.base+0x102,voice);
 outportb(gus.base+0x102,voice);
 outportb(gus.base+0x102,voice);
 outportb(gus.base+0x103,1);
 outportw(gus.base+0x104,f);
 asm volatile ("popfl");
 channel[voice+1].freq=hz;
}

void gusvoicecontrol(int vo,int b)
{
 int v = vo - 1;
 asm volatile(
 "pushfl
  cli");
 outportb(gus.base+0x102,v);
 outportb(gus.base+0x102,v);
 outportb(gus.base+0x102,v);

 outportb(gus.base+0x103,0);
 outportb(gus.base+0x105,b);
 asm volatile ("popfl");
}

void gus_set_pan(int vo,int b) //0-256
{
 int v = vo - 1;
 b=(b*15)/256;
 if (b>0x0F) b=0x0F; else if (b<0) b=0;
 asm volatile (
 "pushfl
  cli");
 outportb(gus.base+0x102,v);
 outportb(gus.base+0x102,v);
 outportb(gus.base+0x102,v);
 outportb(gus.base+0x103,0x0C);
 outportb(gus.base+0x105,b);
 asm volatile("popfl");
 channel[v+1].pan=((b*256)/15);
}

void gussetvolume_log(int voic,int vol)
{
 int voi = voic - 1;
 asm volatile (
 "pushfl
  cli");
 outportb(gus.base+0x102,voi);
 outportb(gus.base+0x102,voi);
 outportb(gus.base+0x102,voi);
 outportb(gus.base+0x103,9);
 outportw(gus.base+0x104,vol);
 asm volatile ("popfl");
}

void gus_set_volume(int channaa, int _volume) /*channaa: 1-32, _volume: 0-64*/
{
 if(_volume > 64) _volume = 64; else if(_volume < 0) _volume = 0;
 gussetvolume_log(channaa,volumet[_volume*master/64]);
 channel[channaa].volume=_volume;
}

void gusstopvoice(int vo) //v: 1-32
{
 int temp, v = vo - 1;
 asm volatile (
 "pushfl
  cli");
 outportb(gus.base+0x102,v);
 outportb(gus.base+0x102,v);
 outportb(gus.base+0x102,v);
 outportb(gus.base+0x103,0x80);
 temp=inportb(gus.base+0x105);
 outportb(gus.base+0x103,0);
 outportb(gus.base+0x105,(temp&0xDF)|3);
 gusdelay();
 outportb(gus.base+0x103,0);
 outportb(gus.base+0x105,(temp&0xDF)|3);
 asm volatile("popfl");
}

void gus_stopchannel(int chan)
{
 if ((chan<1)||(chan>32)) return;
 gusstopvoice(chan);
 channel[chan].playing=0;
}

void emptychan(int chan)
{
 if (ultravoiceinuse(chan) == 0) gus_stopchannel(chan);
}

int channel_inuse(int __channel)
{
 if ((__channel<1)||(__channel>32)) return 1;
 if (ultravoiceinuse(__channel) == 0) channel[__channel].playing = 0;
 return (channel[__channel].playing);
}

#define mode_16bits 4
#define mode_loop 8
#define mode_pingpong 16

void gusplayvoice(unsigned int vo,unsigned int mode,unsigned int begin,
                  unsigned int start,unsigned int end)
{
 int v = vo - 1;
 asm volatile(
 "pushfl
  cli");
 outportb(gus.base+0x102,v);
 outportb(gus.base+0x102,v);
 outportb(gus.base+0x102,v);
 gusdelay();

 outportb(gus.base+0x103,0x0A);
 outportw(gus.base+0x104,begin>>7);
 outportb(gus.base+0x103,0x0B);
 outportw(gus.base+0x104,begin<<9);
 outportb(gus.base+0x103,2);
 outportw(gus.base+0x104,start>>7);
 outportb(gus.base+0x103,3);
 outportw(gus.base+0x104,start<<9);
 outportb(gus.base+0x103,4);
 outportw(gus.base+0x104,end>>7);
 outportb(gus.base+0x103,5);
 outportw(gus.base+0x104,end<<9);

 outportb(gus.base+0x103,0);
 outportb(gus.base+0x105,mode&0xfc);

 outportb(gus.base,1);
 outportb(gus.base+0x103,0x4C);
 outportb(gus.base+0x105,3);

 channel[v+1].playing=1;
 asm volatile ("popfl");
}

int gus_playsample(int channaa, int sample, int volume, int frequ, int ppan, int __offset)
{
 ulong __mode, loppu;

 if (samples[sample].used != 1) return -1;

 gus_stopchannel(channaa);

 asm volatile (
 "pushfl
  cli");

 channel[channaa].playing = 0;
 channel[channaa].sample  = sample;

 if (volume == -1)
   channel[channaa].volume = samples[sample].volume;
 else if (volume != -2)
   channel[channaa].volume = volume;

 gus_set_volume(channaa, channel[channaa].volume);

 if (frequ == -1)
   channel[channaa].freq = samples[sample].c2spd;
 else if (frequ != -2)
   channel[channaa].freq = frequ;

 gus_set_freq(channaa, channel[channaa].freq);

 if (ppan == -1)
   channel[channaa].pan = samples[sample].pan;
 else if (ppan != -2)
   channel[channaa].pan=ppan;

 gus_set_pan(channaa, channel[channaa].pan);

 channel[channaa].position = ((uhuge)__offset*(uhuge)gus.totalmem)/gpoke.total;

 if (channel[channaa].position < samples[sample].length)
 {
   __mode = 0;
   channel[channaa].playing = 1;
   if (samples[sample].loop_endi > 0)
   {
     if (samples[sample].loop_endi > samples[sample].length)
       samples[sample].loop_endi = samples[sample].length;

     loppu   = samples[sample].loop_endi;
     __mode |= mode_loop;
     if (samples[sample].loop_type & 16) __mode |= mode_pingpong;
   }
   else
     loppu = samples[sample].length;

   gusplayvoice(channaa,
                __mode,
                samples[sample].gus_data + channel[channaa].position,
                samples[sample].gus_data + samples[sample].loop_start,
                samples[sample].gus_data + loppu);
 }
 channel[channaa].position <<= 32;

 asm volatile ("popfl");
 return 0;
}

int gus_get_channels()
{
 return gus.channels;
}

void gus_set_channels(int __channels)
{
 gus.channels=__channels;
 if (gus.channels<14) gus.channels=14; else
  if (gus.channels>32) gus.channels=32;
 asm volatile(
 "pushfl
  cli");
 gusdelay();
 outportb(gus.base+0x103,0x0E);
 outportb(gus.base+0x105,((gus.channels-1)|0xC0));
 gusdelay();
 asm volatile ("popfl");
}

void gusreset(int __channels)
{
 gus.channels=__channels;
 if (gus.channels<14) gus.channels=14; else
  if (gus.channels>32) gus.channels=32;
 gus.usedmem=0;
 asm volatile(
 "pushfl
  cli");
 outportb(gus.base+0x103,0x4C);
 outportb(gus.base+0x105,1);
 gusdelay();
 outportb(gus.base+0x103,0x4C);
 outportb(gus.base+0x105,7);
 gusdelay();
 outportb(gus.base+0x103,0x0E);
 outportb(gus.base+0x105,((gus.channels-1)|0xC0));
 asm volatile ("popfl");
}

int gus_memory()
{
 return gus.totalmem;
}

int gus_init(int dummy)
{
 int k, gus_base;
 printf("\rusdev v1.06, UltraSound classic/compatibles \n");

 gus_get_settings();
 gus_base = gus_settings.base;

 if ((gus_base >= 0x210) && (gus_base <= 0x290)) gus.base = gus_base;
 else
 {
   gusfind();
   if (gus.base == 0xFFFF) return -1;
 }
 if (gusprobe() == -1)
   printf("no gus detected at this address. ignoring such a minor problem.\n");

 printf("gus: A2%d0h", (gus.base - 0x200) / 0x10);
 gus.totalmem = gusfindmem();
 gus.usedmem  = 0;
 gus.mode     = 0;
 printf(" %d kB \n",(gus.totalmem + 512) / 1024);
 gusreset(32);
 for (k = 1; k <= 32; k++) gusstopvoice(k);
 gusreset(32);
 for (k = 1; k <= 32; k++) gusstopvoice(k);
 mastervolume(64);

 for(k = 1; k <= 32; k++)
 {
   gusvoicecontrol(k, 0);
   gus_set_freq(k, 8363);
   gus_set_volume(k, 0);
   gus_set_pan(k, 0x80);
   gusstopvoice(k);
 }
 gpoke.total   = gus.totalmem;
 gpoke.gup_pos = 0;
 return 0;
}


void gus_freeallsamples()
{
 int i;
 gus.usedmem   = 0;
 gpoke.total   = gus.totalmem;
 gpoke.gup_pos = 0;

 for (i = 0; i < 130; i++) samples[i].used = 0;
}

int gus_deinit()
{
 int i;
 gus.usedmem=0;
 gus.totalmem=0;
 for (i=1;i<=gus.channels;i++) gus_stopchannel(i);
 gusreset(14);
 gus_freeallsamples();
 return 0;
}

