/************************************************************************/
/* global structures & defines.                                         */
/************************************************************************/
#ifndef __hmp_structs_h
#define __hmp_structs_h
#include "ialot.h"

// defines :

#define lo(tmp) ((tmp)&0xFF)
#define hi(tmp) (((tmp)>>8)&0xFF)

#define MOD 100
#define S3M 101
#define XM  102

#define NOSOUND 200
#define SB 201
#define GUS 202

#define ubyte unsigned char
#define sbyte signed char
#define uword unsigned short
#define sword signed short
#define ulong unsigned int
#define slong signed int
#define uhuge unsigned long long
#define shuge signed long long

#define _notecut 1
#define _portatonote 2
#define _arpeggio 3
#define _porta 4
#define _vibrato 5
#define _tremolo 6
#define _retrignote 7
#define _tremor 8
#define _notedelay 9
#define _panningslide 10
#define _globalvslide 11
#define _nothing 255
#define _keyoff 254

// device structures :

typedef struct
{
 ubyte used;     // 0 no; 1 yes
 ubyte name[29]; // sample's name
 slong length;   // sample's length
 slong c2spd;    // sample's playing frequency at C4
 slong finetune; // XM-thingy
 slong relativenote; // XM-thingy
 slong volume;   // 0-64 please
 slong loop_start,loop_length,loop_endi; // loop_endi==0 EQU no loop
 ubyte *data;    // SB only
 ulong gus_data; // GUS only
 slong pan;      // 0-256 please; 0 left, 256 right
 slong offset;   // start playing at this offset
 uword loop_type;// bit 4: 1 bidir looping, 0 normal looping
} samrec;

typedef struct
{
 volatile slong playing;               // 0 no; 1 yes
 volatile uhuge position;              // fixed point
 slong sample;
 slong freq;    // playing speed in hz
 slong volume;  // 0-64 please
 slong pan;     // 0-256 please
} channelinforec;

typedef struct
{
 int  device;
 int  ((*playsample)(int channaa, int sample, int volume, int frequ, int ppan, int __offset));
 int  ((*freesample)(int samplenro));

 void ((*stopchannel)(int channaa));
 void ((*set_volume)(int channaa, int _volume));
 void ((*set_pan)(int channaa, int _pan));
 void ((*set_freq)(unsigned int channaa, unsigned int _freq));
 void ((*set_channels)(int __channels));
 int  ((*get_channels)());

 int  ((*loadsample_signed_8_bits_raw)
       (char *filename, int samplenro, int frequ, int pan,
       int loopstart, int loopend));

 int  ((*loadsample_8_bits_raw_from_opened_file_curpos)
       (FILE *f, int samplenro, int frequ, int pan,
       int loopstart, int loopend, int read_length, char ssigned));

 int ((*loadsample_8_bits_raw_from_memory)
      (sbyte *data, int samplenro, int frequ, int pan,
      int loopstart, int loopend, int length, char ssigned));

 void ((*freeallsamples)());
 int  ((*deinit)());
 int  ((*init)(int askuser));
 int  ((*memory)());
} output_type;
// end of device structures


// player structures :

// instrument info :
typedef struct // only used with xm
{
 slong basesample;    // which of the samples[] is the first for this instrument
 sbyte samplenro[96]; // which of its (possible) many samples each note uses
 ulong fadeout;       // fadeout speed

 sword vol_env[26];   // volume points
 ubyte vol_pts;       // number of volume points
 ubyte vol_sustain;   // volume sustain point
 ubyte vol_loop_start;// volume loop start point
 ubyte vol_loop_end;  // volume loop end point
 ubyte vol_type;      // bit 0: On; bit 1: Sustain; bit 2: Loop

 sword pan_env[26];   // panning points
 ubyte pan_pts;       // number of panning points
 ubyte pan_sustain;   // panning sustain point
 ubyte pan_loop_start;// panning loop start point
 ubyte pan_loop_end;  // panning loop end point
 ubyte pan_type;      // bit 0: On; bit 1: Sustain; bit 2: Loop
} instrument_type;

// tracking structures :

typedef struct
{
  ulong note;
  ulong samp;
  ulong effe;
  ulong epar;
  ulong volu;
} row_type;

// parameters for some effects :
typedef struct
{
 row_type newrow;

 slong notecut_ontick;

 slong portanote_portaspeed,
       portanote_notetoportato,
       portanote_period;

 slong volumeslide_add;

 slong arpeggio_note,
       arpeggio_xfine,
       arpeggio_yfine;

 slong porta_add;

 slong vibrato_speed,
       vibrato_depth,
       vibrato_vibepos;

 slong tremolo_speed,
       tremolo_depth,
       tremolo_vibepos;

 slong retrignote_ontick,
       retrignote_sample;

 sbyte s3m_vslide_para,
       s3m_porta_down;

 sbyte tremor_count,
       tremor_para;

 sbyte retrig_para;

 sbyte global_vslide_para;
 sbyte panning_slide_para;
} modplay_effectrec;

// tracking code's channels structure :
typedef struct
{
 ubyte keyon;
 slong lastXMinstrument;
 slong lastinstru;
 slong lastnote;
 slong period;
 slong whicheffect;
 slong vslide;
 slong pattern_loop_row,
       pattern_loop_loop;
 slong lastsampleoffset;
 slong volume;
 slong pan;
 modplay_effectrec effect;
 slong note;
 slong effy;
 slong instru;
 ulong offset;

 slong xm_vol_fade;
 ubyte vol_env_on;
 ubyte vol_env_sustain;
 slong vol_env_x;
 slong vol_env_pos;
 slong vol_env_xs;
} channarec;

typedef struct
{
 _go32_dpmi_seginfo _info,vanha;
 volatile uhuge call_me; // the old int 8 handler
 volatile ulong kelloja;
 volatile ulong timspeed,counter;
 volatile ulong play_timspeed,play_counter;
} kello_type;

// tracking code's structure:
typedef struct
{
 volatile slong speed;
 volatile slong bpm;
 volatile slong tick;
 volatile slong order;        // feel free to check
 volatile ulong row;          // these
 volatile slong physpatta;
 slong patternjump;  // 0 false, 1 true
 slong patternbreak; // 0 false, 1 true
 slong patterndelay;

 volatile slong playing;      // 0 stopped, 1 playing
} play_type;

typedef struct
{
 ulong rows;
 ubyte *data;
} pattern_type;

typedef struct
{
 sbyte title[50];
 ubyte channels;
 ulong instruments;
 ulong maxsamples;
 ulong maxinstrus;
 ulong max_volume;
 ubyte fast_vslides;     // 1 yes, 0 no
 ubyte linear_freq;      // 1 yes, 0 no
 ubyte type;             // MOD, S3M
 ulong file_offset;      // the loaders load from this offset of the file.
 ulong sample_space;     // save some space for the samples */
 slong initial_pan[33];
 slong init_master;
 ulong length;
 ulong patterns;         // number of patterns.
 ubyte order[257];
 pattern_type *pattern;
 ulong speed;            // initial speed
 ulong bpm;              // initial tempo
 slong minporta, maxporta;
 slong basefreq;
} module_type;

// the gus sample uploading structure :
typedef struct
{
 uhuge gup_pos; // upload position
 uhuge total;   // total amount of bytes to be loaded
} gpoke_type;

#endif
