#include "s3m.h"
#include "structs.h"
#include "ialot.h"

extern unsigned char error[]; /* error string */
extern samrec samples[];
extern gpoke_type gpoke;
extern module_type module;
extern output_type _output;
extern void free_mod();
extern instrument_type instruments[];

#define PACKED __attribute__ ((packed))
#pragma pack(1)
struct // the s3m header
{
 unsigned char song_name[28] PACKED;
 unsigned char id_1A PACKED;
 unsigned char type PACKED;
 unsigned short xx PACKED;
 unsigned short ordnum PACKED;
 unsigned short insnum PACKED;
 unsigned short patnum PACKED;
 unsigned short flags PACKED;
 unsigned short cwt_v PACKED;
 unsigned short ffi PACKED; //1=signed,2=unsigned samples. ich ignoriere diz.
 unsigned char scrm[4] PACKED;
 unsigned char g_v PACKED; //global volume
 unsigned char i_s PACKED; //initial speed
 unsigned char i_t PACKED; //initial tempo (bpm)
 unsigned char m_v PACKED; //master volume
 unsigned char u_c PACKED;
 unsigned char d_p PACKED;
 unsigned char xxx[8] PACKED;
 unsigned short special PACKED;
 unsigned char channel_settings[32] PACKED;
} s3m_header;
#pragma pack()

/************************************************************************/
/* int load_s3m(char *name)                                             */
/* IN:                                                                  */
/*  filename                                                            */
/* OUT:                                                                 */
/*  0 successful                                                        */
/*  -1 failed                                                           */
/* DESCRIPTION:                                                         */
/*  Loads 1-32 channel Scream Tracker 3.xx S3M-files.                   */
/************************************************************************/
int load_s3m(char *name)
{
 FILE *f;
 int i, c, a;
 unsigned char __scrs[5];
 unsigned short _w;
 unsigned char _b, _b2, __pan, ef, efpar;
 int _row, _channel;
 unsigned char *skriv_hit;
 unsigned char empty[6];
 unsigned int remap[32];
 unsigned int totalsamples;
 unsigned char sflags;

 #pragma pack(1)
 struct
 {
  unsigned short inst[100] PACKED;
  unsigned short patt[256] PACKED;
  unsigned int data[100];
 } pp; /*ParaPointers.*/
 #pragma pack()

/* printf("loading %s \n",name); */

// memset(instruments, 0, sizeof(instrument_type) * 130);

 f = fopen(name, "rb");
 if (f == NULL)
  { // try to add an extension to the filename
   strcat(name, ".S3M");
   f = fopen(name, "rb");
  }

 if (f == NULL)
  {
   strcat(error, "load_s3m: file not found.\n");
   return -1;
  }

 // seek to the beginning of the file :
 fseek(f, 0 + module.file_offset, SEEK_SET);
 if (fread(&s3m_header, 1, sizeof(s3m_header), f) == -1) // read header
  {
   strcat(error, "load_s3m: load error.\n");
   fclose(f);
   return -1;
  }
 s3m_header.song_name[27] = 0;
 if (strncasecmp(s3m_header.scrm, "SCRM", 4) != 0)
  {
   strcat(error, "load_s3m: not a valid S3M module.\n");
   fclose(f);
   return -1;
  }
// memset(&module,0,sizeof(modrec));
 strcpy(module.title, s3m_header.song_name);

 module.instruments = s3m_header.insnum;
 module.type        = S3M;

 if ( ((s3m_header.flags & 64) == 64) ||
      ((s3m_header.cwt_v & 0xFFF) == 0x300) )
   module.fast_vslides = 1; else module.fast_vslides = 0;

 memset(&remap, 0xFF, sizeof(remap));
 module.channels = 0;
 for (i = 0; i < 32; i++) // get the channel settings
  if (s3m_header.channel_settings[i] < 16)
   {
    remap[i] = module.channels;
    module.channels++;
    if (s3m_header.channel_settings[i] <= 7)
      module.initial_pan[module.channels] = 0x39;
    else module.initial_pan[module.channels] = 0xC7;
   } else remap[i] = 0xFF;

 printf("loading %d-channel S3M module called '%s'..",
   module.channels,  module.title);
 fflush(stdout);

 fseek(f, 96 + module.file_offset, SEEK_SET); // get the orders
 memset(&module.order, 0, 257);
 fread(&module.order[1], 1, s3m_header.ordnum, f);

 module.length   = 0;
 module.patterns = 0;
 for (c = 1; c <= s3m_header.ordnum; c++)
  {
/*   printf("%d\n",module.order[c]); */
   if (module.order[c] < 254)
    {
     module.length++;
     module.order[module.length] = module.order[c];
     if (module.order[module.length] > module.patterns)
      module.patterns = module.order[module.length];
    }
   }
/* for (c=1;c<=module.length;c++)
  printf("%d\n",module.order[c]); */
// printf("song length: %d\n", module.length);
/* printf("phys patterns: %d\n",module.patterns+1); */

 fread(&pp.inst, 2, s3m_header.insnum, f);
 fread(&pp.patt, 2, s3m_header.patnum, f); // get the parapointers.

 if (s3m_header.d_p == 0xFC)
  for (i = 0; i < 32; i++) // if the data is there THEN
   {                       // get the default panning positions.
    fread(&__pan, 1, 1, f);
    if ((remap[i] != 255) && ((__pan & 0x10) == 0x10))
      module.initial_pan[remap[i] + 1] = 7 + ((unsigned int)(__pan & 0x0F) << 4);
   }

 if ((s3m_header.m_v & 128) == 0) // however, if the song is mono..
  for (i = 0; i < 32; i++)
   if (remap[i] != 255)
    module.initial_pan[remap[i] + 1] = 128; // ..just pan to the middle

 totalsamples = 0;
 for (i = 1; i<= s3m_header.insnum; i++)
  {
   // seek to the correct position :
   fseek(f, (16 * (unsigned long long)pp.inst[i - 1]) + 13 +
     module.file_offset, SEEK_SET);

   fread(&_b, 1, 1, f); // get the sample data
   fread(&_w, 2, 1, f); // parapointer
   pp.data[i] = (65536 * (unsigned int)_b) + _w;

   samples[i].loop_type = 0;

   fread(&samples[i].length, 4, 1, f); // get sample length
   samples[i].length &= 0xFFFF;        // st3 only supports up to 64 kB
   totalsamples += samples[i].length;

   fread(&samples[i].loop_start, 4, 1, f); // guess
   samples[i].loop_start &= 0xFFFF;

   fread(&samples[i].loop_endi, 4, 1, f);
   samples[i].loop_endi &= 0xFFFF;

   samples[i].loop_length = samples[i].loop_endi - samples[i].loop_start;
   samples[i].volume = 0;
   fread(&samples[i].volume, 1, 1, f);
   fseek(f, 2, SEEK_CUR); // jump over unused+packing
   sflags = 0;
   fread(&sflags, 1, 1, f);
   if ((sflags & 1) == 0)
    { // no looping
     samples[i].loop_start  = 0;
     samples[i].loop_endi   = 0;
     samples[i].loop_length = 0;
    }

   fread(&samples[i].c2spd, 4, 1, f);
   samples[i].c2spd &= 0xFFFF;

   fseek(f, 12, SEEK_CUR); // skip unused

   memset(samples[i].name, 0, 29);
   fread(&samples[i].name, 1, 28, f);
/*printf("%s \n",samples[i].name);*/
   fread(&__scrs, 1, 4, f);
   __scrs[4] = 0;
/*   printf("SCRS = %s \n",__scrs);*/
/*   getch();*/
/*   fseek(f,4,SEEK_CUR); //skip SCRS */
   samples[i].used = (samples[i].length != 0);
  }
/* printf("sample data will take %d bytes.\n",totalsamples); */

 gpoke.total = totalsamples + (s3m_header.insnum * 99) +
               module.sample_space + 256;
  // leave "some" extra space, it is REQUIRED

 module.pattern =
   (pattern_type*)malloc( (module.patterns + 1) * sizeof(pattern_type));

// printf("reading patterns..");
 fflush(stdout);
 for (i = 0; i <= module.patterns; i++)
  {
    module.pattern[i].rows = 64;
    module.pattern[i].data = (char *)malloc(5 * 64 * module.channels + 10);
    memset(module.pattern[i].data, 0x00, 5 * 64 * module.channels + 10);

    for (a = 0; a<= (module.channels * 64 + 1); a++)
    {
      module.pattern[i].data[a * 5]     = _nothing;
      module.pattern[i].data[a * 5 + 1] = _nothing;
      module.pattern[i].data[a * 5 + 2] = 0;
      module.pattern[i].data[a * 5 + 3] = 0;
      module.pattern[i].data[a * 5 + 4] = _nothing;
    } // silence the pattern

    // seek to the correct position and skip "the packed pattern size" (+2)
    fseek(f, 16 * (unsigned int)pp.patt[i] + 2 + module.file_offset, SEEK_SET);

    _row = 0;
    while (_row < 64)
     {
      fread(&_b, 1, 1, f);
      if (_b > 0)
      {
       _channel = remap[_b & 31];

       if (_channel >= module.channels)
         skriv_hit = empty;
       else
       {
         skriv_hit = (char *)module.pattern[i].data;
         skriv_hit += (5 * _row * module.channels) + 5 + _channel * 5;
       }

       if ((_b & 32) == 32)
       { // get a note
         fread(&_b2, 1, 1, f);
         fread(&__pan, 1, 1, f);
         if (_b2 < 254)
         {
           skriv_hit[1] = (_b2 >> 4) * 12 + (_b2 & 0x0F); // note
           skriv_hit[0] = __pan; // instrument
         } else if (_b2 == 254) skriv_hit[1] = _keyoff;
       }

       if ((_b & 64) == 64)
       {
         fread(&__pan, 1, 1, f);
         skriv_hit[4] = __pan; // volume
       }

       if ((_b & 128) == 128)
       {
         fread(&ef, 1, 1, f);
         fread(&efpar, 1, 1, f);

         switch (ef)
         {
          default:
          case 0:ef = 0; efpar = 0; break; // 0&0 equals no effect
          case 1:ef = 0x0F; break; //s3m "A", set speed
          case 2:ef = 0x0B; break; //s3m "B", pattern jump
          case 3:ef = 0x0D; break; //s3m "C", pattern break
          case 4:ef = 0x11; break; //s3m "D", volumeslide
          case 5:ef = 0x12; break; //s3m "E", porta down
          case 6:ef = 0x13; break; //s3m "F", porta up
          case 7:ef = 0x03; break; //s3m "G", porta to note
          case 8:ef = 0x04; break; //s3m "H", vibrato
          case 9:ef = 0x14; break; //s3m "I", tremor
          case 10:ef = 0x00; break; //s3m "J", arpeggio
          case 11:ef = 0x06; break; //s3m "K", vibrato+volume slide
          case 12:ef = 0x05; break; //s3m "L", porta+volume slide
          case 15:ef = 0x09; break; //s3m "O", set sample offset
          case 17:ef = 0x15; break; //s3m "Q", retrig+volume slide
          case 18:ef = 0x07; break; //s3m "R", tremolo
          case 19: //s3m "S", S3M extended commands
           ef = 0x0E; //convert to mod ones.
           switch (efpar & 0xF0)
            {
             case 0x00:efpar = 0; break; //set filter, not sup.
             case 0x10:efpar = (efpar & 0x0F) | 0x30; break; //glissando, not sup.
             case 0x20:efpar = (efpar & 0x0F) | 0x50; break; //set finetune
             case 0x30:efpar = (efpar & 0x0F) | 0x40; break; //set vibrato waveform
             case 0x40:efpar = (efpar & 0x0F) | 0x70; break; //set tremolo waveform
             case 0x80:efpar = (efpar & 0x0F) | 0x80; break; //set pan position
             case 0xA0: //stereo control, convert to "set pan"-format
              efpar &= 0x0F;
              if (efpar > 7) efpar -= 8; else efpar += 8;
              efpar |= 0x80;
              break;
             case 0xB0:efpar = (efpar & 0x0F) | 0x60; break; //pattern loop
             case 0xC0:break; //note cut
             case 0xD0: //note delay
               ef     = 0x18;
               efpar &= 0x0F;
               break;
             case 0xE0:break; //pattern delay
             case 0xF0:efpar = 0;break; //funk repeat, invert loop, not supported.
             default:break;
            }
           break;
          case 20:ef = 0x10; break; //set tempo (bpm)
          case 21:ef = 0x16; break; //fine vibrato
          case 22:ef = 0x17; break; //global volume
         }
         skriv_hit[2] = ef; //effect
         skriv_hit[3] = efpar; //effect parameter
       }
      } else _row++; //end if _b>0
     } //end while
  } //end for
// printf("patterns read!\n");

// printf("reading samples..");
// fflush(stdout);
 for (i = 1; i <= module.instruments; i++) if (samples[i].length > 0)
   {
    fseek(f, 16 * (unsigned int)pp.data[i] + module.file_offset, SEEK_SET);
    a = samples[i].length;
/*    printf("sample %d; length: %d, loop: %d-%d (l%d) \n",i,a,samples[i].loop_start,samples[i].loop_endi,samples[i].loop_length);
    getch();*/

/*
    samples[i].data=(char *)malloc(a+4);
    if (samples[i].data==NULL) printf("OUT OF MEMORY!\n");
    if (-1==fread(samples[i].data,1,a,f)) printf("LOAD ERROR!\n");
*/
   if (_output.loadsample_8_bits_raw_from_opened_file_curpos(f, i,
           samples[i].c2spd, samples[i].pan, samples[i].loop_start,
           samples[i].loop_endi, samples[i].length, 0x00) != 0)
   {
     free_mod(); /* release patterns'n'samples */
     fclose(f);
     strcat(error, "load_s3m: unable to load samples.\n");
     return -1;
   }
   } // else printf("sample %d unused.\n",i);
// getch();
// printf("samples read!\n");

 module.max_volume  = 64;
 module.maxsamples  = s3m_header.insnum + 1;
 module.speed       = s3m_header.i_s;
 module.bpm         = s3m_header.i_t;
 module.minporta    = 14;
 module.maxporta    = 27392;

// mastervolume(s3m_header.g_v); /*global volume */
 module.init_master = s3m_header.g_v;
/* printf("speed: %d, tempo: %d \n",module.speed,module.bpm); */
 printf("ok!\n");
 fflush(stdout);
 fclose(f);
 return 0;
}

