/************************************************************************/
/* interfac.c, interface code.                                          */
/************************************************************************/

#include "interfac.h"  // interface header
#include "devices.h"   // sound output devices
#include "playing.h"   // tracking code
#include "mod.h"       // mod loader header
#include "s3m.h"       // s3m loader header
#include "xm.h"        // xm loader header
#include "voc.h"       // voc loader header

void free_mod()
{
 int i;

 for (i = 0; i <= module.patterns; i++)
   if (module.pattern[i].data != NULL) free(module.pattern[i].data);

 if (module.pattern != NULL) free(module.pattern);
 if (instruments != NULL) free(instruments);

 freeallsamples();
}

void lopeta(int code)
{
 printf("%s", error);
 exit(code);
}

int load_tune(char *name)   // load mod, s3m and xm files. 0 ok, -1 error.
{
 strupr(name);

 if ((int)strstr(name,".MOD"))
   return load_mod(name); else

 if ((int)strstr(name,".S3M"))
   return load_s3m(name); else

 if ((int)strstr(name,".XM"))
   return load_xm(name);

 return -1;
}

int HubrisModulePlayer()
{
  printf("\r* HMP v1.06 is Copyright (c) 1997 by Chem of Hubris *\n");
  fflush(stdout);
  module.file_offset  = 0;
  module.sample_space = 0;
  memset(error, 0, sizeof(error));
  __init_sam_engine();
  return 0;
}

// end of file
