/**
 ** MODETEST.C ---- test all available graphics modes
 **
 ** Copyright (c) 1995 Csaba Biegl, 820 Stirrup Dr, Nashville, TN 37221
 ** [e-mail: csaba@vuse.vanderbilt.edu] See "doc/copying.cb" for details.
 **/

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

#include "grx20.h"
#include "drawing.h"

typedef struct {
    int  w,h,bpp;
} gvmode;

gvmode grmodes[200];

gvmode *collectmodes(const GrVideoDriver *drv,gvmode *gp)
{
	GrFrameMode fm;
	const GrVideoMode *mp;
	for(fm = GR_frameHERC1; fm <= GR_frameSVGA32H; fm++) {
	    for(mp = GrFirstVideoMode(fm); mp; mp = GrNextVideoMode(mp)) {
		gp->w	= mp->width;
		gp->h	= mp->height;
		gp->bpp = mp->bpp;
		gp++;
	    }
	}
	return(gp);
}

int vmcmp(const void *m1,const void *m2)
{
	gvmode *md1 = (gvmode *)m1;
	gvmode *md2 = (gvmode *)m2;
	if(md1->bpp != md2->bpp) return(md1->bpp - md2->bpp);
	if(md1->w   != md2->w  ) return(md1->w	 - md2->w  );
	if(md1->h   != md2->h  ) return(md1->h	 - md2->h  );
	return(0);
}

void main(void)
{
	static int firstgr = 1;
	GrSetDriver(NULL);
	if(GrCurrentVideoDriver() == NULL) {
	    printf("No graphics driver found\n");
	    exit(1);
	}
	for( ; ; ) {
	    int  nmodes = (int)(collectmodes(GrCurrentVideoDriver(),grmodes) - grmodes);
	    int  i,w,h,px,py;
	    char m1[40],m2[40];
	    GrSetMode(GR_default_text);
	    if(nmodes == 0) {
		printf("No graphics modes found\n");
		exit(1);
	    }
	    qsort(grmodes,nmodes,sizeof(grmodes[0]),vmcmp);
	    printf(
		"Graphics driver: \"%s\"\n"
		"  graphics defaults: %dx%d %ld colors\n"
		"  text defaults: %dx%d %ld colors\n\n",
		GrCurrentVideoDriver()->name,
		GrDriverInfo->defgw,
		GrDriverInfo->defgh,
		GrDriverInfo->defgc,
		GrDriverInfo->deftw,
		GrDriverInfo->defth,
		GrDriverInfo->deftc
	    );
	    m1[0] = m2[0] = '\0';
	    for(i = 0; i < nmodes; i++) {
		strcpy(m1,m2);
		sprintf(m2,
		    "  %2d)  %4dx%-4d %ld colors",
		    i + 1,
		    grmodes[i].w,
		    grmodes[i].h,
		    1L << grmodes[i].bpp
		);
		if(i & 1) printf("%-40s%s\n",m1,m2);
	    }
	    if(nmodes & 1) printf("%s\n",m2);
	    printf("\nEnter choice #, or anything else to quit> ");
	    fflush(stdout);
	    if(!gets(m1) || (sscanf(m1,"%d",&i) != 1) || (i < 1) || (i > nmodes)) {
		exit(0);
	    }
	    if(firstgr) {
		printf(
		    "When in graphics mode, press <CR> to return to menu.\n"
		    "Now press <CR> to continue..."
		);
		fflush(stdout);
		gets(m1);
		firstgr = 0;
	    }
	    i--;
	    GrSetMode(
		GR_width_height_color_graphics,
		grmodes[i].w,
		grmodes[i].h,
		1L << grmodes[i].bpp
	    );
	    w = GrScreenX() >> 1;
	    h = GrScreenY() >> 1;
	    px = w + 5;
	    py = h + 5;
	    w -= 10;
	    h -= 10;
	    drawing(
		5,5,w,h,
		GrBlack(),
		GrWhite()
	    );
	    drawing(
		px,5,w,h,
		GrAllocColor(255,0,0),
		GrAllocColor(0,255,0)
	    );
	    drawing(
		5,py,w,h,
		GrAllocColor(0,0,255),
		GrAllocColor(255,255,0)
	    );
	    drawing(
		px,py,w,h,
		GrAllocColor(255,0,255),
		GrAllocColor(0,255,255)
	    );
	    gets(m1);
	}
}

