/**
 ** DUMPFONT.C ---- write a C source file from a font in memory
 **
 ** Copyright (c) 1995 Csaba Biegl, 820 Stirrup Dr, Nashville, TN 37221
 ** [e-mail: csaba@vuse.vanderbilt.edu] See "doc/copying.cb" for details.
 **/

#include <string.h>
#include <stdio.h>

#include "libgrx.h"

/* ----------------------------------------------------------------------- */
static char bitmaphdr[] = "
#define  %s	FONTNAME_TEMPORARY_REDIRECTION
#include \"grx20.h\"
#undef	 %s

static char far %sbits[] = {
";
/* ----------------------------------------------------------------------- */
static char fonthdr[] = "
struct {
    GrFont	  theFont;
    GrFontChrInfo rest[%d];
} %s = {
    {
	{			/* font header */
	    \"%s\",		/* font name */
	    \"%s\",		/* font family name */
	    %d,			/* characters have varying width */
	    0,			/* derived from a scalable font */
	    1,			/* font permanently linked into program */
	    GR_FONTCVT_NONE,	/* 'tweaked' font (resized, etc..) */
	    %d,			/* width (average when proportional) */
	    %d,			/* font height */
	    %d,			/* baseline pixel pos (from top) */
	    %d,			/* underline pixel pos (from top) */
	    %d,			/* underline width */
	    %d,			/* lowest character code in font */
	    %d			/* number of characters in font */
	},
	%sbits,			/* character bitmap array */
	0,			/* auxiliary bitmap */
	%d,			/* width of narrowest character */
	%d,			/* width of widest character */
	0,			/* allocated size of auxiliary bitmap */
	0,			/* free space in auxiliary bitmap */
	{  0		},	/* converted character bitmap offsets */
	{{ %d,  0	}}	/* first character info */
    },
    {\
";
/* ----------------------------------------------------------------------- */
static char charinfo[] = "
	{  %d,  %d	}%c	/* info for character %d */\
";
/* ----------------------------------------------------------------------- */
static char fontend[] = "
    }
};
";
/* ----------------------------------------------------------------------- */

void GrDumpFont(GrFont *f,char *CsymbolName,char *fileName)
{
	int i;
	FILE *fp = fopen(fileName,"w");
	if(!fp) return;
	fprintf(fp,bitmaphdr,CsymbolName,CsymbolName,f->h.name);
	for(i = 0; i < f->h.numchars; i++) {
	    int  chr = i + f->h.minchar;
	    int  len = GrFontCharBitmapSize(f,chr);
	    int  pos = 0,j;
	    char far *bmp = GrFontCharBitmap(f,chr);
	    putc('\t',fp);
	    for(j = 0; j < len; j++) {
		fprintf(fp,"0x%02x",(bmp[j] & 0xff));
		if((j + 1) != len) {
		    putc(',',fp);
		    if(++pos == 16) fputs("\n\t",fp), pos = 0;
		}
	    }
	}

	fclose(fp);
}






