/**
 ** CUSTLINE.H
 **
 ** Copyright (c) 1995 Csaba Biegl, 820 Stirrup Dr, Nashville, TN 37221
 ** [e-mail: csaba@vuse.vanderbilt.edu] See "doc/copying.cb" for details.
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "libgrx.h"
#include "shapes.h"

void GrPatternedPolyLine(int numpts,int points[][2],GrLinePattern *lp)
{
	GrCustomLineData args;

	_GrBuildCustomLineData(lp->lnp_option,&args);
	_GrSetupPatternedDraw(lp->lnp_pattern,&args);
	_GrDrawPolygon(numpts,points,
	    FALSE,
	    TRUE,
	    _GrDoCustomCorner,
	    _GrDoCustomSegment,
	    &args
	);
}

void GrPatternedPolygon(int numpts,int points[][2],GrLinePattern *lp)
{
	GrCustomLineData args;

	_GrBuildCustomLineData(lp->lnp_option,&args);
	_GrSetupPatternedDraw(lp->lnp_pattern,&args);
	_GrDrawPolygon(numpts,points,
	    TRUE,
	    TRUE,
	    _GrDoCustomCorner,
	    _GrDoCustomSegment,
	    &args
	);
}

void GrPatternedBox(int x1,int y1,int x2,int y2,GrLinePattern *lp)
{
	GrCustomLineData args;
	int points[4][2];

	points[0][0] = x1; points[0][1] = y1;
	points[1][0] = x1; points[1][1] = y2;
	points[2][0] = x2; points[2][1] = y2;
	points[3][0] = x2; points[3][1] = y1;
	_GrBuildCustomLineData(lp->lnp_option,&args);
	_GrSetupPatternedDraw(lp->lnp_pattern,&args);
	_GrDrawPolygon(4,points,
	    TRUE,
	    TRUE,
	    _GrDoCustomCorner,
	    _GrDoCustomSegment,
	    &args
	);
}

