/**
 ** RAM24.C ---- the 16M color system RAM frame driver
 **
 ** Copyright (c) 1995 Csaba Biegl, 820 Stirrup Dr, Nashville, TN 37221
 ** [e-mail: csaba@vuse.vanderbilt.edu] See "doc/copying.cb" for details.
 **/

#include "grdriver.h"
#include "libgrx.h"
#include "mempeek.h"

static
#ifdef __GNUC__
inline
#endif
long readpixel(GrFrame *c,int x,int y)
{
	char far *ptr = &c->gf_baseaddr[0][(y * c->gf_lineoffset) + (x * 3)];
	return((ushort)peek_w(ptr) + ((ulong)(uchar)peek_b(&ptr[2]) << 16));
}

static
#ifdef __GNUC__
inline
#endif
void drawpixel(int x,int y,long color)
{
	char far *ptr = &CURC->gc_baseaddr[0][(y * CURC->gc_lineoffset) + (x * 3)];
	uchar c2 = (uchar)(color >> 16);
	switch(C_OPER(color)) {
	  case C_XOR:
	    poke_w_xor(ptr,(ushort)color);
	    poke_b_xor(&ptr[2],c2);
	    break;
	  case C_OR:
	    poke_w_or(ptr,(ushort)color);
	    poke_b_or(&ptr[2],c2);
	    break;
	  case C_AND:
	    poke_w_and(ptr,(ushort)color);
	    poke_b_and(&ptr[2],c2);
	    break;
	  default:
	    poke_w(ptr,(ushort)color);
	    poke_b(&ptr[2],c2);
	    break;
	}
}

static
#include "fdrivers/generic/hline.c"

static
#include "fdrivers/generic/vline.c"

static
#include "fdrivers/generic/block.c"

static
#include "fdrivers/generic/line.c"

static
#include "fdrivers/generic/bitmap.c"

static
#include "fdrivers/generic/pattern.c"

static void bitblt(GrFrame *dst,int dx,int dy,GrFrame *src,int sx,int sy,int w,int h,long op)
{
	if(GrColorMode(op) == GrIMAGE) _GrFrDrvGenericBitBlt(
	    dst,dx,dy,
	    src,sx,sy,
	    w,h,
	    op
	);
	else _GrFrDrvPackedBitBltR2R(
	    dst,(dx * 3),dy,
	    src,(sx * 3),sy,
	    (w * 3),h,
	    op
	);
}

GrFrameDriver _GrFrameDriverRAM24 = {
    GR_frameRAM24,		/* frame mode */
    GR_frameUndef,		/* compatible RAM frame mode */
    FALSE,			/* onscreen */
    4,				/* scan line width alignment */
    1,				/* number of planes */
    24,				/* bits per pixel */
#ifdef __TURBOC__
    65520L,			/* max plane size the code can handle */
#else
    24*16*1024L*1024L,		/* max plane size the code can handle */
#endif
    NULL,
    readpixel,
    drawpixel,
    drawline,
    drawhline,
    drawvline,
    drawblock,
    drawbitmap,
    drawpattern,
    bitblt,
    NULL,
    NULL,
};

