/**
 ** U_VESA.C ---- interface utility functions to VESA BIOS inquiry calls
 **
 ** Copyright (c) 1995 Csaba Biegl, 820 Stirrup Dr, Nashville, TN 37221
 ** [e-mail: csaba@vuse.vanderbilt.edu] See "doc/copying.cb" for details.
 **/

#include "libgrx.h"
#include "allocate.h"
#include "vesa.h"
#include "mempeek.h"
#include "memfill.h"
#include "int86.h"

#ifndef IREG_ES

int _GrViDrvVESAgetVGAinfo(VESAvgaInfoBlock *ib)
{
	return(FALSE);
}
int _GrViDrvVESAgetModeInfo(int mode,VESAmodeInfoBlock *ib)
{
	return(FALSE);
}

#else

int _GrViDrvVESAgetVGAinfo(VESAvgaInfoBlock *ib)
{
	static char  *nmcopy = NULL;
	static short *mdcopy = NULL;
	Int86Regs regs;
	short far *mp;
	short *modes;
	char far *p1;
	char *p2;
	int  ii;
	DECLARE_XFER_BUFFER(1000);
	/*
	 * set up registers and call interrupt
	 */
	sttzero(&regs);
	IREG_AX(regs) = VESA_FUNC + VESA_VGA_INFO;
	IREG_ES(regs) = FP_SEG(XFER_BUFFER);
	IREG_DI(regs) = FP_OFF(XFER_BUFFER);
	int10(&regs);
	if(IREG_AX(regs) != VESA_SUCCESS) return(FALSE);
	/*
	 * copy VESA info block into accessible memory
	 */
	setup_far_selector(LINP_SEL(XFER_BUFFER));
	p1 = (char far *)LINP_PTR(XFER_BUFFER);
	p2 = (char *)ib;
	for(ii = sizeof(*ib); --ii >= 0; p1++,p2++) *p2 = peek_b_f(p1);
	if(ib->VESAsignature[0] != 'V') return(FALSE);
	if(ib->VESAsignature[1] != 'E') return(FALSE);
	if(ib->VESAsignature[2] != 'S') return(FALSE);
	if(ib->VESAsignature[3] != 'A') return(FALSE);
	/*
	 * allocate space and copy mode list into accessible memory
	 */
	mp = LINP_PTR(MK_FP(FP86_SEG(ib->VideoModePtr),FP86_OFF(ib->VideoModePtr)));
	p1 = (char far *)mp;
	for(ii = 1; (short)peek_w_f(mp) != (short)(-1); mp++,ii++);
	modes = mdcopy = realloc(mdcopy,ii * sizeof(short));
	if(!modes) return(FALSE);
	ib->VideoModePtr = modes;
	mp = (short far *)p1;
	for( ; --ii >= 0; mp++,modes++) *modes = peek_w_f(mp);
	/*
	 * allocate space and copy ID string into accessible memory
	 */
	p1 = LINP_PTR(MK_FP(FP86_SEG(ib->OEMstringPtr),FP86_OFF(ib->OEMstringPtr)));
	mp = (short far *)p1;
	for(ii = 1; (char)peek_b_f(p1) != (char)(0); p1++,ii++);
	p2 = nmcopy = realloc(nmcopy,ii * sizeof(char));
	if(!p2) return(FALSE);
	ib->OEMstringPtr = p2;
	p1 = (char far *)mp;
	for( ; --ii >= 0; p1++,p2++) *p2 = peek_b_f(p1);
	return(TRUE);
}

int _GrViDrvVESAgetModeInfo(int mode,VESAmodeInfoBlock *ib)
{
	Int86Regs regs;
	char far *p1;
	char *p2;
	int  ii;
	DECLARE_XFER_BUFFER(1000);
	/*
	 * set up registers and call interrupt
	 */
	sttzero(&regs);
	IREG_AX(regs) = VESA_FUNC + VESA_MODE_INFO;
	IREG_CX(regs) = mode;
	IREG_ES(regs) = FP_SEG(XFER_BUFFER);
	IREG_DI(regs) = FP_OFF(XFER_BUFFER);
	int10(&regs);
	if(IREG_AX(regs) != VESA_SUCCESS) return(FALSE);
	/*
	 * copy VESA info block into accessible memory
	 */
	setup_far_selector(LINP_SEL(XFER_BUFFER));
	p1 = (char far *)LINP_PTR(XFER_BUFFER);
	p2 = (char *)ib;
	for(ii = sizeof(*ib); --ii >= 0; p1++,p2++) *p2 = peek_b_f(p1);
	return((ib->ModeAttributes & MODE_SUPPORTED) ? TRUE : FALSE);
}

#endif

