/**
 ** VESA.H ---- VESA BIOS extensions function codes, structures and return codes
 **
 ** Copyright (c) 1995 Csaba Biegl, 820 Stirrup Dr, Nashville, TN 37221
 ** [e-mail: csaba@vuse.vanderbilt.edu] See "doc/copying.cb" for details.
 **/

#define VESA_FUNC	0x4f00
#define VESA_SUCCESS	0x004f

#define VESA_VERSION(major,minor)	((((major) & 0xff) << 8) | ((minor) & 0xff))
#define VESA_VERSION_MAJOR(vers)	(((vers) >> 8) & 0xff)
#define VESA_VERSION_MINOR(vers)	((vers) & 0xff)

/*
 * VESA BIOS sub-function numbers
 */
#define VESA_VGA_INFO	0		/* get VGA adapter info */
#define VESA_MODE_INFO  1		/* get SVGA mode info */
#define VESA_SET_MODE	2		/* set video mode */
#define VESA_GET_MODE	3		/* get current video mode */
#define VESA_VGA_STATE  4		/* save/restore VGA state */
#define VESA_PAGE_CTL	5		/* memory control */
/* VESA 1.1 +++ */
#define VESA_SCAN_LNLEN 6		/* set/get scan line length */
#define VESA_DISP_START 7		/* set/get display start address */
/* VESA 1.2 +++ */
#define VESA_PAL_CNTRL  8		/* DAC palette control */

#ifdef  __GNUC__
#define PACK		__attribute__((packed))
#else
#define PACK
#endif

/*
 * The VGA info structure (without padding)
 */
typedef struct {
    char	VESAsignature[4]  PACK;	    /* should be "VESA" */
    short	VESAversion	  PACK;	    /* VESA version number */
    char   far *OEMstringPtr	  PACK;	    /* Pointer to OEM string */
    long	Capabilities	  PACK;	    /* capabilities of the video env */
    short  far *VideoModePtr	  PACK;	    /* ptr to supported Super VGA modes */
    /* ==== VESA 1.2 and later ==== */
    short	MemorySize	  PACK;	    /* # of 64K pages */
} VESAvgaInfoBlock;

/*
 * The mode information structure (without padding)
 */
typedef struct {
    short	ModeAttributes	  PACK;	    /* mode attributes */
    char	WinAAttributes	  PACK;	    /* Window A attributes */
    char	WinBAttributes	  PACK;	    /* Window B attributes */
    short	WinGranularity	  PACK;	    /* window granularity */
    short	WinSize		  PACK;	    /* window size */
    short	WinASegment	  PACK;	    /* Window A start segment */
    short	WinBSegment	  PACK;	    /* Window B start segment */
    void far  (*WinFuncPtr)()	  PACK;	    /* pointer to window function */
    short	BytesPerScanLine  PACK;	    /* bytes per scan line */
    /* ==== extended and optional information ==== */
    short	XResolution	  PACK;	    /* horizontal resolution */
    short	YResolution	  PACK;	    /* vertical resolution */
    char	XCharSize	  PACK;	    /* character cell width */
    char	YCharSize	  PACK;	    /* character cell height */
    char	NumberOfPlanes	  PACK;	    /* number of memory planes */
    char	BitsPerPixel	  PACK;	    /* bits per pixel */
    char	NumberOfBanks	  PACK;	    /* number of banks */
    char	MemoryModel	  PACK;	    /* memory model type */
    char	BankSize	  PACK;	    /* bank size in K */
    char	NumImagePages	  PACK;	    /* number of image pages */
    char	reserved[1]	  PACK;
    /* ==== VESA 1.2 and later ==== */
    char	RedMaskSize	  PACK;	    /* number of bits in red mask */
    char	RedMaskPos	  PACK;	    /* starting bit for red mask */
    char	GreenMaskSize	  PACK;
    char	GreenMaskPos	  PACK;
    char	BlueMaskSize	  PACK;
    char	BlueMaskPos	  PACK;
    char	ReservedMaskSize  PACK;	    /* reserved bits in pixel */
    char	ReservedMaskPos	  PACK;
    char	DirectScreenMode  PACK;
} VESAmodeInfoBlock;

#undef  PACK

/*
 * MODE attribute bits
 */
#define MODE_SUPPORTED  1		/* Mode supported in hardware */
#define MODE_EXTINFO	2		/* Extended information available */
#define MODE_SUPBIOS	4		/* Text output supported by BIOS */
#define MODE_ISCOLOR	8		/* Monochrome/color mode */
#define MODE_ISGRAPHICS 16		/* Mode type (0: text, 1:graphics) */

/*
 * Window attribute bits
 */
#define WIN_SUPPORTED	1		/* Window supported */
#define WIN_READABLE	2		/* Window readable */
#define WIN_WRITABLE	4		/* Window writable */

/*
 * MemoryModel values
 */
#define MODEL_TEXT	0		/* 00h = Text mode */
#define MODEL_CGA	1		/* 01h = CGA graphics */
#define MODEL_HERC	2		/* 02h = Hercules graphics */
#define MODEL_4PLANE	3		/* 03h = 4-plane planar */
#define MODEL_PACKED	4		/* 04h = Packed pixel */
#define MODEL_256_NC	5		/* 05h = Non-chain 4, 256 color */
#define MODEL_DIRECT	6		/* 06h = direct color mode */
/* 07h-0Fh = Reserved, to be defined by VESA */
/* 10h-FFh = To be defined by OEM	     */

int _GrViDrvVESAgetVGAinfo(VESAvgaInfoBlock *ib);
int _GrViDrvVESAgetModeInfo(int mode,VESAmodeInfoBlock *ib);

