/**
 ** SVGA32H.C ---- the 16M color padded Super VGA frame driver (high)
 **
 ** Copyright (c) 1995 Csaba Biegl, 820 Stirrup Dr, Nashville, TN 37221
 ** [e-mail: csaba@vuse.vanderbilt.edu] See "doc/copying.cb" for details.
 **/

#include "grdriver.h"
#include "libgrx.h"
#include "arith.h"
#include "mempeek.h"

static long readpixel(GrFrame *c,int x,int y)
{
	long offs = umul32(y,SCRN->gc_lineoffset) + (x << 2);
	CHKBANK(BANKNUM(offs));
	setup_far_selector(SCRN->gc_selector);
	return((ulong)peek_l_f(&SCRN->gc_baseaddr[0][BANKPOS(offs)]) >> 8);
}

static void drawpixel(int x,int y,long color)
{
	long offs = umul32(y,CURC->gc_lineoffset) + (x << 2);
	char far *ptr = &CURC->gc_baseaddr[0][BANKPOS(offs)];
	int op = C_OPER(color);
	color <<= 8;
	CHKBANK(BANKNUM(offs));
	setup_far_selector(CURC->gc_selector);
	switch(op) {
	    case C_XOR: poke_l_f_xor(ptr,color); break;
	    case C_OR:  poke_l_f_or( ptr,color); break;
	    case C_AND: poke_l_f_and(ptr,color); break;
	    default:	poke_l_f(    ptr,color); break;
	}
}

static
#include "fdrivers/generic/hline.c"

static
#include "fdrivers/generic/vline.c"

static
#include "fdrivers/generic/block.c"

static
#include "fdrivers/generic/line.c"

static
#include "fdrivers/generic/bitmap.c"

static
#include "fdrivers/generic/pattern.c"

static void bitblt(GrFrame *dst,int dx,int dy,GrFrame *src,int sx,int sy,int w,int h,long op)
{
	if(GrColorMode(op) == GrIMAGE) _GrFrDrvGenericBitBlt(
	    dst,dx,dy,
	    src,sx,sy,
	    w,h,
	    op
	);
	else _GrFrDrvPackedBitBltV2V(
	    dst,(dx << 2),dy,
	    src,(sx << 2),sy,
	    (w << 2),h,
	    op
	);
}

static void bltv2r(GrFrame *dst,int dx,int dy,GrFrame *src,int sx,int sy,int w,int h,long op)
{
	if(GrColorMode(op) == GrIMAGE) _GrFrDrvGenericBitBlt(
	    dst,dx,dy,
	    src,sx,sy,
	    w,h,
	    op
	);
	else _GrFrDrvPackedBitBltV2R(
	    dst,(dx << 2),dy,
	    src,(sx << 2),sy,
	    (w << 2),h,
	    op
	);
}

static void bltr2v(GrFrame *dst,int dx,int dy,GrFrame *src,int sx,int sy,int w,int h,long op)
{
	if(GrColorMode(op) == GrIMAGE) _GrFrDrvGenericBitBlt(
	    dst,dx,dy,
	    src,sx,sy,
	    w,h,
	    op
	);
	else _GrFrDrvPackedBitBltR2V(
	    dst,(dx << 2),dy,
	    src,(sx << 2),sy,
	    (w << 2),h,
	    op
	);
}

GrFrameDriver _GrFrameDriverSVGA32H = {
    GR_frameSVGA32H,		/* frame mode */
    GR_frameRAM32H,		/* compatible RAM frame mode */
    TRUE,			/* onscreen */
    4,				/* line width alignment */
    1,				/* number of planes */
    32,				/* bits per pixel */
    32*16*1024L*1024L,		/* max plane size the code can handle */
    NULL,
    readpixel,
    drawpixel,
    drawline,
    drawhline,
    drawvline,
    drawblock,
    drawbitmap,
    drawpattern,
    bitblt,
    bltv2r,
    bltr2v
};

