// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

#ifndef POLYGON_H
#define POLYGON_H

#include "gfx/bitmap.h"
#include "gfx/vector2d.h"
#include "compiler/types.h"

struct Polygon
  {
  short Vertices;
  Vector2D *Vertex;      // ptr to array of bitmap coordinates
  int Flags;
    enum {
    // The 'clockwise' flags are normally not set (then the poly draw
    // algo. computes the directions by itself). These flags are only
    // set, when polygons have been clipped. Then it can occur that after
    // the clipping process the polygon is not longer convex, but
    // very slightly concave. That's why its better to determine the
    // (counter-) clockwise order before the clipping process and to
    // store the result in the 'clockwise' flags.
    Clockwise=0x40,
    CounterClockwise=0x80 };
  Polygon() { Flags=0; };
  };

extern void (*FillPolyFunc[])(Bitmap& Dst,Polygon &Poly,ColorRef Color);
inline void FillPoly(Bitmap &Dst,Polygon& Poly,ColorRef Color) { (FillPolyFunc[Dst.ClassID()])(Dst,Poly,Color); };

#endif
