// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

#include "misc/error.h"
#include "gfx/palette.h"
#include "misc/template.h"

// Look up table saves us time in 'GetNearestColor' problem
int SquareTab[256];
class AutoInitSquareTab               
  {
  public:
  AutoInitSquareTab();
  } AutoInit;
AutoInitSquareTab::AutoInitSquareTab()
  {
  for (int i=0;i<=255;i++)
  SquareTab[i]=i*i;
  };

int PaletteNotifySetColor(Palette &,ColorRef,ColorRef) { return 1; };

Palette::Palette(Class ID,long colornum)
  {
  if (ID<1 && ID>5) ErrorHandler.Abort("Palette:constructor  invalid ClassID.");
  if (colornum<2) ErrorHandler.Abort("Palette:constructor  colors<2.");
  flags=0;
  classID=ID;
  colors=colornum;
  color=ID==ClassColorArray?new ColorRef[colors]:0;
  users=0;
  if (classID==ClassColorArray)
    {
    // Init palette entries.
    color[0]=RGB8(0,0,0); // black
    for (int Index=1;Index<colors;Index++) color[Index]=RGB8(255,255,255); // white
    }
  notifysetcolor=PaletteNotifySetColor;
  }
Palette::invalidate()
  {
  classID=ClassInvalid;
  color=0;
  colors=0;
  notifysetcolor=PaletteNotifySetColor;
  }
Palette::~Palette()
  {
  if (users!=0) ErrorHandler.Abort("Palette::~Palette  palette still in use, can't delete it.");
  delete [] color;
  invalidate();
  }




inline long ColorDiff(ColorRef Color1,long Color2) // both are RGB values
  {
  // bright colors must be higher weighted
  long Diff=
    Abs(SquareTab[RGB8Red(Color1)]-  SquareTab[RGB8Red(Color2)])+
    Abs(SquareTab[RGB8Green(Color1)]-SquareTab[RGB8Green(Color2)])+
    Abs(SquareTab[RGB8Blue(Color1)]- SquareTab[RGB8Blue(Color2)]);
  return(Diff);
  }
ColorRef Palette::getnearestcolor(ColorRef RGB)
  {
  // find the palette index to the nearest color in the palette.
  long MinDiff=3*(1L<<16); // MaxColorDiff (see ColorDiff())
  int BestIndex=0;
  int PalIndex=0;
  while (PalIndex<colors)
    {
    long Diff=ColorDiff(RGB,color[PalIndex]);
    if (Diff<MinDiff)
      {
      BestIndex=PalIndex;
      MinDiff=Diff;
      }
    PalIndex++;
    }
  return(BestIndex);
  }



//////////////////////// SetColor funcs //////////////////////////
void SetColorNoDC(Palette &Pal,ColorRef PalIndex,ColorRef RGB)
  {
  #ifdef DEBUG
  if (PalIndex<0 || PalIndex>Pal.Colors()) ErrorHandler.Abort("Palette::SetColor  wrong pal index");
  #endif
  Pal.color[PalIndex]=RGB;
  }
void SetColorInvalid(Palette&,ColorRef,ColorRef)
  {
  ErrorHandler.Abort("Palette::SetColor  invalid.");
  }
//////////////////// GetColor funcs: PalIndex -> RGB /////////////////
ColorRef GetColorNoDC(Palette &Pal,ColorRef PalIndex)
  {
  #ifdef DEBUG
  if (PalIndex<0 || PalIndex>Pal.Colors()) ErrorHandler.Abort("Palette::GetColor  wrong pal index");
  #endif
  return(Pal.color[PalIndex]);
  }
ColorRef GetColorDC1555(Palette &Pal,ColorRef PalIndex)
  {
//!!!!!!!!!
ErrorHandler.Abort("Palette::GetPalIndexDC1555 not yet implemented");
  return(-1);
  }
ColorRef GetColorDC565(Palette &Pal,ColorRef PalIndex)
  {
//!!!!!!!!!
ErrorHandler.Abort("Palette::GetPalIndex565 not yet implemented");
  return(-1);
  }
ColorRef GetColorDC888(Palette &,ColorRef PalIndex)
  {
  return(PalIndex|CRRGB8);
  }
ColorRef GetColorInvalid(Palette&,ColorRef)
  {
  ErrorHandler.Abort("Palette::GetColor  invalid");
  return(0);
  }
////////////////// GetPaletteIndex: RGB -> PalIndex //////////////////
ColorRef GetPaletteIndexNoDC(Palette &Pal,ColorRef RGB)
  {
  return(Pal.getnearestcolor(RGB));
  }
ColorRef GetPaletteIndexDC1555(Palette &,ColorRef RGB)
  {
  ColorRef Index;
  Index =(RGB>>9)&0x7c00;
  Index|=(RGB>>6)&0x03e0;
  Index|=(RGB>>3)&0x001f;
  return(Index);
  }
ColorRef GetPaletteIndexDC565(Palette &,ColorRef RGB)
  {
  ColorRef Index;
  Index =(RGB>>8)&0xf800;
  Index|=(RGB>>5)&0x07e0;
  Index|=(RGB>>3)&0x001f;
  return(Index);
  }
ColorRef GetPaletteIndexDC888(Palette &,ColorRef RGB)
  {
  return(RGB&0x00ffffff);
  }
ColorRef GetPaletteIndexInvalid(Palette&,ColorRef)
  {
  ErrorHandler.Abort("Palette:GetPalIndex  invalid");
  return(0);
  }

// Function tables 
static void (*Palette::SetColorFunc[Palette::FuncClasses])(Palette &Pal,ColorRef PalIndex,ColorRef RGB) =
  {
  SetColorInvalid,
  SetColorNoDC,
  SetColorInvalid,SetColorInvalid,SetColorInvalid,
  };
static ColorRef (*Palette::GetColorFunc[Palette::FuncClasses])(Palette &Palette,ColorRef PalIndex) =
  {
  GetColorInvalid,
  GetColorNoDC,
  GetColorDC1555,GetColorDC565,GetColorDC888,
  };
static ColorRef (*Palette::GetPaletteIndexFunc[Palette::FuncClasses])(Palette &Palette,ColorRef RGB) =
  {
  GetPaletteIndexInvalid,
  GetPaletteIndexNoDC,
  GetPaletteIndexDC1555,GetPaletteIndexDC565,GetPaletteIndexDC888,
  };

