// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

#include "gfx/bitmap.h"
#include "gfx/blit.h"
#include "gfx/fastmem.h"
#include "misc/error.h"

void (*FillRectFunc[Bitmap::Classes])(Bitmap& Dst,const Rect &SrcRect,ColorRef Filler);

void FillRect_Invalid(Bitmap&,const Rect&,ColorRef);
void FillRect_General(Bitmap&,const Rect&,ColorRef);
void FillRect_PP8(Bitmap&,const Rect&,ColorRef);
static class AutoInitFillRectFunc
  {
  public:
  AutoInitFillRectFunc()
    {
    for (int i=0;i<Bitmap::Classes;i++) FillRectFunc[i]=FillRect_General;
    FillRectFunc[Bitmap::ClassInvalid]=FillRect_Invalid;
    #if defined(ACCEL_FillRect_PP8) || defined(ACCEL_PP8)
    FillRectFunc[Bitmap::ClassPackedPixel8]=FillRect_PP8;
    #endif
    };
  } InitFillRectFunc;

void FillRect_Invalid(Bitmap&,const Rect&,ColorRef)
  {
  ErrorHandler.Abort("FillRect  invalid bitmap.");
  }
void FillRect_General(Bitmap &Dst,const Rect& DstRect,ColorRef Color)
  {
  #ifdef DEBUG
  // check the rect
  if (DstRect.Left<0 || DstRect.Top<0 || DstRect.Right>Dst.Width() || DstRect.Bottom>Dst.Height()) ErrorHandler.Abort("FillRect  rect exceeds bitmap.");
  #endif
  // Converting ColorRef to a palette index makes the loop much faster
  if (ColorRefType(Color)==CRRGB8) Color=Dst.Palette().GetPaletteIndex(Color); 
  int y=DstRect.Top;
  while (y<=DstRect.Bottom)
    {
    int x=DstRect.Left;
    while (x<=DstRect.Right)
      {
      Dst.SetPixel(x,y,Color);
      x++;
      }
    y++;
    }
  }

#if defined(ACCEL_FillRect_PP8) || defined(ACCEL_PP8)
void FillRect_PP8(Bitmap &Dst,const Rect& DstRect,ColorRef Color)
  {
  // get palette index
  if (ColorRefType(Color)==CRRGB8) Color=Dst.Palette().GetPaletteIndex(Color); 
  int RectWidth=DstRect.Right-DstRect.Left+1;  // first in pixels
  int RectHeight=DstRect.Bottom-DstRect.Top+1;
  #ifdef DEBUG
  // check the rect
  if (DstRect.Left<0 || DstRect.Top<0 || DstRect.Right>Dst.Width() || DstRect.Bottom>Dst.Height()) ErrorHandler.Abort("FillRect  rect exceeds bitmap.");
  #endif
  int DstDiff;
  DstDiff=Dst.WidthBytes()-RectWidth;
  unsigned char *DstPtr=Dst.Bits()+DstRect.Top*Dst.WidthBytes()+DstRect.Left;
  FastByteBlockSet(DstPtr,(UBYTE)Color,RectWidth,DstDiff,RectHeight);
  }
#endif
