// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

// Keyboard driver. Is automatically installed when this file is linked
// into your project.

//!!!! problems mit 6cluster ins,del,pos1,ende,pgup,dn und numlock
//!!!! problems with non-US keyboard sets

#include <compiler/types.h>
#include <mem.h>
#include <conio.h>
#include "device/keyboard.h"
#ifdef DEBUG
#include <iostream.h>
#endif

static const int KEY_BUFFER  =0x60;
static const int KEY_CONTROL =0x61;
static const int INT_CONTROL =0x20;
static const int KEYBOARD_INT=0x09;

// DOS
static WORD * const KeyFirst=(WORD * const)0x41a;
static WORD * const KeyLast=(WORD * const)0x41c;
static char * const KeyBuffer=(char * const)0x400;
static const int KeyBufferSize=16;
static const int KeyStart=0x1e;
static const int KeyEnd=0x3d;


KeyboardDriver Keyboard;
static int KeyboardDriver::installeddrivers;

enum // SpecialKey indices
  {
  IndexLeftShift,IndexRightShift,IndexControl,IndexAlt,
  IndexCapsLock,IndexNumLock
  };
static int SpecialKey[] =
  {
  42,54,29,56,58,69,
  };
const int ScanCodeNum=128;
const int AsciiKeyCodeNum=0x200;  

static int Scan2Ascii[ScanCodeNum] =
  {
  0xFF ,
  0x1B ,0x31 ,0x32 ,0x33 ,0x34 ,0x35 ,0x36 ,0x37 ,0x38 ,0x39 ,0x30 ,0x2D ,0x3D ,0x08 ,0x09 ,0x71 ,
  0x77 ,0x65 ,0x72 ,0x74 ,0x79 ,0x75 ,0x69 ,0x6F ,0x70 ,0x5B ,0x5D ,0x0D ,0xFF ,0x61 ,0x73 ,0x64 ,
  0x66 ,0x67 ,0x68 ,0x6A ,0x6B ,0x6C ,0x3B ,0x27 ,0x60 ,0xFF ,0x5C ,0x7A ,0x78 ,0x63 ,0x76 ,0x62 ,
  0x6E ,0x6D ,0x2C ,0x2E ,0x2F ,0xFF ,0x2A ,0xFF ,0x20 ,0xff ,0x13B,0x13C,0x13D,0x13E,0x13F,0x140,
  0x141,0x142,0x143,0x144,0xFF ,0xFF ,0x147,0x148,0x149,0x2d ,0x14B,0xFF ,0x14D,0x2b ,0x14F,0x150,
  0x151,0x152,0x153,0xFF ,0xFF ,0x15C,0x185,0x186,0xFF ,0xE8 ,0xB6 ,0xB7 ,0x1B8,0xFF ,0xFF ,0xFF ,
  0xFF ,0xFF ,0x1B9,0x1BA,0x1BB,0x1BC,0xBD ,0xBE ,0xBF ,0xC0 ,0xC1 ,0xFF ,0x1F0,0xFF ,0xFF ,0xFF ,
  0xFF ,0xFF ,0xFF ,0xFF ,0xFF ,0x1FB,0xFF ,0xFF ,0xFF ,0xFF ,0xFF ,0xFF ,0xFF ,0xFF ,0xFF
  };
static int ShiftScan2Ascii[ScanCodeNum] =
  {
  0xFF ,
  0x1B ,0x21 ,0x40 ,0x23 ,0x24 ,0x25 ,0x5E ,0x26 ,0x2A ,0x28 ,0x29 ,0x5F ,0x2B ,0x08 ,0x00 ,0x51 ,
  0x57 ,0x45 ,0x52 ,0x54 ,0x59 ,0x55 ,0x49 ,0x4F ,0x50 ,0x7B ,0x7D ,0x0D ,0xFF ,0x41 ,0x53 ,0x44 ,
  0x46 ,0x47 ,0x48 ,0x4A ,0x4B ,0x4C ,0x3A ,0x22 ,0x7E ,0xFF ,0x7C ,0x5A ,0x58 ,0x43 ,0x56 ,0x42 ,
  0x4E ,0x4D ,0x3C ,0x3E ,0x3F ,0xFF ,0x2A ,0xFF ,0x20 ,0xff ,0x154,0x155,0x156,0x157,0x158,0x159,
  0x15A,0x15B,0x15C,0x15D,0xFF ,0xFF ,0x37 ,0x38 ,0x39 ,0x2D ,0x34 ,0x35 ,0x36 ,0x2B ,0x31 ,0x32 ,
  0x33 ,0x30 ,0x2E ,0xFF ,0xFF ,0x17C,0x187,0x188,0xFF ,0x1E9,0x1C2,0x1C3,0x1C4,0xFF ,0xFF ,0xFF ,
  0xFF ,0xFF ,0x1C5,0x1C6,0x1C7,0x1C8,0x1C9,0x1CA,0x1CB,0x1CC,0x1CD,0xFF ,0x1F1,0xFF ,0xFF ,0xFF ,
  0xFF ,0xFF ,0xFF ,0xFF ,0xFF ,0x1FB,0xFF ,0xFF ,0xFF ,0xFF ,0xFF ,0xFF ,0xFF ,0xFF ,0xFF
  };
static int Ascii2Scan[AsciiKeyCodeNum];

// Must be called whenever a new key table (or the first one) is loaded.
void InitAscii2ScanTab()
  {
  for (int j=0;j<AsciiKeyCodeNum;j++) Ascii2Scan[j]=0;
  for (int i=0;i<ScanCodeNum;i++)
    {
    int Ascii;
    Ascii=Scan2Ascii[i];     
    if (Ascii<0 || Ascii>=0x200) ErrorHandler.Abort("key ini error.");
    if (Ascii!=0xff) Ascii2Scan[Ascii]=i;
    Ascii=ShiftScan2Ascii[i];
    if (Ascii<0 || Ascii>=0x200) ErrorHandler.Abort("key ini error.");
    if (Ascii!=0xff) Ascii2Scan[Ascii]=i;
    }
  }
static void RemoveKeyboardDriverOnError()
  {
  _dos_setvect(KEYBOARD_INT,Keyboard.oldint);
  Keyboard.flags=0;
  }
#pragma aux keyboardint frame; // because of a WATCOM bug (compile with no_debug_info and disassemble: ebp is modified and not restored -> stack crashes)
static void _interrupt _far keyboardint()
  {
  _disable();
  int ScanCode=inp(KEY_BUFFER);
  if (ScanCode&0x80)
    {
    // key released
    if (Keyboard.ispressed[ScanCode&0x7f])
      if (Keyboard.pressedkeys>0) Keyboard.pressedkeys--;
    Keyboard.ispressed[ScanCode&0x7f]=0;
    }
  else
    {
    // key pressed
    // mod NumLock flag if necessary (for ring buffer)
    if (ScanCode==SpecialKey[IndexNumLock] && Keyboard.ispressed[ScanCode]==0) Keyboard.flags^=KeyboardDriver::FlagNumLock;
    // mark key as pressed
    if (!Keyboard.ispressed[ScanCode]) Keyboard.pressedkeys++;
    Keyboard.ispressed[ScanCode]=1;
    Keyboard.waspressed[ScanCode]=1;
    // put ascii code in ring buffer (for GetKey())
    int Ascii=0xff; // invalid (flag)
    int Shift=Keyboard.ispressed[SpecialKey[IndexLeftShift]] || Keyboard.ispressed[SpecialKey[IndexRightShift]];
    // check for numlock:
    // when numlock is on, then a key press on the cluster6
    // (ins,pgup...) is sent as lshift+key (shit: sometimes vice versa)
    if (Keyboard.flags&KeyboardDriver::FlagNumLock && ScanCode>=71 && ScanCode<=83) Shift=!Shift; // exception:  numblock + cluster6 in 'numlock on' mode
    if (Shift)
      Ascii=ShiftScan2Ascii[ScanCode];
    else
      Ascii=Scan2Ascii[ScanCode];
    const int SpecialKeyFlag=Ascii&0x100;
    // put key code in DOS ring buffer
    if (Ascii!=0xff)  // e.g. numlock generates no ascii key code (=0xff)
      {
      int BufferedKeys=(*KeyLast-*KeyFirst)>>1;
      if (BufferedKeys<0) BufferedKeys=KeyBufferSize-BufferedKeys;
      if (BufferedKeys<KeyBufferSize-(SpecialKeyFlag?2:1)) // special key takes two entries: 1/code
        {
        if (SpecialKeyFlag)
          {
          KeyBuffer[*KeyLast  ]=0;
          KeyBuffer[*KeyLast+1]=(BYTE)Ascii;
          }
        else
          {
          KeyBuffer[*KeyLast  ]=(BYTE)Ascii;
          KeyBuffer[*KeyLast+1]=(BYTE)ScanCode;
          }
        *KeyLast+=2;
        if (*KeyLast>KeyEnd) *KeyLast=KeyStart;
        }
      }
    }
  outp(INT_CONTROL,0x20);
  _enable();
  }
KeyboardDriver::KeyboardDriver()
  {
  #ifdef DEBUG
  cout << "keyb ini start...";
  #endif
  if (installeddrivers++!=0) ErrorHandler.Abort("KeyboardDriver::constr  Two drivers collide.");
  memset((void*)ispressed,0,128);
  memset((void*)waspressed,0,128);
  flags=FlagInstalled;
  pressedkeys=0;
  oldint=_dos_getvect(KEYBOARD_INT);
  _dos_setvect(KEYBOARD_INT,keyboardint);
  ErrorHandler.AddCleanUpProc(RemoveKeyboardDriverOnError);
  // get DOS keyboard flags
  _disable();
  REGS regs;
  regs.h.ah=2;
  int386(0x16,&regs,&regs);
  int DOSflags=regs.h.al;
  if (DOSflags&0x20) flags|=FlagNumLock;
  /*
  if (DOSflags&0x10) flags|=FlagScrollLock;
  if (DOSflags&0x40) flags|=FlagCapsLock;
  if (DOSflags&0x80) flags|=FlagInsertOn;
  */
  _enable();
  #ifdef DEBUG
  cout << "keytab ini...";
  #endif
  InitAscii2ScanTab();
  #ifdef DEBUG
  cout << "done\n";
  #endif
  }
KeyboardDriver::~KeyboardDriver()
  {
  #ifdef DEBUG
  cout << "destructing keyboard driver .. ";
  #endif
  ErrorHandler.RemoveCleanUpProc(RemoveKeyboardDriverOnError);
  installeddrivers--;
  flags=0;
  _dos_setvect(KEYBOARD_INT,oldint);
  #ifdef DEBUG
  cout << "done\n";
  #endif
  }
int KeyboardDriver::GetKey() // emulate kbhit-getch, but return special keys with 0x100 mask (not 1+code)
  {
  int Ascii=0;
  if (*KeyFirst!=*KeyLast)
    {
    Ascii=KeyBuffer[*KeyFirst];
    if (Ascii==0) Ascii=KeyBuffer[*KeyFirst+1]|0x100; // special key like F1
    *KeyFirst+=2;
    if (*KeyFirst>KeyEnd) *KeyFirst=KeyStart;
    }
  return(Ascii);
  }
int KeyboardDriver::IsPressed(int Code)
  {
  if (!(Code&ScanCodeFlag)) Code=Ascii2Scan[Code];
  return(ispressed[Code&0x7f]);
  }
int KeyboardDriver::WasPressed(int Code)
  {
  if (!(Code&ScanCodeFlag)) Code=Ascii2Scan[Code];
  int Press=waspressed[Code&0x7f];
  waspressed[Code&0x7f]=0;
  return(Press);
  }
