// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

#ifndef GLIBDEMO_POLY_H
#define GLIBDEMO_POLY_H

inline int Random(int Max) // 0<=random<Max
  {
  return(rand()*(Max-1)/RAND_MAX);
  };

struct AnimatedTriangle : public Polygon
  {
  private:
  Rect Border;
  Vector2D VertexDst[3],VertexSrc[3];
  int MoveStartTime,MoveEndTime;
  ColorRef color;
  public:
  AnimatedTriangle();
  ~AnimatedTriangle();
  void SetBorder(const Rect &Border);
  void Color(ColorRef c) { color=c; };
  ColorRef Color() { return color; };
  void ChooseDestination();
  void Move(int Time);
  enum { GlobalTimeVal=1000 }; //  movement speed
  };
AnimatedTriangle::AnimatedTriangle()
  {
  Vertices=0;
  Vertex=0;
  };
void AnimatedTriangle::SetBorder(const Rect &b)
  {
  Border=b;
  Vertices=3;
  if (Vertex) delete Vertex;
  Vertex=new Vector2D[3];
  for (int i=0;i<3;i++)
    {
    Vertex[i].x=VertexSrc[i].x=VertexDst[i].x=Border.Left+Random(Border.Width ());
    Vertex[i].y=VertexSrc[i].y=VertexDst[i].y=Border.Top +Random(Border.Height());
    }
  MoveStartTime=MoveEndTime=SystemTimer.Time();
  ChooseDestination();
  };
AnimatedTriangle::~AnimatedTriangle() 
  {
  delete Vertex;
  Vertices=0;
  }
void AnimatedTriangle::Move(int Time) 
  {
  if (Time>MoveEndTime) ChooseDestination();
  int t=Time-MoveStartTime;
  int dt=MoveEndTime-MoveStartTime;  
  for (int i=0;i<3;i++)
    {
    Vertex[i].x=VertexSrc[i].x+(VertexDst[i].x-VertexSrc[i].x)*t/dt;
    Vertex[i].y=VertexSrc[i].y+(VertexDst[i].y-VertexSrc[i].y)*t/dt;
    }
  }
void AnimatedTriangle::ChooseDestination() 
  {
  for (int i=0;i<3;i++)
    {
    VertexSrc[i]=VertexDst[i];
    switch (Random(4))
      {
      case 0: VertexDst[i]=Vector2D(Border.Left,Border.Top+Random(Border.Height()));break;
      case 1: VertexDst[i]=Vector2D(Border.Right,Border.Top+Random(Border.Height()));break;
      case 2: VertexDst[i]=Vector2D(Border.Left+Random(Border.Width()),Border.Top);break;
      case 3: VertexDst[i]=Vector2D(Border.Right+Random(Border.Width()),Border.Bottom);break;
      }
    }
  MoveStartTime=MoveEndTime;
  MoveEndTime=MoveStartTime+GlobalTimeVal+Random(GlobalTimeVal);
  }

#endif
