// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

#ifndef DYNARRAY_H
#define DYNARRAY_H

#include "misc/error.h"

template <class T> class DynArray
  {
  private:
  int entries;
  T *entry;
  public:
  DynArray() : entry(0),entries(0) { };
  ~DynArray();
  void Insert(unsigned int Index);       // constructs a new T at position i
  void Delete(unsigned int Index);
  T &operator [](unsigned int Index) const;
  int Entries() const { return(entries); };
  };
template <class T> inline DynArray<T>::~DynArray()
  {
  delete [] entry;
  entry=0;
  entries=0;
  }
template <class T> void DynArray<T>::Insert(unsigned int Index)
  {
  #ifdef DEBUG
  if (Index>entries) ErrorHandler.Abort("DynArray: Insert");
  #endif
  T *NewEntry=new T[entries+1];
  for (int i=0;i<Index;i++) NewEntry[i]=entry[i];
  for (;i<entries;i++) NewEntry[i+1]=entry[i];
  delete [] entry;
  entry=NewEntry;
  entries++;
  }
template <class T> void DynArray<T>::Delete(unsigned int Index)
  {
  #ifdef DEBUG
  if (Index>=entries) ErrorHandler.Abort("DynArray: Delete");
  #endif
  entry[Index].~T();
  for (int i=Index+1;i<entries;i++) entry[i-1]=entry[i];
  entry[--entries].~T();
  }
template <class T> T &DynArray<T>::operator [](unsigned int Index) const
  {
  #ifdef DEBUG
  if (Index>=entries) ErrorHandler.Abort("DynArray: []");
  #endif
  return(entry[Index]);
  }


#endif
