// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

#include <fstream.h>
#include "misc/mem.h"
#include "compiler/types.h"
#include "gfx/bitmap.h"
#include "gfx/imageio.h"

struct PCXHeader
  {
  BYTE manufacturer;   // don't care
  BYTE version;        // 5 = version 3.0
  BYTE encoding;       // 1 = RLE 
  BYTE bits_per_pixel; // per plane
  WORD  xmin,ymin;
  WORD  xmax,ymax;
  WORD  hres;
  WORD  vres;
  BYTE palette16[48];  // only used for 16colors
  BYTE reserved;
  BYTE color_planes;
  WORD  bytes_per_line;
  WORD  palette_type;
  BYTE filler[58];
  };
const int BYTEMODE=0;
const int RUNMODE=1;

int LoadPCX(Bitmap &Bitmap,char *Name)
  {
  int Error=0;
  fstream PCXFile;
  PCXFile.open(Name,ios::binary|ios::in);
  if (PCXFile.is_open())
    {
    PCXHeader Header;
    PCXFile.read((char*)&Header,sizeof(struct PCXHeader));
    // check if header is valid:
    if (Header.version!=5) return(-2);              // wrong version -2
    if (Header.encoding!=1) return(-3);             // unknown encoding type
    int Width=Header.xmax-Header.xmin+1;
    int Height=Header.ymax-Header.ymin+1;
    Bitmap::Class ClassID;
    if (Header.bits_per_pixel==8 && Header.color_planes==1)
      ClassID=Bitmap::ClassPackedPixel8;
    else
      if (Header.bits_per_pixel==1 && Header.color_planes==1)
        ClassID=Bitmap::ClassPlanar1;
      else
        if (Header.bits_per_pixel==8 && Header.color_planes==3)
          ClassID=Bitmap::ClassDirectColor888;
        else
          return(-2); // unknown bitmap type
    Bitmap.Delete();      
    Bitmap.Construct(Width,Height,ClassID);
    // header OK, load pic
    PCXFile.seekg(128,ios::beg);
    unsigned char *BitmapPtr=Bitmap.Bits();
    int PCXBytesPerLine=Header.bytes_per_line*Header.color_planes;
    unsigned char *PCXLineData=new unsigned char[PCXBytesPerLine];
    for (int Line=0;Line<Bitmap.Height();Line++)
      {
      // RLE decode a line
      unsigned char *PCXPtr=PCXLineData;
      long i=0;
      while (i<PCXBytesPerLine)
        {
        unsigned char Byte;
        Byte=(BYTE)PCXFile.get();
        if (!PCXFile.good()) return(-4); // read error
        if (Byte>=0xc0)
          {
          int Count=Byte&0x3f;
          i+=Count;
          Byte=(BYTE)PCXFile.get();
          if (!PCXFile.good()) return(-4); // read error
          while (Count--) *PCXPtr++=Byte;
          }
        else
          {
          *PCXPtr++=Byte;
          i++;
          }
        }
      // copy the read line into the bitmap
      if (Bitmap.ClassID()!=Bitmap::ClassDirectColor888)
        {
        memcpy(BitmapPtr,PCXLineData,Bitmap.WidthBytes());
        BitmapPtr+=Bitmap.WidthBytes();
        }
      else
        // the first bytes_per_line bytes are red, then green, then blue.
        // Only DC888 supported.
        for (int x=0;x<Bitmap.Width();x++)
          {
          BitmapPtr[2]=PCXLineData[x]; // red
          BitmapPtr[1]=PCXLineData[x+Header.bytes_per_line]; // green
          BitmapPtr[0]=PCXLineData[x+Header.bytes_per_line+Header.bytes_per_line]; // blue
          BitmapPtr+=3;
          }
      }
    delete PCXLineData;
    if (Header.bits_per_pixel==8 && Header.color_planes==1)
      {
      // load palette
      const int Colors=256;
      PCXFile.seekg(-3*Colors,ios::end);
      for (int j=0;j<Colors;j++)
        {
        char Red=  (BYTE)PCXFile.get();
        char Green=(BYTE)PCXFile.get();
        char Blue= (BYTE)PCXFile.get();
        Bitmap.Palette().SetColor(j,RGB8(Red,Green,Blue));
        }
      if (!PCXFile.good()) return(-4); // read error
      }
    PCXFile.close();
    }
  else
    Error=-1; /* PCXFileNotFound */
  return(Error);
  }
