// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

#include "gfx/bitmap.h"
#include "gfx/poly.h"
#include "gfx/scanpoly.h"
#include "gfx/fastmem.h"

void (*FillPolyFunc[Bitmap::Classes])(Bitmap& Dst,Polygon &Poly,ColorRef Color);

void FillPoly_Invalid(Bitmap&,Polygon&,ColorRef);
void FillPoly_General(Bitmap&,Polygon&,ColorRef);
void FillPoly_PP8(Bitmap&,Polygon&,ColorRef);
static class AutoInitFillPolyFunc
  {
  public:
  AutoInitFillPolyFunc()
    {
    for (int i=0;i<Bitmap::Classes;i++) FillPolyFunc[i]=FillPoly_General;
    FillPolyFunc[Bitmap::ClassInvalid]=FillPoly_Invalid;
    #if defined(ACCEL_FillPoly_PP8) || defined(ACCEL_PP8)
    FillPolyFunc[Bitmap::ClassPackedPixel8]=FillPoly_PP8;
    #endif
    };
  } InitFillPolyFunc;



void FillPoly_Invalid(Bitmap &,Polygon&,ColorRef)
  {
  ErrorHandler.Abort("FillPoly()  Dst bitmap invalid.");
  }
void FillPoly_General(Bitmap &Bitmap,Polygon& Poly,ColorRef Color)
  {
  #ifdef DEBUG
  int Clipped=1;
  Vector2D *Vertex=&Poly.Vertex[0];
  for (int i=0;i<Poly.Vertices;i++)
    {
    if (Vertex->x<0 || Vertex->y<0 || Vertex->x>=Bitmap.Width() || Vertex->y>=Bitmap.Height()) Clipped=0;
    Vertex++;
    }
  if (!Clipped) ErrorHandler.Abort("FillPoly()  Poly exceeds bitmap (clip first).");
  #endif
  // scan line conversion
  int TopY=ScanConvertPoly(Poly);
  // color transformation: we need a palette index
  if (ColorRefType(Color)==CRRGB8) Color=Bitmap.Palette().GetPaletteIndex(Color);
  DWORD *xPtr=PolyEdgeX+TopY*2;
  int y=TopY;
  for (;;)
    {
    WORD xStart,xEnd;
    // instead of 
    //   xStart=xPtr[0]>>16;
    //   xEnd=  xPtr[1]>>16;
    // we use:
    xStart=((UWORD*)&xPtr[0])[DWORD_HIWORD_POS];
    if (xStart<0) break; // buffer end mark
    xEnd=  ((UWORD*)&xPtr[1])[DWORD_HIWORD_POS];
    for (int x=xStart;x<=xEnd;x++) Bitmap.SetPixel(x,y,Color);
    xPtr+=2;
    y++;
    }
  }

#if defined(ACCEL_FillPoly_PP8) || defined(ACCEL_PP8)
void FillPoly_PP8(Bitmap &Bitmap,Polygon& Poly,ColorRef Color)
  {
  #ifdef DEBUG
  int Clipped=1;
  Vector2D *Vertex=&Poly.Vertex[0];
  for (int i=0;i<Poly.Vertices;i++)     
    {
    if (Vertex->x<0 || Vertex->y<0 || Vertex->x>=Bitmap.Width() || Vertex->y>=Bitmap.Height()) Clipped=0;
    Vertex++;
    }
  if (!Clipped) ErrorHandler.Abort("FillPoly()  Poly exceeds bitmap (clip first).");
  #endif
  // scan line conversion
  int TopY=ScanConvertPoly(Poly);
  // color transformation: we need a palette index
  if (ColorRefType(Color)==CRRGB8) Color=Bitmap.Palette().GetPaletteIndex(Color);
  DWORD *xPtr=PolyEdgeX+TopY*2;
  UBYTE *DstPtrStart=Bitmap.Bits()+TopY*Bitmap.WidthBytes();
  for(;;)
    {
    WORD xStart,xEnd;
    // instead of 
    //   xStart=xPtr[0]>>16;
    //   xEnd=  xPtr[1]>>16;
    // we use:
    xStart=((UWORD*)&xPtr[0])[DWORD_HIWORD_POS];
    if (xStart<0) break; // buffer end mark
    xEnd=  ((UWORD*)&xPtr[1])[DWORD_HIWORD_POS];
    FastByteSet(DstPtrStart+xStart,(UBYTE)Color,xEnd-xStart+1);
    DstPtrStart+=Bitmap.WidthBytes();
    xPtr+=2;
    }
  }
#endif
