// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

// The fading function are designed for use with video modes that
// use color arrays, they won't work with HiColor/TrueColor modes.

#ifndef GFX_FADE_H
#define GFX_FADE_H

#include "gfx/palette.h"
#include "device/timer.h"
#include "misc/template.h"

class PaletteFader : private AlarmTimer
  {
  private:
  Palette *pal;
  int colors;      // backup of pal->Colors()
  ColorRef *startcolor;  
  enum Mode { ModeFadeIn,ModeFadeOut } mode;
  volatile int brightness;
  virtual void TimerHandler(int); // overload
  public:
  PaletteFader(Palette &Pal);
  ~PaletteFader() { delete startcolor;startcolor=0; };
  void Brightness(int Level); // 0<=Level<=256
  int  Brightness() const { return brightness; };
  int IsRunning() const { return(AlarmTimer::IsRunning()); };
  void FadeIn(int MilliSecs);
  void FadeOut(int MilliSecs);
  };

#endif
