// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

#ifndef BITMAP_H
#define BITMAP_H

#include "gfx/palette.h"


class Bitmap
  {
  public:
  enum Class {                       // <- class IDs
    ClassInvalid=0,
    ClassPackedPixel1=1,
    ClassPlanar1=1,                   // alias
    ClassPackedPixel8=2,
    ClassDirectColor1555=3,
    ClassDirectColor565=4,
    ClassDirectColor888=5 };
  enum {
    Classes=8,
    Log2Classes=3, };
  //////////////// protected section ////////////////////
  protected:
  Class classID;                 
  int width,height,widthbytes; // bytes per scanline and plane
  int planes;                  // depends on class
  int bitsperpixel;            //        "         ;as in vesa modes (4 in 16color mode)
  int bitsperpixelandplane;    //        "         ;e.g. 1 for 16col, or 8 for 256 color, 15 for 32K
  long planebytes,imagebytes;
  unsigned char *bits;         // mehrere Planes
  Palette *usedpalette;        // also used for DirectColor, though no palette entries are saved
  // private funcs.
  void invalidate();
  // Pixel manipulation (different for each bitmap type)
  static void (*SetPixelFunc[])(Bitmap& Src,int x,int y,ColorRef color);
  static ColorRef (*GetPixelFunc[])(Bitmap& Dst,int x,int y);
  /////////////////////// user functions ///////////////////////
  public:
  // Handling of bitmaps.
  void Construct(int w,int h,Class ClassID);
  Bitmap() { invalidate(); };
  Bitmap(int w,int h,Class ClassID) { invalidate();Construct(w,h,ClassID); };
  Bitmap& operator =(const Bitmap& Bitmap);
  ~Bitmap();
  void Delete() { this->Bitmap::~Bitmap(); };
  int UsePalette(Palette &Pal);
  inline ColorRef GetPixel(int x,int y) { return(GetPixelFunc[classID](*this,x,y)); };// { return((*getpixelfunc)(*this,x,y)); };  // these functions don't check if the pixel is inside the bitmap boundaries because of speed reasons (except #DEBUG is defined)
  inline ColorRef GetPixelRGB(int x,int y);
  inline void SetPixel(int x,int y,ColorRef c) { SetPixelFunc[classID](*this,x,y,c); }; // assumes that c is a palette index
  inline void SetPixelRGB(int x,int y,ColorRef c);                                // c may be RGB or palette index
  // Getting some bitmap infos.
  int IsValid() const { return(classID!=ClassInvalid); };
  Class ClassID() const { return(classID); };
  int Width() const { return(width); };
  int Height() const { return(height); };
  int Planes() const { return(planes); };
  int BitsPerPixel() const { return(bitsperpixel); };
  inline unsigned char *Bits() const { return(bits); };
  inline int WidthBytes() const { return(widthbytes); };
  inline int PlaneBytes() const { return(planebytes); };
  inline int ImageBytes() const { return(imagebytes); };
  Palette &Palette() const { return(*usedpalette); };
  };
inline void Bitmap::SetPixelRGB(int x,int y,ColorRef c)
  {
  if (c&0xff000000) c=usedpalette->GetPaletteIndex(c);
  SetPixel(x,y,c);
  };
inline ColorRef Bitmap::GetPixelRGB(int x,int y)
  {
  ColorRef c=GetPixel(x,y);
  return(usedpalette->GetColor(c));
  };

#endif
