// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

#ifndef MOUSE_H
#define MOUSE_H

class MouseDriver
  {
  private:
  static int InstalledDrivers;
  int flags;
    enum {
    Installed=1, };
  int x,y,button;
  public:
  MouseDriver();
  ~MouseDriver();
  int IsInstalled() { return(flags&Installed); };
  void SetVirtualWindow(int w,int h);
  int GetX() { return(x>>1); };
  int GetY() { return(y>>1); };
  int GetButton() { return(button); };
  enum {
    LeftButton=1,
    RightButton=2,
    MidButton=4, };
  int SetX(int x);
  int SetY(int y);
  friend void _loadds far MouseHandler(int max,int mcx,int mdx);
  };

extern MouseDriver Mouse; // the only instance, it's global

#endif
