// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

#pragma inline
#include <dos.h>
#include <i86.h>
#include <mem.h>
#include "misc/error.h"
#include "misc/mem.h"
#include "device/mouse.h"
#include <iostream.h>

MouseDriver Mouse;
static int MouseDriver::InstalledDrivers;

void _loadds far MouseHandler(int max,int mcx,int mdx)
  {
  #pragma aux MouseHandler parm [EBX] [ECX] [EDX]
  Mouse.x=mcx;
  Mouse.y=mdx;
  Mouse.button=max;
  }
MouseDriver::MouseDriver()
  {
cout << "mouse init start\n";
  if (InstalledDrivers!=0) ErrorExit("MouseDriver::constr  Two drivers collide.");
  flags=x=y=button=0;
  struct SREGS sregs;
  union REGS inregs,outregs;
  segread(&sregs);
  inregs.w.ax=0;
  int386(0x33,&inregs,&outregs);
  if (outregs.w.ax!=0)
    {
//    mov MouseType,ax /* Zahl der Mausknpfe */
    flags|=Installed;
    inregs.w.ax=2;
    int386(0x33,&inregs,&outregs);  // turn mouse pointer off
/*
    inregs.w.ax=7;
    inregs.w.cx=0;
    inregs.w.dx=Screen.Width()-1;
    int386(0x33,&inregs,&outregs);  // set width
    inregs.w.ax=8;
    inregs.w.cx=0;
    inregs.w.dx=Screen.Height()-1;
    int386(0x33,&inregs,&outregs);  // set area height
    inregs.w.ax=4;
    inregs.w.cx=0;
    inregs.w.dx=0;
    int386(0x33,&inregs,&outregs);  // move mouse to (0,0)
*/
    inregs.w.ax=12;
    inregs.w.cx=0xff;
    sregs.es=    FP_SEG(MouseHandler);
    inregs.x.edx=FP_OFF(MouseHandler);
    int386x(0x33,&inregs,&outregs,&sregs);  // init handler
    }
cout << "mouse init end\n";
  }
void MouseDriver::SetVirtualWindow(int w,int h)
  {
  union REGS inregs,outregs;
  inregs.w.ax=7;
  inregs.w.cx=0;
  inregs.w.dx=(w-1)<<1;
  int386(0x33,&inregs,&outregs);  // set width
  inregs.w.ax=8;
  inregs.w.cx=0;
  inregs.w.dx=(h-1)<<1;
  int386(0x33,&inregs,&outregs);  // set area height
  }
MouseDriver::~MouseDriver()
  {
  union REGS inregs,outregs;
  inregs.w.ax=0;
  int386(0x33,&inregs,&outregs);      // del event handler
  inregs.w.ax=2;
  int386(0x33,&inregs,&outregs);      // turn off mouse
  }
