// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

// benchmark test program:
// Determines the speed of your computer system, and the speed of some blitting functions.

#include <iostream.h>
#include <stdlib.h>
#include "device/keyboard.h"
#include "device/vesadrv.h"
#include "device/timer.h"
#include "gfx/bitmap.h"
#include "gfx/blit.h"

int v1,v2; // dummies (avoid optimization)
main()
  {
  cout << "testing, wait 10 seconds ...\n";
  SystemTimer.TimeVal(20);
  // create a palette that is compatible to the screen palette and
  // contains the colors we want (just reddish colors): 
  Palette &MyPalette=*new Palette(Palette::ClassColorArray,256);
  if (MyPalette.ClassID()==Palette::ClassColorArray) // otherwise the palette must belong to a true/hi color mode (colors are constant)
    for (int c=0;c<256;c++) MyPalette.SetColor(c,RGB8(c,0,0));
  MyPalette.SetFlags(Palette::AutoDelete); // delete Palette automatically if it is no longer used by a bitmap
  double fps_memcpy,fps_memset,fps_vidcpy=0,fps_vidcpy_svga=0;
  // memcpy
  {
  Bitmap HiddenScreen(320,200,Bitmap::ClassPackedPixel8);
  Bitmap Image(320,200,Bitmap::ClassPackedPixel8);
  Image.UsePalette(HiddenScreen.Palette()); // make bitmaps compatible
  int Frames=0;
  int StartTime=SystemTimer.Time();
  do
    {
    Frames++;
    CopyRect(HiddenScreen,0,0,Image,Rect(0,0,319,199)); 
    }
  while (SystemTimer.Time()-StartTime<1000);
  int Time=SystemTimer.Time()-StartTime;
  fps_memcpy=((double)Frames)*1000/Time;
  }
  // memset
  {
  Bitmap HiddenScreen(320,200,Bitmap::ClassPackedPixel8);
  int Frames=0;
  int StartTime=SystemTimer.Time();
  do
    {
    Frames++;
    FillRect(HiddenScreen,Rect(0,0,319,199),0); 
    }
  while (SystemTimer.Time()-StartTime<1000);
  int Time=SystemTimer.Time()-StartTime;
  fps_memset=((double)Frames)*1000/Time;
  }
  // cpy mem -> video 
  if (Video.SetMode(VideoDriver::VGA320x200x256)==0)  // if (noerror)
    {
    Bitmap HiddenScreen(320,200,Video.ClassID());
    HiddenScreen.UsePalette(MyPalette);
    Video.UsePalette(MyPalette);
    int Frames=0;
    int StartTime=SystemTimer.Time();
    do
      {
      Frames++;
      Video.BlitToScreen(0,0,HiddenScreen,Rect(0,0,319,199)); 
      }
    while (SystemTimer.Time()-StartTime<1000);
    int Time=SystemTimer.Time()-StartTime;
    fps_vidcpy=((double)Frames)*1000/Time;
    }
  // cpy mem -> video 
  if (Video.SetMode(VideoDriver::VESA640x480x256)==0
   || Video.SetMode(VideoDriver::VESA640x400x256)==0) 
    {
    // with bank/window switching
    Bitmap HiddenScreen(640,400,Video.ClassID());
    HiddenScreen.UsePalette(MyPalette);
    Video.UsePalette(MyPalette);
    int Frames=0;
    int StartTime=SystemTimer.Time();
    do
      {
      Frames++;
      Video.BlitToScreen(0,0,HiddenScreen,Rect(0,0,639,399)); 
      }
    while (SystemTimer.Time()-StartTime<1000);
    int Time=1000;
    fps_vidcpy_svga=((double)Frames)*1000/Time;
    }
  Video.RestoreInitialMode();
  cout << "copy ram       : " << fps_memcpy << "fps (320x200x256col)\n";
  cout << "set ram        : " << fps_memset << "fps\n";
  cout << "copy ram->video: " << fps_vidcpy << "fps\n";
  cout << "                 " << fps_vidcpy_svga << "fps (640x400x256col + real mode switch)\n";
{
  int *array=new int[1000];
  for (int i=0;i<1000;i++) array[i]=rand()+1;
  int Frames=0;
  int StartTime=SystemTimer.Time();
  int dummy=0x71c4;
  do
    {
    Frames++;
    for (int i=0;i<1000;i++)
      {
      dummy*=array[i];
      v1=dummy;
      dummy/=array[i];
      v2=dummy;
      }
    }
  while (SystemTimer.Time()-StartTime<1000);
  int Time=SystemTimer.Time()-StartTime;
  cout << "mul div        : " << ((double)Frames)/Time << " million\n";
  delete array;
}
{
  float *array=new float[1000];
  for (int i=0;i<1000;i++) array[i]=rand()+1;
  int Frames=0;
  int StartTime=SystemTimer.Time();
  float dummy=0x71c4;
  do
    {
    Frames++;
    for (int i=0;i<1000;i++)
      {
      dummy*=array[i];
      v1=dummy;
      dummy/=array[i];
      v2=dummy;
      }
    }
  while (SystemTimer.Time()-StartTime<1000);
  int Time=SystemTimer.Time()-StartTime;
  cout << "mul div        : " << ((double)Frames)/Time << " million\n";
  delete array;
}
  return(0);
  }
