// Copyright Kjell Schubert unbu@rz.uni-karlsruhe.de

// Fade in and out 2 images.
// (timer and interrupt controlled fading)

#include "device/keyboard.h"
#include "device/vesadrv.h"
#include "gfx/bitmap.h"
#include "gfx/imageio.h"
#include "gfx/fade.h"


main()
  {
  if (Video.SetMode(VideoDriver::VGA320x200x256)!=0) ErrorHandler.Abort("main()  Can't set VGA mode 13h.");
  // Load an image and check if the its compatible with the video mode.
  // If it were not compatible to the video we could easily convert it 
  // using CopyRectConverted(), but here we simply exit the program.
  Bitmap Image1,Image2;
  if (LoadPCX(Image1,"flower.pcx")!=0) ErrorHandler.Abort("main()  Can't load picture flower.pcx.");
  if (LoadPCX(Image2,"apple.pcx")!=0) ErrorHandler.Abort("main()  Can't load picture apple.pcx.");
  if (Image1.ClassID()!=Bitmap::ClassPackedPixel8) ErrorHandler.Abort("flower.pcx is not a 256 color image.");
  if (Image1.Width()!=Video.Width() || Image1.Height()!=Video.Height()) ErrorHandler.Abort("flower.pcx has not the same size as the screen.");
  if (Image2.ClassID()!=Bitmap::ClassPackedPixel8) ErrorHandler.Abort("apple.pcx is not a 256 color image.");
  if (Image2.Width()!=Video.Width() || Image2.Height()!=Video.Height()) ErrorHandler.Abort("apple.pcx has not the same size as the screen.");
  // fade in Image1
  {PaletteFader Fader(Image1.Palette()); // this fader is now compatible to Image1 palette, and will fade in 1 second (=1000ms) from black <-> color
  Fader.Brightness(0);                       // set all colors in image1.palette to black
  Video.UsePalette(Image1.Palette());        // the screen will be black now (because Image1.Palette() is all black right now)
  Video.BlitToScreen(0,0,Image1,Rect(0,0,319,199)); // copy the (black) image onto the screen
  Fader.FadeIn(2000);                              // start fading
  while (Fader.IsRunning());
  // wait for key press
  while (!Keyboard.GetKey());
  // fade out
  Fader.FadeOut(2000);
  while (Fader.IsRunning());}
  // fade in Image2
  // just do the same as in the  image1 block
  {PaletteFader Fader(Image2.Palette()); // this fader is now compatible to Image2 palette, and will fade in 1 second (=1000ms) from black <-> color
  Fader.Brightness(0);                       // set all colors in image1.palette to black
  Video.UsePalette(Image2.Palette());        // the screen will be black now (because Image2.Palette() is all black right now)
  Video.BlitToScreen(0,0,Image2,Rect(0,0,319,199)); // copy the (black) image onto the screen
  Fader.FadeIn(2000);                              // start fading
  while (Fader.IsRunning());
  while (!Keyboard.GetKey());
  Fader.FadeOut(2000);
  while (Fader.IsRunning());}
  return(0);
  }
