#ifndef FTYPES_H
#define FTYPES_H

#define NONOTE 132
#define KEYOFF 133
#define NOVOL  255

#define ERR_NO_ENV 			1
#define ERR_NO_FILE 		2
#define ERR_UNKNOWN_FORMAT 	3
#define ERR_GUS_DRAM_FULL 	4
#define ERR_OUT_OF_MEM 		5
#define ERR_FILE_CORRUPT 	6

typedef char            BYTE;   // 8
typedef unsigned char   UBYTE;  // 8
typedef short           WORD;   // 16
typedef unsigned short  UWORD;  // 16
typedef long            DWORD;   // 32
typedef unsigned long   UDWORD;  // 32

#ifdef __cplusplus
	#define __CPPARGS ...
#else
	#define __CPPARGS
#endif

typedef struct {                // Sample type - contains info on sample
	char name[28];
	UDWORD offset;              // offset of sample in dram
	UDWORD length;              // sample length
	UDWORD loopstart;           // sample loop start
	UDWORD loopend;             // sample loop length
	UWORD middlec;              // sample middle C rate, or FineTune (XM)
	UBYTE volume;               // sample default volume
	UBYTE mode;                 // * see settings below
} SampleHDR;
//  0 = one shot 8 bit          //  4 = one shot 16 bit
//  8 = looping 8 bit           // 12 = looping 16 bit
// 24 = pingpong looping 8 bit  // 28 = pingpong looping 16 bit

/*
Instruments for XM - not supported yet

typedef struct {
	char name[28];              // instrument name
	UBYTE keymap[96];           // sample keymap assignments
	SampleHDR sample[16];       // sample headers
	UBYTE VOLPoints[255];		// Volume envelope points
	UBYTE PANPoints[255];		// Panning envelope points
	UBYTE sustain;				// sustain point
	UBYTE VOLLoopStart;			// Volume envelope loop start
	UBYTE VOLLoopEnd;			// Volume envelope loop end
	UBYTE PANLoopStart;			// Panning envelope loop start
	UBYTE PANLoopEnd;			// Panning envelope loop end
	// etc etc
} InstHDR;
*/

typedef struct {                // Song type - contains info on song
	char type[8];               // tune type
	char name[40];              // song name
	UWORD songlength;           // song length
	UWORD numpats;              // number of physical patterns
	UBYTE numinsts;             // number of instruments
	UBYTE order[256];           // pattern playing orders
	UBYTE patlen[256];          // length of each pattern
	UBYTE channels;             // number of channels
	UBYTE restart;              // restart position
	UBYTE flags;                // flags - see below
	UBYTE playing;				// if song is playing.  0 = no, 1 = yes
} Song;
// FLAGS:
//  0 = normal
// +1 = fast volume slides
// +2 = instrument panning rather than channel panning (preparing for XM)


typedef struct {        // Single note type - contains info on 1 note
	UBYTE note;         // note to play at     (0-133) 132=none,133=keyoff
	UBYTE number;       // sample being played (0-99)
	UBYTE volume;       // volume colume value (0-64)  255=no volume
	UBYTE effect;       // effect number       (0-1Ah)
	UBYTE eparm;        // effect parameter    (0-255)
} Note;

#endif
