This is Info file diff.info, produced by Makeinfo-1.63 from the input
file diff.texinfo.

   This file documents the the GNU `diff', `diff3', `sdiff', and `cmp'
commands for showing the differences between text files and the `patch'
command for using their output to update files.

   Copyright (C) 1992, 1993, 1994 Free Software Foundation, Inc.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy and distribute modified versions of
this manual under the conditions for verbatim copying, provided that
the entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

   Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be stated in a
translation approved by the Foundation.


File: diff,  Node: Making Patches,  Next: Invoking cmp,  Prev: Merging with patch,  Up: Top

Tips for Making Patch Distributions
***********************************

   Here are some things you should keep in mind if you are going to
distribute patches for updating a software package.

   Make sure you have specified the file names correctly, either in a
context diff header or with an `Index:' line.  If you are patching
files in a subdirectory, be sure to tell the patch user to specify a
`-p' or `--strip' option as needed.  Take care to not send out reversed
patches, since these make people wonder whether they have already
applied the patch.

   To save people from partially applying a patch before other patches
that should have gone before it, you can make the first patch in the
patch file update a file with a name like `patchlevel.h' or
`version.c', which contains a patch level or version number.  If the
input file contains the wrong version number, `patch' will complain
immediately.

   An even clearer way to prevent this problem is to put a `Prereq:'
line before the patch.  If the leading text in the patch file contains a
line that starts with `Prereq:', `patch' takes the next word from that
line (normally a version number) and checks whether the next input file
contains that word, preceded and followed by either white space or a
newline.  If not, `patch' prompts you for confirmation before
proceeding.  This makes it difficult to accidentally apply patches in
the wrong order.

   Since `patch' does not handle incomplete lines properly, make sure
that all the source files in your program end with a newline whenever
you release a version.

   To create a patch that changes an older version of a package into a
newer version, first make a copy of the older version in a scratch
directory.  Typically you do that by unpacking a `tar' or `shar'
archive of the older version.

   You might be able to reduce the size of the patch by renaming or
removing some files before making the patch.  If the older version of
the package contains any files that the newer version does not, or if
any files have been renamed between the two versions, make a list of
`rm' and `mv' commands for the user to execute in the old version
directory before applying the patch.  Then run those commands yourself
in the scratch directory.

   If there are any files that you don't need to include in the patch
because they can easily be rebuilt from other files (for example,
`TAGS' and output from `yacc' and `makeinfo'), replace the versions in
the scratch directory with the newer versions, using `rm' and `ln' or
`cp'.

   Now you can create the patch.  The de-facto standard `diff' format
for patch distributions is context format with two lines of context,
produced by giving `diff' the `-C 2' option.  Do not use less than two
lines of context, because `patch' typically needs at least two lines
for proper operation.  Give `diff' the `-P' option in case the newer
version of the package contains any files that the older one does not.
Make sure to specify the scratch directory first and the newer
directory second.

   Add to the top of the patch a note telling the user any `rm' and
`mv' commands to run before applying the patch.  Then you can remove
the scratch directory.


File: diff,  Node: Invoking cmp,  Next: Invoking diff,  Prev: Making Patches,  Up: Top

Invoking `cmp'
**************

   The `cmp' command compares two files, and if they differ, tells the
first byte and line number where they differ.  Its arguments are as
follows:

     cmp OPTIONS... FROM-FILE [TO-FILE]

   The file name `-' is always the standard input.  `cmp' also uses the
standard input if one file name is omitted.

   An exit status of 0 means no differences were found, 1 means some
differences were found, and 2 means trouble.

* Menu:

* cmp Options::		Summary of options to `cmp'.


File: diff,  Node: cmp Options,  Up: Invoking cmp

Options to `cmp'
================

   Below is a summary of all of the options that GNU `cmp' accepts.
Most options have two equivalent names, one of which is a single letter
preceded by `-', and the other of which is a long name preceded by
`--'.  Multiple single letter options (unless they take an argument)
can be combined into a single command line word: `-cl' is equivalent to
`-c -l'.

`-c'
     Print the differing characters.  Display control characters as a
     `^' followed by a letter of the alphabet and precede characters
     that have the high bit set with `M-' (which stands for "meta").

`--ignore-initial=BYTES'
     Ignore any differences in the the first BYTES bytes of the input
     files.  Treat files with fewer than BYTES bytes as if they are
     empty.

`-l'
     Print the (decimal) offsets and (octal) values of all differing
     bytes.

`--print-chars'
     Print the differing characters.  Display control characters as a
     `^' followed by a letter of the alphabet and precede characters
     that have the high bit set with `M-' (which stands for "meta").

`--quiet'
`-s'
`--silent'
     Do not print anything; only return an exit status indicating
     whether the files differ.

`--verbose'
     Print the (decimal) offsets and (octal) values of all differing
     bytes.

`-v'
`--version'
     Output the version number of `cmp'.


File: diff,  Node: Invoking diff,  Next: Invoking diff3,  Prev: Invoking cmp,  Up: Top

Invoking `diff'
***************

   The format for running the `diff' command is:

     diff OPTIONS... FROM-FILE TO-FILE

   In the simplest case, `diff' compares the contents of the two files
FROM-FILE and TO-FILE.  A file name of `-' stands for text read from
the standard input.  As a special case, `diff - -' compares a copy of
standard input to itself.

   If FROM-FILE is a directory and TO-FILE is not, `diff' compares the
file in FROM-FILE whose file name is that of TO-FILE, and vice versa.
The non-directory file must not be `-'.

   If both FROM-FILE and TO-FILE are directories, `diff' compares
corresponding files in both directories, in alphabetical order; this
comparison is not recursive unless the `-r' or `--recursive' option is
given.  `diff' never compares the actual contents of a directory as if
it were a file.  The file that is fully specified may not be standard
input, because standard input is nameless and the notion of "file with
the same name" does not apply.

   `diff' options begin with `-', so normally FROM-FILE and TO-FILE may
not begin with `-'.  However, `--' as an argument by itself treats the
remaining arguments as file names even if they begin with `-'.

   An exit status of 0 means no differences were found, 1 means some
differences were found, and 2 means trouble.

* Menu:

* diff Options::	Summary of options to `diff'.


File: diff,  Node: diff Options,  Up: Invoking diff

Options to `diff'
=================

   Below is a summary of all of the options that GNU `diff' accepts.
Most options have two equivalent names, one of which is a single letter
preceded by `-', and the other of which is a long name preceded by
`--'.  Multiple single letter options (unless they take an argument)
can be combined into a single command line word: `-ac' is equivalent to
`-a -c'.  Long named options can be abbreviated to any unique prefix of
their name.  Brackets ([ and ]) indicate that an option takes an
optional argument.

`-LINES'
     Show LINES (an integer) lines of context.  This option does not
     specify an output format by itself; it has no effect unless it is
     combined with `-c' (*note Context Format::.) or `-u' (*note
     Unified Format::.).  This option is obsolete.  For proper
     operation, `patch' typically needs at least two lines of context.

`-a'
     Treat all files as text and compare them line-by-line, even if they
     do not seem to be text.  *Note Binary::.

`-b'
     Ignore changes in amount of white space.  *Note White Space::.

`-B'
     Ignore changes that just insert or delete blank lines.  *Note
     Blank Lines::.

`--binary'
     Read and write data in binary mode.  *Note Binary::.

`--brief'
     Report only whether the files differ, not the details of the
     differences.  *Note Brief::.

`-c'
     Use the context output format.  *Note Context Format::.

`-C LINES'
`--context[=LINES]'
     Use the context output format, showing LINES (an integer) lines of
     context, or three if LINES is not given.  *Note Context Format::.
     For proper operation, `patch' typically needs at least two lines of
     context.

`--changed-group-format=FORMAT'
     Use FORMAT to output a line group containing differing lines from
     both files in if-then-else format.  *Note Line Group Formats::.

`-d'
     Change the algorithm perhaps find a smaller set of changes.  This
     makes `diff' slower (sometimes much slower).  *Note diff
     Performance::.

`-D NAME'
     Make merged `#ifdef' format output, conditional on the preprocessor
     macro NAME.  *Note If-then-else::.

`-e'
`--ed'
     Make output that is a valid `ed' script.  *Note ed Scripts::.

`--exclude=PATTERN'
     When comparing directories, ignore files and subdirectories whose
     basenames match PATTERN.  *Note Comparing Directories::.

`--exclude-from=FILE'
     When comparing directories, ignore files and subdirectories whose
     basenames match any pattern contained in FILE.  *Note Comparing
     Directories::.

`--expand-tabs'
     Expand tabs to spaces in the output, to preserve the alignment of
     tabs in the input files.  *Note Tabs::.

`-f'
     Make output that looks vaguely like an `ed' script but has changes
     in the order they appear in the file.  *Note Forward ed::.

`-F REGEXP'
     In context and unified format, for each hunk of differences, show
     some of the last preceding line that matches REGEXP.  *Note
     Specified Headings::.

`--forward-ed'
     Make output that looks vaguely like an `ed' script but has changes
     in the order they appear in the file.  *Note Forward ed::.

`-h'
     This option currently has no effect; it is present for Unix
     compatibility.

`-H'
     Use heuristics to speed handling of large files that have numerous
     scattered small changes.  *Note diff Performance::.

`--horizon-lines=LINES'
     Do not discard the last LINES lines of the common prefix and the
     first LINES lines of the common suffix.  *Note diff Performance::.

`-i'
     Ignore changes in case; consider upper- and lower-case letters
     equivalent.  *Note Case Folding::.

`-I REGEXP'
     Ignore changes that just insert or delete lines that match REGEXP.
     *Note Specified Folding::.

`--ifdef=NAME'
     Make merged if-then-else output using NAME.  *Note If-then-else::.

`--ignore-all-space'
     Ignore white space when comparing lines.  *Note White Space::.

`--ignore-blank-lines'
     Ignore changes that just insert or delete blank lines.  *Note
     Blank Lines::.

`--ignore-case'
     Ignore changes in case; consider upper- and lower-case to be the
     same.  *Note Case Folding::.

`--ignore-matching-lines=REGEXP'
     Ignore changes that just insert or delete lines that match REGEXP.
     *Note Specified Folding::.

`--ignore-space-change'
     Ignore changes in amount of white space.  *Note White Space::.

`--initial-tab'
     Output a tab rather than a space before the text of a line in
     normal or context format.  This causes the alignment of tabs in
     the line to look normal.  *Note Tabs::.

`-l'
     Pass the output through `pr' to paginate it.  *Note Pagination::.

`-L LABEL'
     Use LABEL instead of the file name in the context format (*note
     Context Format::.) and unified format (*note Unified Format::.)
     headers.  *Note RCS::.

`--label=LABEL'
     Use LABEL instead of the file name in the context format (*note
     Context Format::.) and unified format (*note Unified Format::.)
     headers.

`--left-column'
     Print only the left column of two common lines in side by side
     format.  *Note Side by Side Format::.

`--line-format=FORMAT'
     Use FORMAT to output all input lines in if-then-else format.
     *Note Line Formats::.

`--minimal'
     Change the algorithm to perhaps find a smaller set of changes.
     This makes `diff' slower (sometimes much slower).  *Note diff
     Performance::.

`-n'
     Output RCS-format diffs; like `-f' except that each command
     specifies the number of lines affected.  *Note RCS::.

`-N'
`--new-file'
     In directory comparison, if a file is found in only one directory,
     treat it as present but empty in the other directory.  *Note
     Comparing Directories::.

`--new-group-format=FORMAT'
     Use FORMAT to output a group of lines taken from just the second
     file in if-then-else format.  *Note Line Group Formats::.

`--new-line-format=FORMAT'
     Use FORMAT to output a line taken from just the second file in
     if-then-else format.  *Note Line Formats::.

`--old-group-format=FORMAT'
     Use FORMAT to output a group of lines taken from just the first
     file in if-then-else format.  *Note Line Group Formats::.

`--old-line-format=FORMAT'
     Use FORMAT to output a line taken from just the first file in
     if-then-else format.  *Note Line Formats::.

`-p'
     Show which C function each change is in.  *Note C Function
     Headings::.

`-P'
     When comparing directories, if a file appears only in the second
     directory of the two, treat it as present but empty in the other.
     *Note Comparing Directories::.

`--paginate'
     Pass the output through `pr' to paginate it.  *Note Pagination::.

`-q'
     Report only whether the files differ, not the details of the
     differences.  *Note Brief::.

`-r'
     When comparing directories, recursively compare any subdirectories
     found.  *Note Comparing Directories::.

`--rcs'
     Output RCS-format diffs; like `-f' except that each command
     specifies the number of lines affected.  *Note RCS::.

`--recursive'
     When comparing directories, recursively compare any subdirectories
     found.  *Note Comparing Directories::.

`--report-identical-files'
     Report when two files are the same.  *Note Comparing Directories::.

`-s'
     Report when two files are the same.  *Note Comparing Directories::.

`-S FILE'
     When comparing directories, start with the file FILE.  This is
     used for resuming an aborted comparison.  *Note Comparing
     Directories::.

`--sdiff-merge-assist'
     Print extra information to help `sdiff'.  `sdiff' uses this option
     when it runs `diff'.  This option is not intended for users to use
     directly.

`--show-c-function'
     Show which C function each change is in.  *Note C Function
     Headings::.

`--show-function-line=REGEXP'
     In context and unified format, for each hunk of differences, show
     some of the last preceding line that matches REGEXP.  *Note
     Specified Headings::.

`--side-by-side'
     Use the side by side output format.  *Note Side by Side Format::.

`--speed-large-files'
     Use heuristics to speed handling of large files that have numerous
     scattered small changes.  *Note diff Performance::.

`--starting-file=FILE'
     When comparing directories, start with the file FILE.  This is
     used for resuming an aborted comparison.  *Note Comparing
     Directories::.

`--suppress-common-lines'
     Do not print common lines in side by side format.  *Note Side by
     Side Format::.

`-t'
     Expand tabs to spaces in the output, to preserve the alignment of
     tabs in the input files.  *Note Tabs::.

`-T'
     Output a tab rather than a space before the text of a line in
     normal or context format.  This causes the alignment of tabs in
     the line to look normal.  *Note Tabs::.

`--text'
     Treat all files as text and compare them line-by-line, even if they
     do not appear to be text.  *Note Binary::.

`-u'
     Use the unified output format.  *Note Unified Format::.

`--unchanged-group-format=FORMAT'
     Use FORMAT to output a group of common lines taken from both files
     in if-then-else format.  *Note Line Group Formats::.

`--unchanged-line-format=FORMAT'
     Use FORMAT to output a line common to both files in if-then-else
     format.  *Note Line Formats::.

`--unidirectional-new-file'
     When comparing directories, if a file appears only in the second
     directory of the two, treat it as present but empty in the other.
     *Note Comparing Directories::.

`-U LINES'
`--unified[=LINES]'
     Use the unified output format, showing LINES (an integer) lines of
     context, or three if LINES is not given.  *Note Unified Format::.
     For proper operation, `patch' typically needs at least two lines of
     context.

`-v'
`--version'
     Output the version number of `diff'.

`-w'
     Ignore white space when comparing lines.  *Note White Space::.

`-W COLUMNS'
`--width=COLUMNS'
     Use an output width of COLUMNS in side by side format.  *Note Side
     by Side Format::.

`-x PATTERN'
     When comparing directories, ignore files and subdirectories whose
     basenames match PATTERN.  *Note Comparing Directories::.

`-X FILE'
     When comparing directories, ignore files and subdirectories whose
     basenames match any pattern contained in FILE.  *Note Comparing
     Directories::.

`-y'
     Use the side by side output format.  *Note Side by Side Format::.


File: diff,  Node: Invoking diff3,  Next: Invoking patch,  Prev: Invoking diff,  Up: Top

Invoking `diff3'
****************

   The `diff3' command compares three files and outputs descriptions of
their differences.  Its arguments are as follows:

     diff3 OPTIONS... MINE OLDER YOURS

   The files to compare are MINE, OLDER, and YOURS.  At most one of
these three file names may be `-', which tells `diff3' to read the
standard input for that file.

   An exit status of 0 means `diff3' was successful, 1 means some
conflicts were found, and 2 means trouble.

* Menu:

* diff3 Options::		Summary of options to `diff3'.


File: diff,  Node: diff3 Options,  Up: Invoking diff3

Options to `diff3'
==================

   Below is a summary of all of the options that GNU `diff3' accepts.
Multiple single letter options (unless they take an argument) can be
combined into a single command line argument.

`-a'
     Treat all files as text and compare them line-by-line, even if they
     do not appear to be text.  *Note Binary::.

`-A'
     Incorporate all changes from OLDER to YOURS into MINE, surrounding
     all conflicts with bracket lines.  *Note Marking Conflicts::.

`-e'
     Generate an `ed' script that incorporates all the changes from
     OLDER to YOURS into MINE.  *Note Which Changes::.

`-E'
     Like `-e', except bracket lines from overlapping changes' first
     and third files.  *Note Marking Conflicts::.  With `-e', an
     overlapping change looks like this:

          <<<<<<< MINE
          lines from MINE
          =======
          lines from YOURS
          >>>>>>> YOURS

`--ed'
     Generate an `ed' script that incorporates all the changes from
     OLDER to YOURS into MINE.  *Note Which Changes::.

`--easy-only'
     Like `-e', except output only the nonoverlapping changes.  *Note
     Which Changes::.

`-i'
     Generate `w' and `q' commands at the end of the `ed' script for
     System V compatibility.  This option must be combined with one of
     the `-AeExX3' options, and may not be combined with `-m'.  *Note
     Saving the Changed File::.

`--initial-tab'
     Output a tab rather than two spaces before the text of a line in
     normal format.  This causes the alignment of tabs in the line to
     look normal.  *Note Tabs::.

`-L LABEL'
`--label=LABEL'
     Use the label LABEL for the brackets output by the `-A', `-E' and
     `-X' options.  This option may be given up to three times, one for
     each input file.  The default labels are the names of the input
     files.  Thus `diff3 -L X -L Y -L Z -m A B C' acts like `diff3 -m A
     B C', except that the output looks like it came from files named
     `X', `Y' and `Z' rather than from files named `A', `B' and `C'.
     *Note Marking Conflicts::.

`-m'
`--merge'
     Apply the edit script to the first file and send the result to
     standard output.  Unlike piping the output from `diff3' to `ed',
     this works even for binary files and incomplete lines.  `-A' is
     assumed if no edit script option is specified.  *Note Bypassing
     ed::.

`--overlap-only'
     Like `-e', except output only the overlapping changes.  *Note
     Which Changes::.

`--show-all'
     Incorporate all unmerged changes from OLDER to YOURS into MINE,
     surrounding all overlapping changes with bracket lines.  *Note
     Marking Conflicts::.

`--show-overlap'
     Like `-e', except bracket lines from overlapping changes' first
     and third files.  *Note Marking Conflicts::.

`-T'
     Output a tab rather than two spaces before the text of a line in
     normal format.  This causes the alignment of tabs in the line to
     look normal.  *Note Tabs::.

`--text'
     Treat all files as text and compare them line-by-line, even if they
     do not appear to be text.  *Note Binary::.

`-v'
`--version'
     Output the version number of `diff3'.

`-x'
     Like `-e', except output only the overlapping changes.  *Note
     Which Changes::.

`-X'
     Like `-E', except output only the overlapping changes.  In other
     words, like `-x', except bracket changes as in `-E'.  *Note
     Marking Conflicts::.

`-3'
     Like `-e', except output only the nonoverlapping changes.  *Note
     Which Changes::.


File: diff,  Node: Invoking patch,  Next: Invoking sdiff,  Prev: Invoking diff3,  Up: Top

Invoking `patch'
****************

   Normally `patch' is invoked like this:

     patch <PATCHFILE

   The full format for invoking `patch' is:

     patch OPTIONS... [ORIGFILE [PATCHFILE]] [+ OPTIONS... [ORIGFILE]]...

   If you do not specify PATCHFILE, or if PATCHFILE is `-', `patch'
reads the patch (that is, the `diff' output) from the standard input.

   You can specify one or more of the original files as ORIG arguments;
each one and options for interpreting it is separated from the others
with a `+'.  *Note Multiple Patches::, for more information.

   If you do not specify an input file on the command line, `patch'
tries to figure out from the "leading text" (any text in the patch that
comes before the `diff' output) which file to edit.  In the header of a
context or unified diff, `patch' looks in lines beginning with `***',
`---', or `+++'; among those, it chooses the shortest name of an
existing file.  Otherwise, if there is an `Index:' line in the leading
text, `patch' tries to use the file name from that line.  If `patch'
cannot figure out the name of an existing file from the leading text,
it prompts you for the name of the file to patch.

   If the input file does not exist or is read-only, and a suitable RCS
or SCCS file exists, `patch' attempts to check out or get the file
before proceeding.

   By default, `patch' replaces the original input file with the
patched version, after renaming the original file into a backup file
(*note Backups::., for a description of how `patch' names backup
files).  You can also specify where to put the output with the `-o
OUTPUT-FILE' or `--output=OUTPUT-FILE' option.

* Menu:

* patch Directories::	Changing directory and stripping directories.
* Backups::		Backup file names.
* Rejects::		Reject file names.
* patch Options::	Summary table of options to `patch'.


File: diff,  Node: patch Directories,  Next: Backups,  Up: Invoking patch

Applying Patches in Other Directories
=====================================

   The `-d DIRECTORY' or `--directory=DIRECTORY' option to `patch'
makes directory DIRECTORY the current directory for interpreting both
file names in the patch file, and file names given as arguments to
other options (such as `-B' and `-o').  For example, while in a news
reading program, you can patch a file in the `/usr/src/emacs' directory
directly from the article containing the patch like this:

     | patch -d /usr/src/emacs

   Sometimes the file names given in a patch contain leading
directories, but you keep your files in a directory different from the
one given in the patch.  In those cases, you can use the `-p[NUMBER]'
or `--strip[=NUMBER]' option to set the file name strip count to
NUMBER.  The strip count tells `patch' how many slashes, along with the
directory names between them, to strip from the front of file names.
`-p' with no NUMBER given is equivalent to `-p0'.  By default, `patch'
strips off all leading directories, leaving just the base file names,
except that when a file name given in the patch is a relative file name
and all of its leading directories already exist, `patch' does not
strip off the leading directory.  (A "relative" file name is one that
does not start with a slash.)

   `patch' looks for each file (after any slashes have been stripped)
in the current directory, or if you used the `-d DIRECTORY' option, in
that directory.

   For example, suppose the file name in the patch file is
`/gnu/src/emacs/etc/NEWS'.  Using `-p' or `-p0' gives the entire file
name unmodified, `-p1' gives `gnu/src/emacs/etc/NEWS' (no leading
slash), `-p4' gives `etc/NEWS', and not specifying `-p' at all gives
`NEWS'.


File: diff,  Node: Backups,  Next: Rejects,  Prev: patch Directories,  Up: Invoking patch

Backup File Names
=================

   Normally, `patch' renames an original input file into a backup file
by appending to its name the extension `.orig', or `~' on systems that
do not support long file names.  The `-b BACKUP-SUFFIX' or
`--suffix=BACKUP-SUFFIX' option uses BACKUP-SUFFIX as the backup
extension instead.

   Alternately, you can specify the extension for backup files with the
`SIMPLE_BACKUP_SUFFIX' environment variable, which the options override.

   `patch' can also create numbered backup files the way GNU Emacs
does.  With this method, instead of having a single backup of each file,
`patch' makes a new backup file name each time it patches a file.  For
example, the backups of a file named `sink' would be called,
successively, `sink.~1~', `sink.~2~', `sink.~3~', etc.

   The `-V BACKUP-STYLE' or `--version-control=BACKUP-STYLE' option
takes as an argument a method for creating backup file names.  You can
alternately control the type of backups that `patch' makes with the
`VERSION_CONTROL' environment variable, which the `-V' option
overrides.  The value of the `VERSION_CONTROL' environment variable and
the argument to the `-V' option are like the GNU Emacs
`version-control' variable (*note emacs: Backups., for more information
on backup versions in Emacs).  They also recognize synonyms that are
more descriptive.  The valid values are listed below; unique
abbreviations are acceptable.

`t'
`numbered'
     Always make numbered backups.

`nil'
`existing'
     Make numbered backups of files that already have them, simple
     backups of the others.  This is the default.

`never'
`simple'
     Always make simple backups.

   Alternately, you can tell `patch' to prepend a prefix, such as a
directory name, to produce backup file names.  The `-B BACKUP-PREFIX'
or `--prefix=BACKUP-PREFIX' option makes backup files by prepending
BACKUP-PREFIX to them.  If you use this option, `patch' ignores any
`-b' option that you give.

   If the backup file already exists, `patch' creates a new backup file
name by changing the first lowercase letter in the last component of
the file name into uppercase.  If there are no more lowercase letters
in the name, it removes the first character from the name.  It repeats
this process until it comes up with a backup file name that does not
already exist.

   If you specify the output file with the `-o' option, that file is
the one that is backed up, not the input file.


File: diff,  Node: Rejects,  Next: patch Options,  Prev: Backups,  Up: Invoking patch

Reject File Names
=================

   The names for reject files (files containing patches that `patch'
could not find a place to apply) are normally the name of the output
file with `.rej' appended (or `#' on systems that do not support long
file names).

   Alternatively, you can tell `patch' to place all of the rejected
patches in a single file.  The `-r REJECT-FILE' or
`--reject-file=REJECT-FILE' option uses REJECT-FILE as the reject file
name.


File: diff,  Node: patch Options,  Prev: Rejects,  Up: Invoking patch

Options to `patch'
==================

   Here is a summary of all of the options that `patch' accepts.  Older
versions of `patch' do not accept long-named options or the `-t', `-E',
or `-V' options.

   Multiple single-letter options that do not take an argument can be
combined into a single command line argument (with only one dash).
Brackets ([ and ]) indicate that an option takes an optional argument.

`-b BACKUP-SUFFIX'
     Use BACKUP-SUFFIX as the backup extension instead of `.orig' or
     `~'.  *Note Backups::.

`-B BACKUP-PREFIX'
     Use BACKUP-PREFIX as a prefix to the backup file name.  If this
     option is specified, any `-b' option is ignored.  *Note Backups::.

`--batch'
     Do not ask any questions.  *Note patch Messages::.

`-c'
`--context'
     Interpret the patch file as a context diff.  *Note patch Input::.

`-d DIRECTORY'
`--directory=DIRECTORY'
     Makes directory DIRECTORY the current directory for interpreting
     both file names in the patch file, and file names given as
     arguments to other options.  *Note patch Directories::.

`-D NAME'
     Make merged if-then-else output using FORMAT.  *Note
     If-then-else::.

`--debug=NUMBER'
     Set internal debugging flags.  Of interest only to `patch'
     patchers.

`-e'
`--ed'
     Interpret the patch file as an `ed' script.  *Note patch Input::.

`-E'
     Remove output files that are empty after the patches have been
     applied.  *Note Empty Files::.

`-f'
     Assume that the user knows exactly what he or she is doing, and do
     not ask any questions.  *Note patch Messages::.

`-F LINES'
     Set the maximum fuzz factor to LINES.  *Note Inexact::.

`--force'
     Assume that the user knows exactly what he or she is doing, and do
     not ask any questions.  *Note patch Messages::.

`--forward'
     Ignore patches that `patch' thinks are reversed or already applied.
     See also `-R'.  *Note Reversed Patches::.

`--fuzz=LINES'
     Set the maximum fuzz factor to LINES.  *Note Inexact::.

`--help'
     Print a summary of the options that `patch' recognizes, then exit.

`--ifdef=NAME'
     Make merged if-then-else output using FORMAT.  *Note
     If-then-else::.

`--ignore-white-space'
`-l'
     Let any sequence of white space in the patch file match any
     sequence of white space in the input file.  *Note Changed White
     Space::.

`-n'
`--normal'
     Interpret the patch file as a normal diff.  *Note patch Input::.

`-N'
     Ignore patches that `patch' thinks are reversed or already applied.
     See also `-R'.  *Note Reversed Patches::.

`-o OUTPUT-FILE'
`--output=OUTPUT-FILE'
     Use OUTPUT-FILE as the output file name.  *Note patch Options::.

`-p[NUMBER]'
     Set the file name strip count to NUMBER.  *Note patch
     Directories::.

`--prefix=BACKUP-PREFIX'
     Use BACKUP-PREFIX as a prefix to the backup file name.  If this
     option is specified, any `-b' option is ignored.  *Note Backups::.

`--quiet'
     Work silently unless an error occurs.  *Note patch Messages::.

`-r REJECT-FILE'
     Use REJECT-FILE as the reject file name.  *Note Rejects::.

`-R'
     Assume that this patch was created with the old and new files
     swapped.  *Note Reversed Patches::.

`--reject-file=REJECT-FILE'
     Use REJECT-FILE as the reject file name.  *Note Rejects::.

`--remove-empty-files'
     Remove output files that are empty after the patches have been
     applied.  *Note Empty Files::.

`--reverse'
     Assume that this patch was created with the old and new files
     swapped.  *Note Reversed Patches::.

`-s'
     Work silently unless an error occurs.  *Note patch Messages::.

`-S'
     Ignore this patch from the patch file, but continue looking for
     the next patch in the file.  *Note Multiple Patches::.

`--silent'
     Work silently unless an error occurs.  *Note patch Messages::.

`--skip'
     Ignore this patch from the patch file, but continue looking for
     the next patch in the file.  *Note Multiple Patches::.

`--strip[=NUMBER]'
     Set the file name strip count to NUMBER.  *Note patch
     Directories::.

`--suffix=BACKUP-SUFFIX'
     Use BACKUP-SUFFIX as the backup extension instead of `.orig' or
     `~'.  *Note Backups::.

`-t'
     Do not ask any questions.  *Note patch Messages::.

`-u'
`--unified'
     Interpret the patch file as a unified diff.  *Note patch Input::.

`-v'
     Output the revision header and patch level of `patch'.

`-V BACKUP-STYLE'
     Select the kind of backups to make.  *Note Backups::.

`--version'
     Output the revision header and patch level of `patch', then exit.

`--version=control=BACKUP-STYLE'
     Select the kind of backups to make.  *Note Backups::.

`-x NUMBER'
     Set internal debugging flags.  Of interest only to `patch'
     patchers.


File: diff,  Node: Invoking sdiff,  Next: Incomplete Lines,  Prev: Invoking patch,  Up: Top

Invoking `sdiff'
****************

   The `sdiff' command merges two files and interactively outputs the
results.  Its arguments are as follows:

     sdiff -o OUTFILE OPTIONS... FROM-FILE TO-FILE

   This merges FROM-FILE with TO-FILE, with output to OUTFILE.  If
FROM-FILE is a directory and TO-FILE is not, `sdiff' compares the file
in FROM-FILE whose file name is that of TO-FILE, and vice versa.
FROM-FILE and TO-FILE may not both be directories.

   `sdiff' options begin with `-', so normally FROM-FILE and TO-FILE
may not begin with `-'.  However, `--' as an argument by itself treats
the remaining arguments as file names even if they begin with `-'.  You
may not use `-' as an input file.

   An exit status of 0 means no differences were found, 1 means some
differences were found, and 2 means trouble.

   `sdiff' without `-o' (or `--output') produces a side-by-side
difference.  This usage is obsolete; use `diff --side-by-side' instead.

* Menu:

* sdiff Options::	Summary of options to `diff'.


File: diff,  Node: sdiff Options,  Up: Invoking sdiff

Options to `sdiff'
==================

   Below is a summary of all of the options that GNU `sdiff' accepts.
Each option has two equivalent names, one of which is a single letter
preceded by `-', and the other of which is a long name preceded by
`--'.  Multiple single letter options (unless they take an argument)
can be combined into a single command line argument.  Long named
options can be abbreviated to any unique prefix of their name.

`-a'
     Treat all files as text and compare them line-by-line, even if they
     do not appear to be text.  *Note Binary::.

`-b'
     Ignore changes in amount of white space.  *Note White Space::.

`-B'
     Ignore changes that just insert or delete blank lines.  *Note
     Blank Lines::.

`-d'
     Change the algorithm to perhaps find a smaller set of changes.
     This makes `sdiff' slower (sometimes much slower).  *Note diff
     Performance::.

`-H'
     Use heuristics to speed handling of large files that have numerous
     scattered small changes.  *Note diff Performance::.

`--expand-tabs'
     Expand tabs to spaces in the output, to preserve the alignment of
     tabs in the input files.  *Note Tabs::.

`-i'
     Ignore changes in case; consider upper- and lower-case to be the
     same.  *Note Case Folding::.

`-I REGEXP'
     Ignore changes that just insert or delete lines that match REGEXP.
     *Note Specified Folding::.

`--ignore-all-space'
     Ignore white space when comparing lines.  *Note White Space::.

`--ignore-blank-lines'
     Ignore changes that just insert or delete blank lines.  *Note
     Blank Lines::.

`--ignore-case'
     Ignore changes in case; consider upper- and lower-case to be the
     same.  *Note Case Folding::.

`--ignore-matching-lines=REGEXP'
     Ignore changes that just insert or delete lines that match REGEXP.
     *Note Specified Folding::.

`--ignore-space-change'
     Ignore changes in amount of white space.  *Note White Space::.

`-l'
`--left-column'
     Print only the left column of two common lines.  *Note Side by
     Side Format::.

`--minimal'
     Change the algorithm to perhaps find a smaller set of changes.
     This makes `sdiff' slower (sometimes much slower).  *Note diff
     Performance::.

`-o FILE'
`--output=FILE'
     Put merged output into FILE.  This option is required for merging.

`-s'
`--suppress-common-lines'
     Do not print common lines.  *Note Side by Side Format::.

`--speed-large-files'
     Use heuristics to speed handling of large files that have numerous
     scattered small changes.  *Note diff Performance::.

`-t'
     Expand tabs to spaces in the output, to preserve the alignment of
     tabs in the input files.  *Note Tabs::.

`--text'
     Treat all files as text and compare them line-by-line, even if they
     do not appear to be text.  *Note Binary::.

`-v'
`--version'
     Output the version number of `sdiff'.

`-w COLUMNS'
`--width=COLUMNS'
     Use an output width of COLUMNS.  *Note Side by Side Format::.
     Note that for historical reasons, this option is `-W' in `diff',
     `-w' in `sdiff'.

`-W'
     Ignore horizontal white space when comparing lines.  *Note White
     Space::.  Note that for historical reasons, this option is `-w' in
     `diff', `-W' in `sdiff'.


File: diff,  Node: Incomplete Lines,  Next: Projects,  Prev: Invoking sdiff,  Up: Top

Incomplete Lines
****************

   When an input file ends in a non-newline character, its last line is
called an "incomplete line" because its last character is not a
newline.  All other lines are called "full lines" and end in a newline
character.  Incomplete lines do not match full lines unless differences
in white space are ignored (*note White Space::.).

   An incomplete line is normally distinguished on output from a full
line by a following line that starts with `\'.  However, the RCS format
(*note RCS::.) outputs the incomplete line as-is, without any trailing
newline or following line.  The side by side format normally represents
incomplete lines as-is, but in some cases uses a `\' or `/' gutter
marker; *Note Side by Side::.  The if-then-else line format preserves a
line's incompleteness with `%L', and discards the newline with `%l';
*Note Line Formats::.  Finally, with the `ed' and forward `ed' output
formats (*note Output Formats::.) `diff' cannot represent an incomplete
line, so it pretends there was a newline and reports an error.

   For example, suppose `F' and `G' are one-byte files that contain
just `f' and `g', respectively.  Then `diff F G' outputs

     1c1
     < f
     \ No newline at end of file
     ---
     > g
     \ No newline at end of file

(The exact message may differ in non-English locales.) `diff -n F G'
outputs the following without a trailing newline:

     d1 1
     a1 1
     g

   `diff -e F G' reports two errors and outputs the following:

     1c
     g
     .


File: diff,  Node: Projects,  Next: Concept Index,  Prev: Incomplete Lines,  Up: Top

Future Projects
***************

   Here are some ideas for improving GNU `diff' and `patch'.  The GNU
project has identified some improvements as potential programming
projects for volunteers.  You can also help by reporting any bugs that
you find.

   If you are a programmer and would like to contribute something to the
GNU project, please consider volunteering for one of these projects.  If
you are seriously contemplating work, please write to
`gnu@prep.ai.mit.edu' to coordinate with other volunteers.

* Menu:

* Shortcomings::	Suggested projects for improvements.
* Bugs::		Reporting bugs.


File: diff,  Node: Shortcomings,  Next: Bugs,  Up: Projects

Suggested Projects for Improving GNU `diff' and `patch'
=======================================================

   One should be able to use GNU `diff' to generate a patch from any
pair of directory trees, and given the patch and a copy of one such
tree, use `patch' to generate a faithful copy of the other.
Unfortunately, some changes to directory trees cannot be expressed using
current patch formats; also, `patch' does not handle some of the
existing formats.  These shortcomings motivate the following suggested
projects.

* Menu:

* Changing Structure::	Handling changes to the directory structure.
* Special Files::	Handling symbolic links, device special files, etc.
* Unusual File Names::	Handling file names that contain unusual characters.
* Arbitrary Limits::	Patching non-text files.
* Large Files::		Handling files that do not fit in memory.
* Ignoring Changes::	Ignoring certain changes while showing others.


File: diff,  Node: Changing Structure,  Next: Special Files,  Up: Shortcomings

Handling Changes to the Directory Structure
-------------------------------------------

   `diff' and `patch' do not handle some changes to directory
structure.  For example, suppose one directory tree contains a directory
named `D' with some subsidiary files, and another contains a file with
the same name `D'.  `diff -r' does not output enough information for
`patch' to transform the the directory subtree into the file.

   There should be a way to specify that a file has been deleted without
having to include its entire contents in the patch file.  There should
also be a way to tell `patch' that a file was renamed, even if there is
no way for `diff' to generate such information.

   These problems can be fixed by extending the `diff' output format to
represent changes in directory structure, and extending `patch' to
understand these extensions.


File: diff,  Node: Special Files,  Next: Unusual File Names,  Prev: Changing Structure,  Up: Shortcomings

Files that are Neither Directories Nor Regular Files
----------------------------------------------------

   Some files are neither directories nor regular files: they are
unusual files like symbolic links, device special files, named pipes,
and sockets.  Currently, `diff' treats symbolic links like regular
files; it treats other special files like regular files if they are
specified at the top level, but simply reports their presence when
comparing directories.  This means that `patch' cannot represent changes
to such files.  For example, if you change which file a symbolic link
points to, `diff' outputs the difference between the two files, instead
of the change to the symbolic link.

   `diff' should optionally report changes to special files specially,
and `patch' should be extended to understand these extensions.


File: diff,  Node: Unusual File Names,  Next: Arbitrary Limits,  Prev: Special Files,  Up: Shortcomings

File Names that Contain Unusual Characters
------------------------------------------

   When a file name contains an unusual character like a newline or
white space, `diff -r' generates a patch that `patch' cannot parse.
The problem is with format of `diff' output, not just with `patch',
because with odd enough file names one can cause `diff' to generate a
patch that is syntactically correct but patches the wrong files.  The
format of `diff' output should be extended to handle all possible file
names.


File: diff,  Node: Arbitrary Limits,  Next: Large Files,  Prev: Unusual File Names,  Up: Shortcomings

Arbitrary Limits
----------------

   GNU `diff' can analyze files with arbitrarily long lines and files
that end in incomplete lines.  However, `patch' cannot patch such
files.  The `patch' internal limits on line lengths should be removed,
and `patch' should be extended to parse `diff' reports of incomplete
lines.


File: diff,  Node: Large Files,  Next: Ignoring Changes,  Prev: Arbitrary Limits,  Up: Shortcomings

Handling Files that Do Not Fit in Memory
----------------------------------------

   `diff' operates by reading both files into memory.  This method
fails if the files are too large, and `diff' should have a fallback.

   One way to do this is to scan the files sequentially to compute hash
codes of the lines and put the lines in equivalence classes based only
on hash code.  Then compare the files normally.  This does produce some
false matches.

   Then scan the two files sequentially again, checking each match to
see whether it is real.  When a match is not real, mark both the
"matching" lines as changed.  Then build an edit script as usual.

   The output routines would have to be changed to scan the files
sequentially looking for the text to print.


File: diff,  Node: Ignoring Changes,  Prev: Large Files,  Up: Shortcomings

Ignoring Certain Changes
------------------------

   It would be nice to have a feature for specifying two strings, one in
FROM-FILE and one in TO-FILE, which should be considered to match.
Thus, if the two strings are `foo' and `bar', then if two lines differ
only in that `foo' in file 1 corresponds to `bar' in file 2, the lines
are treated as identical.

   It is not clear how general this feature can or should be, or what
syntax should be used for it.


File: diff,  Node: Bugs,  Prev: Shortcomings,  Up: Projects

Reporting Bugs
==============

   If you think you have found a bug in GNU `cmp', `diff', `diff3',
`sdiff', or `patch', please report it by electronic mail to
`bug-gnu-utils@prep.ai.mit.edu'.  Send as precise a description of the
problem as you can, including sample input files that produce the bug,
if applicable.

   Because Larry Wall has not released a new version of `patch' since
mid 1988 and the GNU version of `patch' has been changed since then,
please send bug reports for `patch' by electronic mail to both
`bug-gnu-utils@prep.ai.mit.edu' and `lwall@netlabs.com'.

