#include "datapriv.hpp"

/***********************************************************************

 Utility functions for data base programs

************************************************************************/

int eroff=0;

// If we're doing the DLL then link that in here

#ifdef __DLL__

int FAR PASCAL LibMain(HANDLE hinst,WORD wds,WORD whs,LPSTR cmd);
void FAR PASCAL WEP(int np);

int FAR PASCAL LibMain(HANDLE hinst,WORD wds,WORD whs,LPSTR cmd)
{
 if (whs>0) UnlockData(0);
 return(1);
}

void FAR PASCAL WEP(int np)
{
}

#endif

// Print a fatal error

void dbfer(int ern)
{
 int ers=eroff; eroff=-1; dber(ern); eroff=ers;
}

// Print an error

void dber(int ern)
{
 char ws[200];

 if (eroff>0) return;

 if (eroff) sprintf(ws,"\nDatabase Library Fatal Error : \n");
 else sprintf(ws,"\nDatabase Library Error : \n");

 switch(ern)
 {
  case DELREC	: strcat(ws,"Database deleted with attached records"); break;
  case FLDOOR	: strcat(ws,"Field number out of range"); break;
  case INVDB	:
  case DBINV	: strcat(ws,"Cannot do operation on invalid database"); break;
  case NODELKEY : strcat(ws,"Cannot find key to delete in index"); break;
  case NORECSP  : strcat(ws,"Cannot make space for record"); break;
  case NODBSP   : strcat(ws,"Cannot make space for database"); break;
  case ERINDW	: strcat(ws,"Cannot write index in record write"); break;
  case INVFILE	: strcat(ws,"Invalid file pointer on read or write"); break;
  case ERONW	: strcat(ws,"Error on write to file - Disk Full ?"); break;
  case INVSEEK  : strcat(ws,"Seek failed on file"); break;
  case NOMEMSP	: strcat(ws,"No Memory for operation"); break;
  case ERONR	: strcat(ws,"Error on read, premature EOF"); break;
  case INVMEMO  : strcat(ws,"Invalid Memo File"); break;
  default	: strcat(ws,"Unknown error"); break;
 }
#ifdef _Windows
 MessageBox(0,ws,"Database Error",MB_OK|MB_ICONASTERISK);
#else
 printf("%s",ws);
#endif
}

// write function which checks file as it writes it

int Fwrite(void *ptr,int size,int n,FILE *stream)
{
 if (!stream) dber(INVFILE);

 int ret=fwrite(ptr,size,n,stream);

 if (ret!=n) dber(ERONW);
 return ret;
}

// read function which checks file as it reads

int Fread(void *ptr,int size,int n,FILE *stream)
{
 if (!stream) dber(INVFILE);

 return fread(ptr,size,n,stream);
}

// put character function

int Fputc(int c,FILE *stream)
{
 if (!stream) dber(INVFILE);

 int ret=fputc(c,stream);

 if (ret==EOF) dber(ERONW);
 return ret;
}

// Get character function

int Fgetc(FILE *stream)
{
 if (!stream) dber(INVFILE);

 return(fgetc(stream));
}

// Fseek function

int Fseek(FILE *stream,long off,int wh)
{
 if (!stream) dber(INVFILE);

 int ret=fseek(stream,off,wh);
 if (ret) dber(INVSEEK);
 return ret;
}

// Trim trailing spaces from the supplied string

char* FD trim(char *s) {return rtrim(s);}

char* FD rtrim(char *str)
{
 char *sp=str;

 while(*sp++); sp--; sp--; while(*sp==' ') sp--; sp++; *sp=0;

 return str;
}

// Trim leading spaces from the supplied string

char* FD ltrim(char *str)
{
 char *sp=str;

 while(*sp++==' '); sp--; if (sp!=str) strcpy(str,sp);

 return str;
}

// Get a date in dbf form from an ANSI time

char* FD getdate(time_t time)
{
 static char _rdate[9];
 struct tm *tms;

 tms=localtime(&time);
 sprintf(_rdate,"%04d%02d%02d",
	 tms->tm_year+1900,tms->tm_mon+1,tms->tm_mday);
 return _rdate;
}

// Get a time in ANSI form (seconds since 1970)

time_t FD gettime(char *date)
{
 int m,d,y;
 struct tm tms;

 tms.tm_sec=tms.tm_min=tms.tm_hour=tms.tm_isdst=0;
 gnums(date,d,m,y);
 tms.tm_mday=d; tms.tm_mon=m-1; tms.tm_year=y-1900;
 return(mktime(&tms));
}

// Get date into number of days, months and years

void FD gnums(char *date,int &d,int &m,int &y)
{
 char lt[9];

 strncpy(lt,date,9);

 d=atoi(lt+6); lt[6]=0;
 m=atoi(lt+4); lt[4]=0;
 y=atoi(lt);
}


// Swap data put characters after the c character in the front
// of the string, follow by a space and the rest of the string.
// e.g. swapdate("LYNCH~JON",'~') results in "JON LYNCH"

char* FD swapdata(char *s,int c)
{
 char ws[256],*wsp;

 if (strlen(s)>254) return s;

 wsp=strchr(s,c); if (!wsp) return s;

 strcpy(ws,wsp+1); *wsp=0; strcat(ws," "); strcat(ws,s);
 return(strcpy(s,ws));
}

// Compare a string in dBase format, e.g. "Barclay" & "B" is true

int FD strcmpdb(char *s1,char *s2,int l1)
{
 if (l1==-1) l1=strlen(s1);
 int l2=strlen(s2);
 if (l1<l2)		// Length 1 < Length 2 so cannot be equal
 {
  int rv=strnicmp(s1,s2,l1);
  return (rv<=0) ? -1 : 1;
 }
 return(strnicmp(s1,s2,l2));
}
