// This is the header file for the database analysis package

// This file holds private functions, structures etc.

// Robin Abbott, 6/9/91

// Structure for a cluster in an index file
// Related functions in the record file

#include "database.hpp"		// Universal includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <conio.h>
#include <math.h>
#include <io.h>

// Functions

int compnum(void *field,void *num);	// Compare field and number

//
// indclus. This structure holds one index block from the NDX file
// Note that several records may refer to the same indclus
// and the nuse member holds a count of the number of times this cluster is
// in use
//

struct indclus
{
 struct indclus *parent;	// Pointer to parent of this cluster
 struct indclus *next;		// Next indclus in list
 struct indclus *prev;		// Previous indclus in list
 int nuse;			// No. of times in use
 int change;			// Flags this cluster has been changed
 int valid;			// Cluster has not been deleted
 char clusdat[512];		// Holds the cluster data
 int nclusrec;			// Number of records in this cluster
 int clustyp;			// Type of cluster, 0=record, 1=pointer
 int reclen;			// Length of expr(rounded up to word)+pointers
 int explen;			// Length of expression in cluster
 index *oi;			// Owning index
 FILE *fp;			// File pointer from which this was got
 long clusn;			// Cluster number

 indclus(long nclus,indclus *parent,
         index *oi);				// Construct
 ~indclus();					// Destructor

 struct indpt *findptr(int &rn);		// Find block pting to cluster
 void subtract(int rn);				// Remove key
 int add(char *nkey,long rn,int in,int rsk);	// Insert a key
 int newkey(long kclus,char *nkey,long nclus);	    // Replace key with new one
 char *verclus(void (*progress)(int,long),int o);   // Verify a cluster tree
};

//
// The indpt structure holds a pointer to an indclus record. There is one of
// these for each record which has an index, and the indpt structures form
// a tree
//

struct indpt
{
 indclus *icp;		// Points to associated indclus
 indpt *parent;		// Parent of this indpt
 int currec;		// Current record in indclus

 indpt(indclus *);			    // Construct pointing to indclus
 indpt(long nclus,indpt *parent,index *oi); // Construct with parent
 ~indpt();				    // Destruct

 indpt *selkey(char *v,int n,int &r,int &i); // Construct & select by key
};

// Structure for an index file

struct index
{
 char fname[128];	// 128 character filename
 FILE *fp;		// File for this index
 char name[10];		// Name of index without path or extension
 index *next;		// next index on list
 struct indclus *topind; // Pointer to current index tree, top cluster
 int nclus;		 // no. of index clusters attached
 char indexp[128];	 // Index expression
 char tindexp[512];	 // Tokenised index expression
 int indtype;		 // Index type, OPINT or OPSTR
 char fclus[512];	 // Holds 1st cluster of index file
 long tblk;		 // top block of tree
 long lblk;		 // last block of tree
 int chng;		 // index 1st cluster has changed flag
 int maxclusrec;	 // Max. no. of records/cluster
 record *firstrec;	 // Points to records using this index
 int restype;		// Result type, OPINT,OPSTR or OPDATE

 ~index();		 // delete, updating fclus & writing if necessary
};


#define DBSIZE 	32	  // Size of a database file definition record
#define INDLEN 	18	  // Position of index record length in index file
#define INDELEN 12
#define INDEXP  24	  // Index expression offset
#define INDTYPE 16	  // Index result type
#define DATEOFF 1721045L  // Offset of date added in dBASE

void fputi(int i,FILE *fp);	// Put an integer to file
void fputl(long l,FILE *fp);	// Put a long to a file

/***************************************************************************

 Here comes all the stuff concerned with evaluating expressions

****************************************************************************/

/* Header file for expression evaluator, modify as required */

/* Structures used by the program */

struct	opinf		// Information on an operator
{
 char	lit[10];	// Literal string representing the operator
 int	type;		// Type of operator
 int	pri;		// Priority of binary operator
 int	type1;		// Type of 1st (or only) operand
 int 	type2;		// Type of 2nd operand (binary only)
 int    optype;		// Result of operator
 int	num;		// Number of operator
};

struct op	  // An operand structure
{
 int	optype;   // Type of operand, 1=int, 2=string, 4=Date, 8=Logical
 int 	oplen;	  // Length of result for string in index checking
 union
 {
  double	num;		// Return value, number
  char   	*str;		// Return address of string
  char		date[9];	// Date string
 };
};

class expval
{
 struct op retop;	     	     // Value returned from evaluator
 char 	*exwork;		     // Evaluator work space pointer
 char	*exworkp;		     // Points to next free space in exwork
 database *db;			     // Points to owner database
 
 int	exescan(char **,int f=0);    	    //  Scan for next character 
 int	exegetop(int c,char **s);	    // Try to find an operator
 op 	*evalstr(char **,int,record *rp);   // Evaluate a tokenised string
 char	*exealloc(int);			    // Allocate some work space 
 void	execomp(struct op*,struct op*,int); // Comparison Routine
 void   plumin(struct op*, struct op*,int); // Handle plus/minus
 void   exestr(struct op*,int sint,
               struct op*,int type);	    // Handle Left,right,substr

 public:

 // Common routines and variables

 int erflag;		 // An error occurred on expression evaluation

 expval(database *db);	// Initialisation routine
 ~expval();

 int	exeinput(char*,int);		// Input routine
 char   *exetoken(char *,char **);      // Tokeniser routine
 op 	*exeval(char **,record *rp);	// Evaluate a string
 long	days(char *date);		// Convert string to days since 0
 char 	*cdow(char *date);			// day of week (character)
 char   *cmonth(char *date);			// Month (character)
 void   daystodate(char *date,long days);	// days to date
 void   ctod(char *date,char *s);		// String to date
 int	dow(char *date);			// day of week (numeric)

 // User supplied routines

 void	err(char *); 				// Recoverable error
 void	errfatal(char *s);
};


/*
   Expression Evaluator.
   Internal Buffer Sizes, Only modify if program crashes out with
   a memory error.
*/


#define EXWORKSIZE	1024		// Size of evaluator work space

#include "exop.hpp"
