//
// Cthugha - Audio Seeded Image Processing
//
// Zaph, Digital Aasvogel Group, Torps Productions 1993-1995
//


// Why PETE.C ??
// 'cause late one Saturday night, Pete wanted to write some code
// and I let him do a couple of functions (only one survives, I 
// took over the others :-)


#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>

#include "cthugha.h"
#include "charset.h"
#include "pete.h"

/* Defines for Soundblaster and Soundblaster Pro IO address */

int sine[320];


char swirl[5]="-\\|/";
extern char divsub[1024];
int swirlnum=0;

void init_pete(void)
{
	int i;
	static float xx,ss,cc;
	static int k;

//	printf("Initialising cos/sin tables ");

	for (i=0; i<1024; i++) {
		divsub[i]=i>>2;
		if (divsub[i])
			divsub[i]--;
	}
	for (i=0; i<320; i++)
		sine[i]=(int)(128*sin((float)i*0.03927));

//	printf("\n");

}

void wave_pete0(void)
{
	int temp,temp2,x;
	static int xoff0=BUFF_WIDTH/2,yoff0=BUFF_HEIGHT/2;
	static int xoff1=BUFF_WIDTH/2,yoff1=BUFF_HEIGHT/2;

	xoff0 += stereo[0][0]%9-4;
	yoff0 += stereo[1][0]%9-4;

	xoff1 += stereo[0][1]%9-4;
	yoff1 += stereo[1][1]%9-4;

	if (xoff0<0)
		xoff0+=BUFF_WIDTH;
	if (yoff0<0)
		yoff0+=BUFF_BOTTOM;

	if (xoff1<0)
		xoff1+=BUFF_WIDTH;
	if (yoff1<0)
		yoff1+=BUFF_BOTTOM;

	xoff0=xoff0%BUFF_WIDTH;
	xoff1=xoff1%BUFF_WIDTH;

	yoff0=yoff0%BUFF_HEIGHT;
	yoff1=yoff1%BUFF_HEIGHT;

	for (x=0; x<BUFF_WIDTH; x++) {
		temp=stereo[x][0];
		temp2=stereo[(x+80)%BUFF_WIDTH][0];

		buff[(((temp>>2)+yoff0)%BUFF_BOTTOM)*BUFF_WIDTH+(((temp2>>2)+xoff0)%BUFF_WIDTH)]=table[curtable][temp];

		temp=stereo[x][1];
		temp2=stereo[(x+80)%BUFF_WIDTH][1];

		buff[(((temp>>2)+yoff1)%BUFF_BOTTOM)*BUFF_WIDTH+(((temp2>>2)+xoff1)%BUFF_WIDTH)]=table[curtable][temp];

	}

}

void wave_pete1(void)
{
	int temp,x,left=0,right=0;

	for (x=0; x<BUFF_WIDTH; x++) {
		left += abs(stereo [x][0] - 128);
		right += abs(stereo [x][1] - 128);
	}

	left = left / (160);
	right = right / (160);

	left=min(left,199);
	right=min(right,199);

	for (x=0; x<160; x++) {
		temp=stereo[x][0];
		buff[(200-(abs((left)*sine[x])>>8))*BUFF_WIDTH+(x)]=table[curtable][temp];
	}
	for	(x=160; x<320; x++) {
		temp=stereo[x][1];
		buff[(200-(abs((right)*sine[x])>>8))*BUFF_WIDTH+(x)]=table[curtable][temp];
	}

}

void wave_pete2(void)
{
	int temp,x;

	for (x=0; x<200; x++) {
		temp=stereo[x][0];
		buff[(x)*BUFF_WIDTH+(160-(temp>>2))]=table[curtable][sine[temp]];
		temp=stereo[x][1];
		buff[(x)*BUFF_WIDTH+(160+(temp>>2))]=table[curtable][sine[temp]];
	}

}


void wave_fract1(void)
{
	int temp,x;
	static int xoff0=BUFF_WIDTH/2,yoff0=BUFF_HEIGHT/2;
	static int xoff1=BUFF_WIDTH/2,yoff1=BUFF_HEIGHT/2;

	temp=stereo[0][0];
	for (x=0; x<BUFF_WIDTH-2; x+=2) {
		xoff0 += (stereo[x][0]-temp)>>1;
		temp=stereo[x][0];


		if (xoff0<0)
			xoff0=BUFF_WIDTH-1;

		xoff0=xoff0%BUFF_WIDTH;

		buff[(yoff0)*BUFF_WIDTH+(xoff0)]=table[curtable][temp];

		yoff0 += (stereo[x+1][0]-temp)>>1;
		temp=stereo[x+1][0];

		if (yoff0<0)
			yoff0=BUFF_HEIGHT-1;

		yoff0=yoff0%BUFF_HEIGHT;

		buff[(yoff0)*BUFF_WIDTH+(xoff0)]=table[curtable][temp];

	}

	temp=stereo[0][1];
	for (x=0; x<BUFF_WIDTH-2; x+=2) {
		xoff1 += (stereo[x][1]-temp)>>1;
		temp=stereo[x][1];


		if (xoff1<0)
			xoff1=BUFF_WIDTH-1;

		xoff1=xoff1%BUFF_WIDTH;

		buff[(yoff1)*BUFF_WIDTH+(xoff1)]=table[curtable][temp];

		yoff1 -= (stereo[x+1][1]-temp)>>1;
		temp=stereo[x+1][1];

		if (yoff1<0)
			yoff1=BUFF_HEIGHT-1;

		yoff1=yoff1%BUFF_HEIGHT;

		buff[(yoff1)*BUFF_WIDTH+(xoff1)]=table[curtable][temp];

	}
}

void wave_fract2(void)
{
	int temp,x;
	static int xoff0=BUFF_WIDTH/2,yoff0=BUFF_HEIGHT/2;
	static int xoff1=BUFF_WIDTH/2,yoff1=BUFF_HEIGHT/2;

	temp=stereo[0][0];
	for (x=0; x<BUFF_WIDTH-2; x+=2) {
		xoff0 += (stereo[x][0]-temp);
		temp=stereo[x][0];


		if (xoff0<0)
			xoff0=BUFF_WIDTH-1;

		xoff0=xoff0%BUFF_WIDTH;

		buff[(yoff0)*BUFF_WIDTH+(xoff0)]=table[curtable][temp];

		yoff0 += (stereo[x+1][0]-temp);
		temp=stereo[x+1][0];

		if (yoff0<0)
			yoff0=BUFF_HEIGHT-1;

		yoff0=yoff0%BUFF_HEIGHT;

		buff[(yoff0)*BUFF_WIDTH+(xoff0)]=table[curtable][temp];

	}

	temp=stereo[0][1];
	for (x=0; x<BUFF_WIDTH-2; x+=2) {
		xoff1 += (stereo[x][1]-temp);
		temp=stereo[x][1];


		if (xoff1<0)
			xoff1=BUFF_WIDTH-1;

		xoff1=xoff1%BUFF_WIDTH;

		buff[(yoff1)*BUFF_WIDTH+(xoff1)]=table[curtable][temp];

		yoff1 -= (stereo[x+1][1]-temp);
		temp=stereo[x+1][1];

		if (yoff1<0)
			yoff1=BUFF_HEIGHT-1;

		yoff1=yoff1%BUFF_HEIGHT;

		buff[(yoff1)*BUFF_WIDTH+(xoff1)]=table[curtable][temp];

	}
}

#include "maps.h"
extern int curpal;

void FFT(int channel)
{
	static struct _SREGS sreg;
	static union _REGS reg;
	unsigned char *p, *q;
	extern unsigned char LUTbuffer[LUTSIZE];
	static unsigned int slab[BUFF_WIDTH];
	int dir,currentd,lastgot,i,lens,got, lastd=1,temp;
//	int maxheight;
	int lastcapc,nextonec,amt;
	static int count=0;


	lens=0;
//	if (count>10) {
		for (i=0; i<BUFF_WIDTH; i++) {
			slab[i] = 0;
//			slab[i] >>= 1;
		}
//		count=0;
//	}
//	count++;


	lastgot=128;
	lens=0;
	lastd=1;
//    lenpc = 0;
//    lastdc = 0;
//    lastgotc = 128;
    lastcapc = 128;
    nextonec = 1;


	for (channel=0; channel<2; channel++)
	for (i=0; i<BUFF_WIDTH; i++) {
		got=stereo[i][channel];
		dir=got-lastgot;

		if (dir>1)
			currentd=1;
		else if (dir<-1)
			currentd=-1;
		else
			currentd=lastd;

		if (currentd!=lastd) {
			if (lens>255)
				lens=255;
			lens=lens>>3;

			slab[lens]+=(lens>>1);

			lens=0;

			if (nextonec == 1) {
				nextonec=0;
				lastcapc=got;
			} else {
				nextonec = 1;
				amt=abs(lastcapc-got);
				if (amt>127)
					amt=127;
				slab[amt>>2]++;
			}
		} else
			lens++;


//		lastdc=currentdc;
//		lastgotc=gotit;
		lastd=currentd;
		lastgot=got;
	}

//	for (i=0; i<BUFF_WIDTH; i++) {
//		stereo[i][channel]=slab[i/2];
//	}
	 /* fills the buffer with 8 bit values */

//	memcpy(LUTbuffer,LUTfiles[curpal%numluts],768);

	p = LUTbuffer;
	q = LUTfiles[curpal%numluts];

//	maxheight=slab[0];
//	for (i=1; i<256; i++)
//		maxheight=max(maxheight,slab[i]);

	for (i=0; i<256; i++) {
		temp=slab[(255-i)>>3];

//		if (temp>0)
//			temp--;

		if (temp>6)
			temp=6;

		q = LUTfiles[(curpal+temp)%numluts]+i*3;

		*p++ = *q++;
		*p++ = *q++;
		*p++ = *q++;

	}

	FillLUTBuffer(-1);
//	p = LUTbuffer;

//   reg.x.ax =0x1012;
//   reg.x.bx =0;
//   reg.x.cx =256;

//   sreg.es = _FP_SEG(p);
//   reg.x.dx = _FP_OFF(p);

//   _int86x(0x10, &reg, &reg, &sreg);

}

void wave_test(void)
{
	int temp,x,left=0,right=0;
	int xoff0=BUFF_WIDTH/2,yoff0=BUFF_HEIGHT/2;

	for (x=0; x<BUFF_WIDTH; x++) {
		left += abs(stereo [x][0] - 128);
		right += abs(stereo [x][1] - 128);
	}

	left = left / (128);
	right = right / (128);

	left=min(left,199);
	right=min(right,199);

	for (x=0; x<160; x++) {
		temp=stereo[x][0];
		buff[(200-(abs((left)*sine[x])>>8))*BUFF_WIDTH+(x)]=table[curtable][temp];
	}
	for	(x=160; x<320; x++) {
		temp=stereo[x][1];
		buff[(200-(abs((right)*sine[x])>>8))*BUFF_WIDTH+(x)]=table[curtable][temp];
	}
}
