//
// Cthugha - Audio Seeded Image Processing
//
// Zaph, Digital Aasvogel Group, Torps Productions 1993-1995
//

#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include <bios.h>
#include <memory.h>
#include <assert.h>

#include "cthugha.h"
#include "charset.h"
#include "zorilkey.h"
#include "options.h"
#include "vesa.h"

int olddisp=0,xoffs=0,yoffs=0,dxoffs=0,dyoffs=0;
void display_up(void);
void display_dn(void);

void (*display)(void);

extern int useVesa;
//extern unsigned char tempscrn[BUFF_SIZE];


char norefresh=TRUE;

void set_display_mode(int vesa)
{
	union REGS regset;

	if (vesa) {
		if (setVesaMode(g640x400)) {
			setVesaScanLineLength(320);
			setVesaWinAAddr(1);
//			setVesaDisplayStart(256,100);
//			display_up();
			return;
		} else {
			useVesa=0;  // Failed, so turn it off...
		}
	}

	// Not VESA, or mode failed...

	regset.x.ax = 0x0013;	
	_int86(0x10, &regset, &regset);
//	display_up();

}

void wait_vsync(void)
{

	_asm {
	    mov     dx,0x03da
WaitVS:
	    in      al,dx
    	test    al,0x08
	    jz      WaitVS  ;vertical sync is active high (1 = active)
	}

}

void display_up(void);
void display_dn(void);
void display_2hor(void);
void display_r2hor(void);
void display_4hor(void);
void display_2verd(void);
void display_r2verd(void);
void display_4kal(void);

int numdisplays=-1;

function_opt disparray[]={
	{ display_up,		WHEN_ALWAYS, "Upwards" },
	{ display_dn,		WHEN_ALWAYS, "Downwards" },
	{ display_2hor,		WHEN_ALWAYS, "Hor. Split out" },
	{ display_r2hor,	WHEN_ALWAYS, "Hor. Split in" },
	{ display_4hor,		WHEN_ALWAYS, "Kaleidescope" },
	{ display_2verd,	WHEN_ALWAYS, "90deg rot. mirror" },
	{ display_r2verd,	WHEN_ALWAYS, "90deg rot. mirror 2" },
	{ display_4kal,		WHEN_ALWAYS, "90deg Kaleidescope" },
	{ NULL,				WHEN_NEVER, "<BAD>"}
};

void flip_screens()
{
	unsigned char *temp;

	temp=buff;
	buff=shadow;
	shadow=temp;

}
int change_display(int disp)
{
	if (numdisplays<0) {
		numdisplays=0;
		while (disparray[numdisplays].function!=NULL)
			numdisplays++;
		assert(numdisplays);
	}

	disp=disp%numdisplays;

	disp=check_disp_ok(disp);

	display=disparray[disp].function;

	return disp;

}
void display_up(void)
{
	char *screen;

	FP_SEG(screen)=0xa000;
	FP_OFF(screen)=0;

	if (useVesa) {
		setVesaWinAAddr(0);
		memcpy(screen,buff,64000);
		memcpy(screen+64000,buff,1536);
		setVesaWinAAddr(1);
//		memcpy(screen,buff,64000);
		memcpy(screen,buff+1536,64000-1536);
	} else {
		memcpy(screen,buff,64000);
	}
}

void display_shadowup(void)
{
	char *screen;

	FP_SEG(screen)=0xa000;
	FP_OFF(screen)=0;

	if (useVesa) {
		setVesaWinAAddr(0);
		memcpy(screen,shadow,64000);
		memcpy(screen+64000,shadow,1536);
		setVesaWinAAddr(1);
		memcpy(screen,shadow+1536,64000-1536);
	} else {
		memcpy(screen,shadow,64000);
	}
}


void display_dn(void)
{
	register int i;

	for (i=200; i>0; i--) {
		memcpy(shadow+i*320,&(buff[(i-1)*BUFF_WIDTH]),320);
	}
	display_shadowup();
	return;

#if 0
	char *screen;
	unsigned int i;

	FP_SEG(screen)=0xa000;
	FP_OFF(screen)=0;

	if (useVesa) {

		setVesaWinAAddr(0);
		for (i=200; i>0; i--) {
			memcpy(screen,&(buff[(i-1)*BUFF_WIDTH]),320);
			screen+=320;
		}
		setVesaWinAAddr(1);
		for (i=200; i>0; i--) {
			memcpy(screen,&(buff[(i-1)*BUFF_WIDTH]),320);
			screen+=320;
		}
	} else {
		for (i=200; i>0; i--) {
			memcpy(screen,&(buff[(i-1)*BUFF_WIDTH]),320);
			screen+=320;
		}

	}
#endif
}

void display_2hor(void)
{
	char *screen,*puff;
	int y;

//	FP_SEG(screen)=0xa000;
//	FP_OFF(screen)=0;

	screen=shadow;
	puff=(char*)buff;

	for(y=99;y>=0;y--){
		memcpy(screen,&(buff[(y+100)*BUFF_WIDTH]),320);
		screen+=320;
	}

	memcpy(screen,&(buff[100*BUFF_WIDTH]),(32000));

//	flip_screens();
	display_shadowup();
}

void display_r2hor(void)
{
	char *screen,*puff;
	int y;

//	FP_SEG(screen)=0xa000;
//	FP_OFF(screen)=0;

	screen=shadow;

	puff=(char*)buff;

	memcpy(screen,&(buff[100*BUFF_WIDTH]),(32000));
	screen += (32000);

	for(y=99;y>=0;y--){
		memcpy(screen,&(buff[(y+100)*BUFF_WIDTH]),320);
		screen+=320;
	}
//	flip_screens();
	display_shadowup();
}

void display_4hor(void)
{
	char *screen,*puff;
	unsigned int x,y;

//	FP_SEG(screen)=0xa000;
//	FP_OFF(screen)=0;

	screen=shadow;
	puff=screen+64000u;

	for(y=0;y<=99;y++){
		memcpy(screen,&(buff[(y+100)*BUFF_WIDTH]),160);
		memcpy(puff,&(buff[(y+100)*BUFF_WIDTH]),160);
		for(x=0;x<160;x++) {
			*(screen+160+x)=(buff[(y+100)*BUFF_WIDTH+159-x]);
			*(puff+160+x)=(buff[(y+100)*BUFF_WIDTH+159-x]);
		}
		screen+=320;
		puff-=320;
	}

//	flip_screens();
	display_shadowup();
}


void display_2verd(void)
{
	char *screen,*puff;
	int x,y;

//	FP_SEG(screen)=0xa000;
//	FP_OFF(screen)=0;

	screen=shadow;

	puff=(char*)buff;

	for(y=0;y<200;y++){
		for(x=0;x<160;x++,puff+=320){
			*screen++=*puff;    //buff[x][y];
		}
		for(x=160;x<320;x++, puff-=320){
			*screen++=*puff;   //buff[320-x][y];
		}
		puff++;
	}
//	flip_screens();
	display_shadowup();
}


void display_r2verd(void)
{
	char *screen,*puff;
	int x,y;

//	FP_SEG(screen)=0xa000;
//	FP_OFF(screen)=0;

	screen=shadow;

	puff=(char*)buff;

	puff += 64000u;

	for(y=0;y<200;y++){
		for(x=0;x<160;x++){
			*screen++=*puff;    //buff[x][y];
			puff-=320;
		}

		for(x=160 ;x<320;x++){
			*screen++=*puff;   //buff[320-x][y];
			puff+=320;
		}

		puff--;
	}

#if 0
	puff=(char*)buff;

	screen+=64000u;

	for(y=0;y<200;y++){
		for(x=0;x<160;x++){
			*screen--=*puff;    //buff[x][y];
			puff+=320;
		}

		for(x=160 ;x<320;x++){
			*screen--=*puff;   //buff[320-x][y];
			puff-=320;
		}

		puff++;
	}
#endif

//	flip_screens();
	display_shadowup();
}
void display_4kal(void)
{
	char *screen,*puff,*duff;
	int x,y;

//	FP_SEG(screen)=0xa000;
//	FP_OFF(screen)=0;

	screen=shadow;

	puff=(char*)buff;
	duff=screen;
	duff+=32000u;
	duff+=32000u;

	for(y=0;y<100;y++){
		for(x=0;x<160;x++){
			*screen++=*puff;    //buff[x][y];
			*duff--=*puff;    //buff[x][y];
			puff+=320;
		}
		for(x=160 ;x<320;x++){
			*screen++=*puff;   //buff[320-x][y];
			*duff--=*puff;   //buff[320-x][y];
			puff-=320;
		}
		puff++;
	}
#if 0
	puff=(char*) buff;
	screen+=32000u;
	for(y=0;y<100;y++){
		for(x=0;x<160;x++){
			*screen--=*puff;    //buff[x][y];
			puff+=320;
		}
		for(x=160 ;x<320;x++){
			*screen--=*puff;   //buff[320-x][y];
			puff-=320;
		}
		puff++;
	}
#endif


//	flip_screens();
	display_shadowup();

}

void draw_text(int xpos, int ypos, int size, int colour, char *tbuf)
{
	int    x,y,i,j;
	unsigned char                   mask;
	unsigned char *cdef_ptr;

	if (size<=0)
   		return;

	while (*tbuf) {
	   	cdef_ptr = charset[*tbuf];
   		for (y=ypos; y<=ypos+(size*char_height)-1; y+=size) {
			mask=0x80;
			for (x=xpos; x<xpos+(size*(char_width+1)); x+=size) {
				if ((*cdef_ptr)&mask) {
					if (size==1)
						if (curdisplay)
							buff[(199-y)*BUFF_WIDTH+x]=colour;
						else
							buff[y*BUFF_WIDTH+x]=colour;
					else
						for (i=0; i<size; i++)
							for (j=0; j<size; j++)
								if (curdisplay)
									buff[(199-(y+i))*BUFF_WIDTH+(x+j)]=colour;
								else
									buff[(y+i)*BUFF_WIDTH+x+j]=colour;
				}
				mask>>=1;
				}
			cdef_ptr++;
		}
   		tbuf++;
		xpos+=size*(char_width+1);
  	}
}

