//
// Cthugha - Audio Seeded Image Processing
//
// Zaph, Digital Aasvogel Group, Torps Productions 1993-1995



#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include <assert.h>
#include <bios.h>
#include <string.h>
#include <ctype.h>

#include "audio.h"
#include "cthugha.h"

#include "pcmio.h"
#include "common.h"
#include "mixers.h"
#include "binary.h"

extern void draw_text(int xpos, int ypos, int size, int colour, char *tbuf);

int PASok=0;

int sample_stereo;
extern char	 far * near voice_drv ;
extern int in_vol;


void PAS_close(void);
int PAS_firsttime(void);
int PAS_everytime(int wait);
int PAS_get_level(int channel);
static int Sbpro_Get_Params(void);
int PAS_set_input(enum device_list device);
int PAS_set_level(int channel, int level);
int PAS_level_incr(int channel);

int PAS_init(void)
{
	if (mvGetHWVersion(USE_ACTIVE_ADDR) == -1) {
		return -1;
	}

	buffer_size=2*BUFF_WIDTH+80;
//	buffer_size=0x20000L;

	TurnItOff();

	if (!_dos_allocmem((int)((buffer_size+15)>>4),&tempBuff)) {
		FP_SEG(voice_buffer) = tempBuff ;
		FP_OFF(voice_buffer) = 0 ;

		voice_seg=FP_SEG(voice_buffer);

	} else {
		return -2;
	}

	if (OpenPCMBuffering(-1,-1,4,4)) {
		return -3;
	}

	PCMState (sample_rate, sample_stereo, 0, 8); 	/* 22050 khz, stereo, 8 bit pcm	*/

	close_audio = PAS_close;
	audio_firsttime = PAS_firsttime;
	audio_everytime = PAS_everytime;

	set_input = PAS_set_input;

	get_level = PAS_get_level;
	set_level = PAS_set_level;

	level_incr = PAS_level_incr;

	return 0;
}

void PAS_close(void)
{
	if (PASok) {
		ClosePCMBuffering();
		TurnItOn();
		_dos_freemem(tempBuff);
	}
}


int PAS_firsttime(void)
{
	set_input(device);

	last_rate = sample_rate;

	PCMState (sample_rate, sample_stereo, 0, 8);

	StartBlockInput();
	ContinueBlockInput(voice_buffer);

	return 0;
}

int PAS_everytime(int wait)
{
	int x,y;
	static int prev=128;
	unsigned char far *sbuff ;
//	unsigned char far *sbuff2 ;
	int noisy=0,last=0;
	static int firsttime=1;
//	int ln,hn;
//	int v1,v2;

	while (!(ContinueBlockInput(voice_buffer))) {
		if (_kbhit())
			StopDMAIO();
	}

	sbuff=voice_buffer;
	sbuff+=6;

	last=*sbuff;
	sbuff++;
	for (x=0; x<30; x+=2) {
		//align...
		if ((*sbuff)>=prev && last<prev-1) {
			break;
		} else {
			last= *sbuff;
		}
	}

	prev=*sbuff;

	for (y=0; y<2; y++)
		for (x=0; x<BUFF_WIDTH; x++) {
			stereo[x][y]=*sbuff++;
		}

	StartBlockInput();
	ContinueBlockInput(voice_buffer);

	return 1;

}

#define MASTER_VOL  0x22
#define VOC_VOL     0x04
#define LINE_VOL    0x2E
#define FM_VOL	    0x26
#define CD_VOL	    0x28
#define MIC_VOL	    0x0A
#define RECORD_SRC  0x0C

#define MIC	    0x11
#define LINE	    0x17
#define CD	    0x13

int PAS_get_level(int channel)
{
	int vol,left,right;

	switch (channel) {
		case MIXline:
			left= cMVGetMixerFunction(BI_INPUTMIXER,BI_L_PCM);
			right=cMVGetMixerFunction(BI_INPUTMIXER,BI_R_PCM);

			break;
		case MIXmicrophone:
			left= cMVGetMixerFunction(BI_INPUTMIXER,BI_L_MIC);
			right=cMVGetMixerFunction(BI_INPUTMIXER,BI_R_MIC);
			break;
		case MIXmaster:
		    left = cMVGetVolumeFunction(BI_VOLLEFT);
		    right= cMVGetVolumeFunction(BI_VOLRIGHT);
			break;
		case MIXcd:
			left= cMVGetMixerFunction(BI_INPUTMIXER,BI_L_SBDAC);
			right=cMVGetMixerFunction(BI_INPUTMIXER,BI_R_SBDAC);
			break;
		default:
		case MIXtreble:
		    left = cMVGetVolumeFunction(BI_VOLTREBLE);
		    right= cMVGetVolumeFunction(BI_VOLTREBLE);
			break;
		case MIXbass:
		    left = cMVGetVolumeFunction(BI_VOLBASS);
		    right= cMVGetVolumeFunction(BI_VOLBASS);
			break;

	}
	return ((right+left)/2)<<4;
}

#if 0
{
	unsigned char data_buf[(2*BUFF_WIDTH)+80];

	int i,left,right;

	int lmin = 255, lmax = 0, rmin = 255, rmax = 0;

	if( last_rate != 1 ) {
		last_rate = 1;
		dsp_set_record(4000,sample_stereo,8,0);
	}

	if( dsp_read(data_buf) > 1 )
		return 0;

	for( i = 0; i < buffer_size; i += 2 )
	{
		lmin = data_buf[i  ] < lmin ? data_buf[i] : lmin;
		lmax = data_buf[i  ] > lmax ? data_buf[i] : lmax;

		rmin = data_buf[i+1] < rmin ? data_buf[i] : rmin;
		rmax = data_buf[i+1] > rmax ? data_buf[i] : rmax;
	}

	left  = abs(lmax-lmin);
	right = abs(rmax-rmin);

	if( (lmax==255) || (lmin==0) )
		left = 255;

	if( (rmax==255) || (rmin==0) )
		right = 255;


	return ((left+right)/2)<<4;
}
#endif

int PAS_set_input(enum device_list device)
{
	switch (device) {
		case CDInput:
			break;
		case MicInput:
			break;
		default:
		case LineInput:
			break;
	}
}

int PAS_set_level(int channel, int level)
{
	switch (channel) {
		case MIXline:
			cMVSetMixerFunction(level,BI_INPUTMIXER,BI_L_PCM);
			cMVSetMixerFunction(level,BI_INPUTMIXER,BI_R_PCM);
			break;
		case MIXmicrophone:
			cMVSetMixerFunction(level,BI_INPUTMIXER,BI_L_MIC);
			cMVSetMixerFunction(level,BI_INPUTMIXER,BI_R_MIC);
			break;
		case MIXcd:
			cMVSetMixerFunction(level,BI_INPUTMIXER,BI_L_SBDAC);
			cMVSetMixerFunction(level,BI_INPUTMIXER,BI_R_SBDAC);
			break;
		case MIXmaster:
		    cMVGetVolumeFunction(level,BI_VOLLEFT);
		    cMVGetVolumeFunction(level,BI_VOLRIGHT);
			break;
		case MIXtreble:
		    cMVGetVolumeFunction(level,BI_VOLTREBLE);
			break;
		case MIXbass:
		    cMVGetVolumeFunction(level,BI_VOLBASS);
			break;
	}
	return 0;
}

int PAS_level_incr(int channel)
{
	return( channel == MIXmicrophone ? 64 : 32 );
}

