//
// Cthugha - Audio Seeded Image Processing
//
// Zaph, Digital Aasvogel Group, Torps Productions 1993-1995
//


#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include <bios.h>
#include <memory.h>
#include <assert.h>
#include <time.h>

#include "cthugha.h"
#include "charset.h"
#include "zorilkey.h"
#include "audio.h"
#include "translat.h"
#include "options.h"
#include "display.h"
#include "pete.h"

#define NUMSTRINGS 20

char stringtable[NUMSTRINGS][21]={
//	"---------|---------"
	" Wheres the music? ",
	"       JOLT !      ",
	"      Hey, You!!   ",
	" Turn The Music On ",
	"    Lets Party!!!  ",
	" Pink Floyd Rules  ",
	"Sounds of Silence ?",
	"     The Torps     ",
	"     Play QUAKE    ",
	"     Drink COKE    ",
	" Press F1 for help ",
	"Consume!           ",
	"Spooky Mulder....  ",
	"Wheres Cthugha 6.0?",
	"   Subliminal Ads  ",
	"Read a book        ",
	"     Get a life....",
	"      SMILE!       ",
	"    Cthugha 5.3    ",
	" Torps Productions "
};


extern int peaks,peakframes,peaknoise;
extern int massage_audio(void);
extern int allow_fft,use_fft;

void (*flame)(void);
extern void (*wave)(void);

static void flame_upslow(void);
static void flame_upsubtle(void);
static void flame_upfast(void);
static void flame_leftslow(void);
static void flame_leftsubtle(void);
static void flame_leftfast(void);
static void flame_rightslow(void);
static void flame_rightsubtle(void);
static void flame_rightfast(void);
static void flame_water(void);
static void flame_watersubtle(void);
static void flame_skyline(void);
static void flame_weird(void);
static void flame_fade(void);
static void flame_zzz(void);


int numflames=-1;
function_opt flamearray[]={
	{ flame_leftslow,	WHEN_ALWAYS, "Slow Left" },
	{ flame_leftsubtle,	WHEN_ALWAYS, "Left Subtle" },
	{ flame_leftfast,	WHEN_ALWAYS, "Left Fast" },
	{ flame_upslow,		WHEN_ALWAYS, "Up Slow" },
	{ flame_upsubtle,	WHEN_ALWAYS, "Up Subtle" },
	{ flame_upfast,		WHEN_ALWAYS, "Up Fast" },
	{ flame_rightslow,	WHEN_ALWAYS, "Right Slow" },
	{ flame_rightsubtle,WHEN_ALWAYS, "Right Subtle" },
	{ flame_rightfast,	WHEN_ALWAYS, "Right Fast" },
	{ flame_water,		WHEN_ALWAYS, "Water" },
	{ flame_watersubtle,WHEN_ALWAYS, "Water Subtle" },
	{ flame_skyline,	WHEN_ALWAYS, "Skyline" },
	{ flame_weird,		WHEN_ALWAYS, "Weird" },
	{ flame_zzz,		WHEN_ALWAYS, "Zzz" },
	{ flame_fade,		WHEN_ALWAYS, "Fade" },
	{ NULL,				WHEN_NEVER, "<BAD>" }
};
// Change the flame function pointer...



int change_flame(int flamenum)
{
//	int start;

	if (numflames<0) {
		numflames=0;
		while (flamearray[numflames].function!=NULL)
			numflames++;
		assert(numflames);
	}

	flamenum=flamenum%numflames;

	flamenum=check_flame_ok(flamenum);

	flame=flamearray[flamenum].function;

	return flamenum;
}

// The flame main loop
// Runs the flame, 
// Gets the stereo, 
// produces the wave
// and then displays it...

extern int was_quiet;
// extern void wave(void);

extern int time_to_change;

extern void draw_text(int xpos, int ypos, int size, int colour, char *tbuf);
extern int quiet_change;

extern void wait_vsync(void);
extern char norefresh;

clock_t start,end;
int frames;
int pcxtime=0;

#include "hi.h"
#include "maps.h"

#define MAXPCX  20
extern int nrpcx,actpcx;
extern int use_pcx_files,pcxcount,pcxev;
extern _vmhnd_t pcxh[MAXPCX],palh;
extern int useVesa;

void timeflames(void)
{
	int i,j;
	clock_t all[20];
	FILE *fp;
	int frames=100;

	fp=fopen("flames.dbg","a");
	printf("\nTiming %d frames for %d flames\n",frames,numflames);

	for (j=0; j<numflames; j++) {
		change_flame(j);
		printf("Current flame  = %-20s ",flamearray[j].name);

		start=clock();
		for (i=0; i<frames; i++ )
			flame();
		end=clock();

		printf("ave ticks = %6.2f\n",((float)end-(float)start)/(float)(frames));
		all[j]=end-start;
	}

	fprintf(fp,"Timing %d frames for %d flames, ",frames,numflames);
	fprintf(fp,"%d displays\n",numdisplays);

	for (j=0; j<numflames; j++) {
		fprintf(fp,"%2.0f ",((float)all[j])/(float)(frames));
	}

//	set_display_mode(useVesa);

//	fprintf(fp,"Timing %d frames for %d displays\n",frames,numdisplays);
	fprintf(fp," : ");
	for (j=0; j<numdisplays; j++) {
		change_display(j);
		printf("Current disp   = %-20s ",disparray[j].name);

		start=clock();
		for (i=0; i<frames; i++ )
			display();
		end=clock();

		printf("ave ticks = %6.2f\n",((float)end-(float)start)/(float)(frames));
		all[j]=end-start;
	}

	for (j=0; j<numdisplays; j++) {
		fprintf(fp,"%2.0f ",((float)all[j])/(float)(frames));
	}
	fprintf(fp,"\n");

	fclose(fp);
}

void flame_cro(void)
{
	int count,res=0, pcx=0;
	static quiet=0,showstring=0;
	static linenum=42;
//	int i,y;
	int multiframe=0;

	count=rand()%rand_time+min_time;

//	memset(buff[BUFF_BOTTOM+1],0,BUFF_WIDTH*2);
#if 0
	for (temp=0; temp<BUFF_WIDTH; temp++) {
		buff[BUFF_BOTTOM][temp]=0;
		buff[BUFF_BOTTOM+1][temp]=0;
		buff[BUFF_BOTTOM+2][temp]=0;
		buff[BUFF_BOTTOM+3][temp]=0;
	}
#else
	memset(&(buff[BUFF_BOTTOM*BUFF_WIDTH]),0,BUFF_WIDTH*4);
#endif
	start=clock();
	frames=0;
	while ((_bios_keybrd(_KEYBRD_READY)==0) && (count>0)) {
		frames++;
		count--;


		if (translate)
			translate_screen();

		if (pcxtime>0) {
			pcxtime--;
//			flame();
		} else {
			flame();
		}

		if (get_stereo()) {

//			if (massageStyle)
//				massage_audio();

			if (allow_fft && use_fft) {
				FFT(0);
			}
			wave();
			if (quiet_change)
				if (quiet>quiet_change) {
					was_quiet=1;
					quiet=0;
				} else {  // We *HAD* silence, but now its noisy again!!
					if (was_quiet) {
						was_quiet=0;
						count=0;
					}
				}
			if (peakframes>0) {
				if (peaknoise) {
					peaks++;
					if (peaks>peakframes) {
						peaks=0;
						time_to_change=1;
						count=0;
					}
				}

			}
		} else {
			quiet++;
			if (quiet>255) {
				draw_text(0,linenum,2,table[curtable][0],stringtable[showstring]);
				draw_text(1,linenum+1,2,table[curtable][quiet-255],stringtable[showstring]);
				if (quiet>512) {
					quiet=0;
					showstring=rand()%NUMSTRINGS;
					linenum=rand()%80;
				}
			}
		}

		if (!norefresh)
			wait_vsync();

		display();

	}
	end=clock();

}

extern unsigned char xbuff[BUFF_HEIGHT][BUFF_WIDTH];
char divsub[1024];

unsigned char *src;
unsigned srcseg,srcoff;

//#pragma optimize("a", on)

#if 0
;	i = -8
;	tmp = -2
;	src = -6
;	dst = -12
;	tmp2 = -14
	les	cx,DWORD PTR _buff
; Line 371
	mov	di,cx
; Line 374
	mov	ax,cx
	mov	dx,es
	add	ax,321	;0141H
	mov	si,ax
	mov	bx,ax
	mov	WORD PTR [bp-4],es
; Line 375
	mov	al,BYTE PTR es:[bx-3]
	mov	dl,BYTE PTR es:[bx-2]
	mov	WORD PTR [bp-14],ax	;tmp2
	mov	al,BYTE PTR es:[bx-1]
	sub	ah,ah
	sub	dh,dh
	add	ax,dx
	mov	dl,BYTE PTR [bp-14]	;tmp2
	add	ax,dx
; Line 376
	mov	WORD PTR [bp-8],-256	;ff00H	;i
	mov	cx,ax
	mov	ds,WORD PTR [bp-4]
	ASSUME DS: NOTHING
$F853:
; Line 379
	mov	bl,BYTE PTR [si+319]
	sub	bh,bh
	mov	al,BYTE PTR [si]
	sub	ah,ah
	mov	dl,BYTE PTR [si-3]
	sub	dh,dh
	sub	ax,dx
	add	cx,ax
	add	bx,cx
	mov	al,BYTE PTR ss:_divsub[bx]
	mov	BYTE PTR es:[di],al
; Line 381
	inc	si
; Line 382
	inc	di
	dec	WORD PTR [bp-8]	;i
	jne	SHORT $F853
; Line 387
	push	ss
	pop	ds
	ASSUME DS: DGROUP
	pop	si
	pop	di
	leave	
	ret	

#endif

// Standard flame (upwards)
static void flame_upslow(void)
{
#if 1
	src=buff;
	srcseg=FP_SEG(src);
	srcoff=FP_OFF(src);
		_asm {
			pusha;

//			mov cx,64636;
			mov cx,32318;
			mov dx,srcseg;
			mov es,dx;
			mov dx,srcoff;
			mov di,BUFF_WIDTH;
			xor bx,bx;
			xor ax,ax;
			}
jp11:    _asm {
//			xor ax,ax;
			sub ah,ah;
			mov al,byte ptr es:[di-1];
			mov bl,byte ptr es:[di];
			add ax,bx;
			mov bl,es:[di+1];
			add ax,bx;
			mov bl,es:[di+BUFF_WIDTH];
			add ax,bx;
//			shr ax,2;
//			jz jp12;
//			dec ax;
//			}
//jp12:    _asm {
//			mov dl,al;
			mov si,ax;
			mov dl,divsub[si];
			inc di;

//			xor ax,ax;
			sub ah,ah;
			mov al,byte ptr es:[di-1];
			mov bl,byte ptr es:[di];
			add ax,bx;
			mov bl,es:[di+1];
			add ax,bx;
			mov bl,es:[di+BUFF_WIDTH];
			add ax,bx;
//			shr ax,2;
//  			jz jp12b;
//			dec ax;
//			}
//jp12b:    _asm {
//			mov dh,al
			mov si,ax;
			mov dh,divsub[si];
			mov es:[di-BUFF_WIDTH-1],dx;
			inc di;

			loop jp11;

			popa;
		}
#else
    int i;
    unsigned int tmp;
    unsigned char * src = buff + BUFF_WIDTH;
    unsigned char * dst = buff;
    unsigned int tmp2;

    src ++;   
    tmp = (unsigned int)(* (src-2-1)) + (unsigned int)(* (src-1-1)) + (unsigned int)(* (src-1));
    for(i=BUFF_SIZE; i != 0; i--) {
        tmp = tmp - (unsigned int)(* (src-2-1)) + (unsigned int)(* (src+1-1));
		tmp2 = tmp + (unsigned int)(* (src+BUFF_WIDTH-1));
		* dst = divsub[tmp2];

		src ++;
		dst ++;
    }

#endif

}

static void flame_upsubtle(void)
{
	src=buff;
	srcseg=FP_SEG(src);
	srcoff=FP_OFF(src);
		_asm {
			pusha;

//			mov cx,64636;
			mov cx,32318;
			mov dx,srcseg;
			mov es,dx;
			mov dx,srcoff;
			mov di,BUFF_WIDTH;
			}
jp11:    _asm {
			xor ax,ax;
			mov al,es:[di-1];
			add al,es:[di];
			add al,es:[di+1];

			add al,es:[di+BUFF_WIDTH];
//			shr ax,2;
//			jz jp12;
//			dec ax;
//			}
//jp12:    _asm {
//			mov dl,al;
			mov si,ax;
			mov dl,divsub[si];
			inc di;

			xor ax,ax;
			mov al,es:[di-1];

			add al,es:[di];
			add al,es:[di+1];
			add al,es:[di+BUFF_WIDTH];
//			shr ax,2;
//			jz jp12b;
//			dec ax;
//			}
//jp12b:    _asm {
//			mov dh,al;

			mov si,ax;
			mov dh,divsub[si];
			mov es:[di-BUFF_WIDTH-1],dx;
			inc di;
			loop jp11;

			popa;
		}
}
// Flame left
static void flame_leftslow(void)
{
	src=buff;
	srcseg=FP_SEG(src);
	srcoff=FP_OFF(src);
		_asm {
			pusha;

//			mov cx,64636;
			mov cx,32318;
			mov dx,srcseg;
			mov es,dx;
			mov dx,srcoff;
			mov di,BUFF_WIDTH;
			xor bx,bx;
			}
jp21:    _asm {
			xor ax,ax;
			mov al,es:[di-(BUFF_WIDTH-1)];
			mov bl,es:[di];
			add ax,bx;
			mov bl,es:[di+1];
			add ax,bx;
			mov bl,es:[di+BUFF_WIDTH];
			add ax,bx;
//			shr ax,2;
//			jz jp22;
//			dec ax;
//			}
//jp22:    _asm {
//			mov dl,al;
			mov si,ax;
			mov dl,divsub[si];
			inc di;
//			dec cx;

			xor ax,ax;
//			xor bx,bx;
			mov al,es:[di-(BUFF_WIDTH-1)];
			mov bl,es:[di];
			add ax,bx;
			mov bl,es:[di+1];
			add ax,bx;
			mov bl,es:[di+BUFF_WIDTH];
			add ax,bx;
//			shr ax,2;
//			jz jp22b;
//			dec ax;
//			}
//jp22b:    _asm {
//			mov dh,al;

			mov si,ax;
			mov dh,divsub[si];
			mov es:[di-BUFF_WIDTH-1],dx;
			inc di;
			loop jp21;

			popa;

	}
}

// Flame right
static void flame_rightslow(void)
{
	src=buff;
	srcseg=FP_SEG(src);
	srcoff=FP_OFF(src);
		_asm {
			pusha;

//			mov cx,64636;
			mov cx,32318;
			mov dx,srcseg;
			mov es,dx;
			mov dx,srcoff;
			mov di,BUFF_WIDTH+1;
			xor bx,bx;
			}
jp31:    _asm {
			xor ax,ax;
			mov al,es:[di-(BUFF_WIDTH+1)];
			mov bl,es:[di];
			add ax,bx;
			mov bl,es:[di-1];
			add ax,bx;
			mov bl,es:[di+BUFF_WIDTH];
			add ax,bx;
//			shr ax,2;
//			jz jp32;
//			dec ax;
//			}
//jp32:		_asm {
//			mov dl,al;
			mov si,ax;
			mov dl,divsub[si];
			inc di;
//			dec cx;

			xor ax,ax;
//			xor bx,bx;
			mov al,es:[di-(BUFF_WIDTH+1)];
			mov bl,es:[di];
			add ax,bx;
			mov bl,es:[di-1];
			add ax,bx;
			mov bl,es:[di+BUFF_WIDTH];
			add ax,bx;
//			shr ax,2;
//			jz jp32b;
//			dec ax;
//			}
//jp32b:		_asm {
//			mov dh,al;
			mov si,ax;
			mov dh,divsub[si];
			mov es:[di-BUFF_WIDTH-1],dx;
			inc di;
			loop jp31;

			popa;

	}
}

// Flame over water effect
static void flame_water(void)
{
	src=buff;
	srcseg=FP_SEG(src);
	srcoff=FP_OFF(src);
		_asm {
			pusha;

			mov cx,32318+BUFF_WIDTH;
			mov dx,srcseg;
			mov es,dx;
			mov dx,srcoff;
			mov di,BUFF_WIDTH;
			xor bx,bx;
			}
jp41:    _asm {
			xor ax,ax;
			mov al,es:[di-1];
			mov bl,es:[di];
			add ax,bx;
			mov bl,es:[di+1];
			add ax,bx;
			mov bl,es:[di+BUFF_WIDTH];
			add ax,bx;

//			shr ax,2;
//			jz jp42;
//			dec ax;
//		}
//jp42:    _asm {
//			mov dl,al;
			mov si,ax;
			mov dl,divsub[si];
			inc di;
			dec cx;


			xor ax,ax;
//			xor bx,bx;
			mov al,es:[di-1];
			mov bl,es:[di];
			add ax,bx;
			mov bl,es:[di+1];
			add ax,bx;
			mov bl,es:[di+BUFF_WIDTH];
			add ax,bx;

//			shr ax,2;
//			jz jp42b;
//			dec ax;
//		}
//jp42b:    _asm {
//			mov dh,al;
			mov si,ax;
			mov dh,divsub[si];

			mov es:[di-BUFF_WIDTH-1],dx;
			inc di;
			loop jp41;

			popa;
		}
		_asm {
			pusha;

			mov cx,32318;
			mov dx,srcseg;
			mov es,dx;
			mov dx,srcoff;
//			mov di,64636;
			mov di,64320-1;
			xor bx,bx;
			}

jpz41:   _asm {
			xor ax,ax;
			mov al,es:[di-(BUFF_WIDTH-1)];
			mov bl,es:[di];
			add ax,bx;
			mov bl,es:[di+1];
			add ax,bx;
			mov bl,es:[di-BUFF_WIDTH];
			add ax,bx;
			shr ax,2;

			mov dh,al;
			dec di;
			dec cx;

			xor ax,ax;
//			xor bx,bx;
			mov al,es:[di-(BUFF_WIDTH-1)];
			mov bl,es:[di];
			add ax,bx;
			mov bl,es:[di+1];
			add ax,bx;
			mov bl,es:[di-BUFF_WIDTH];
			add ax,bx;
			shr ax,2;

			mov dl,al;

			mov es:[di+BUFF_WIDTH],dx;
			dec di;
			loop jpz41;

			popa;
	}
}



static void flame_skyline(void)
{
	src=buff;
	srcseg=FP_SEG(src);
	srcoff=FP_OFF(src);
		_asm {
			pusha;
			EVEN;

//			mov cx,64636;
			mov cx,32318;
			mov dx,srcseg;
			mov es,dx;
			mov dx,srcoff;
			mov di,BUFF_WIDTH;
			xor bx,bx;
			}
jp11:    _asm {
			xor ax,ax;
			mov al,es:[di-1];
			mov bl,es:[di];
			add ax,bx;
			mov bl,es:[di+1];
			add ax,bx;
//			mov bl,es:[di+BUFF_WIDTH];
			mov bl,es:[di];
			add ax,bx;

			jz jp12;
			dec ax;

			shr ax,2;

			}
jp12:    _asm {
			mov dl,al;
			inc di;
//			dec cx;

			xor ax,ax;
//			xor bx,bx;
			mov al,es:[di-1];
			mov bl,es:[di];
			add ax,bx;
			mov bl,es:[di+1];
			add ax,bx;
//			mov bl,es:[di+BUFF_WIDTH];
			mov bl,es:[di];
			add ax,bx;

			jz jp12b;
			dec ax;

			shr ax,2;

			}
jp12b:    _asm {
			mov dh,al;

			mov es:[di-BUFF_WIDTH-1],dx;
			inc di;
			loop jp11;

			popa;

		}
}

static void flame_upfast(void)
{
	src=buff;
	srcseg=FP_SEG(src);
	srcoff=FP_OFF(src);
		_asm {
			pusha;
			EVEN;

//			mov cx,16159;
//			mov cx,64636;
			mov cx,64000+BUFF_WIDTH;
			mov dx,srcseg;
			mov es,dx;
			mov dx,srcoff;
//			mov di,BUFF_WIDTH;
			mov di,64000+BUFF_WIDTH-1;
			xor bx,bx;
			}
jp11:    _asm {
			xor ax,ax;
			mov al,es:[di];
			mov bl,es:[di+BUFF_WIDTH-1];
			add ax,bx;
			mov bl,es:[di+BUFF_WIDTH+1];
			add ax,bx;
			mov bl,es:[di+BUFF_WIDTH];
			add ax,bx;
//			shr ax,2;
//			jz jp12;
//			dec ax;
//			}
//jp12:    _asm {
//			mov dh,al;
			mov si,ax;
			mov dh,divsub[si];
			dec di;
			dec cx;

			xor ax,ax;
//			xor bx,bx;
			mov al,es:[di];
			mov bl,es:[di+BUFF_WIDTH-1];
			add ax,bx;
			mov bl,es:[di+BUFF_WIDTH+1];
			add ax,bx;
			mov bl,es:[di+BUFF_WIDTH];
			add ax,bx;
//			shr ax,2;
//			jz jp12b;
//			dec ax;
//			}
//jp12b:    _asm {
//			mov dl,al;

			mov si,ax;
			mov dl,divsub[si];
			mov es:[di],dx;
//			inc di;
			dec di;
			loop jp11;

			popa;
		}
}


static void flame_leftfast(void)
{
	src=buff;
	srcseg=FP_SEG(src);
	srcoff=FP_OFF(src);
		_asm {

			pusha;
			EVEN;

			mov cx,64000+BUFF_WIDTH;
			mov dx,srcseg;
			mov es,dx;
			mov dx,srcoff;
			mov di,64000+BUFF_WIDTH;
			xor bx,bx;
			}
jp11:    _asm {
			xor ax,ax;
			mov al,es:[di];
			mov bl,es:[di+BUFF_WIDTH+1];
			add ax,bx;
//			mov bl,es:[di+BUFF_WIDTH+1];
			add ax,bx;
			mov bl,es:[di+BUFF_WIDTH];
			add ax,bx;
//			shr ax,2;
//			jz jp12;
//			dec ax;
//			}
//jp12:    _asm {
//			mov dh,al;
			mov si,ax;
			mov dh,divsub[si];
			dec di;
			dec cx;

			xor ax,ax;
			mov al,es:[di];
			mov bl,es:[di+BUFF_WIDTH+1];
			add ax,bx;
//			mov bl,es:[di+BUFF_WIDTH+1];
			add ax,bx;
			mov bl,es:[di+BUFF_WIDTH];
			add ax,bx;
//			shr ax,2;
//			jz jp12b;
//			dec ax;
//			}
//jp12b:    _asm {
//			mov dl,al;
			mov si,ax;
			mov dl,divsub[si];

			mov es:[di],dx;
//			inc di;
			dec di;
			loop jp11;

			popa;
		}
}

// long flame (with triangle artifacts)
static void flame_rightfast(void)
{
	src=buff;
	srcseg=FP_SEG(src);
	srcoff=FP_OFF(src);
		_asm {

			pusha;
			EVEN;

//			mov cx,16159;
//			mov cx,64636;
			mov cx,64000+BUFF_WIDTH;
			mov dx,srcseg;
			mov es,dx;
			mov dx,srcoff;
//			mov di,BUFF_WIDTH;
			mov di,64000+BUFF_WIDTH;
			xor bx,bx;
			xor ax,ax;
			}
jp11:    _asm {
//			xor ax,ax;
			sub ah,ah;
			mov al,es:[di];
			mov bl,es:[di+BUFF_WIDTH-1];
			add ax,bx;
//			mov bl,es:[di+BUFF_WIDTH-1];
			add ax,bx;
			mov bl,es:[di+BUFF_WIDTH];
			add ax,bx;
//			shr ax,2;
//			jz jp12;
//			dec ax;
//			}
//jp12:    _asm {
//			mov dh,al;
			mov si,ax;
			mov dh,divsub[si];
			dec di;
			dec cx;

//			xor ax,ax;
			sub ah,ah;
			mov al,es:[di];
			mov bl,es:[di+BUFF_WIDTH-1];
			add ax,bx;
//			mov bl,es:[di+BUFF_WIDTH-1];
			add ax,bx;
			mov bl,es:[di+BUFF_WIDTH];
			add ax,bx;
//			shr ax,2;
//			jz jp12b;
//			dec ax;
//			}
//jp12b:    _asm {
//			mov dl,al;

			mov si,ax;
			mov dl,divsub[si];

			mov es:[di],dx;
//			inc di;
			dec di;
			loop jp11;

			popa;
		}
}




static void flame_leftsubtle(void)
{
	src=buff;
	srcseg=FP_SEG(src);
	srcoff=FP_OFF(src);
		_asm {
			pusha;
			EVEN;

//			mov cx,64636;
			mov cx,32318;
			mov dx,srcseg;
			mov es,dx;
			mov dx,srcoff;
			mov di,BUFF_WIDTH;
			}
jp21:    _asm {
			xor ax,ax;
			mov al,es:[di-(BUFF_WIDTH-1)];
			add al,es:[di];
			add al,es:[di+1];
			add al,es:[di+BUFF_WIDTH];
//			shr ax,2;
//			jz jp22;
//			dec ax;
//			}
//jp22:    _asm {
//			mov dl,al;
			mov si,ax;
			mov dl,divsub[si];
			inc di;

			xor ax,ax;
			mov al,es:[di-(BUFF_WIDTH-1)];
			add al,es:[di];
			add al,es:[di+1];
			add al,es:[di+BUFF_WIDTH];
//			shr ax,2;
//			jz jp22b;
//			dec ax;
//			}
//jp22b:    _asm {
//			mov dh,al;
			mov si,ax;
			mov dh,divsub[si];

			mov es:[di-BUFF_WIDTH-1],dx;
			inc di;
//			stosb;
			loop jp21;

			popa;

	}
}

// Flame right
static void flame_rightsubtle(void)
{
	src=buff;
	srcseg=FP_SEG(src);
	srcoff=FP_OFF(src);
		_asm {
			pusha;
			EVEN;

			mov cx,64636;
			mov dx,srcseg;
			mov es,dx;
			mov dx,srcoff;
			mov di,BUFF_WIDTH+1;
			}
jp31:    _asm {
			xor ax,ax;
			add al,es:[di-(BUFF_WIDTH+1)];
			add al,es:[di];
			add al,es:[di-1];
			add al,es:[di+BUFF_WIDTH];
//			shr ax,2;
//			jz jp32;
//			dec ax;
//			}
//jp32:		_asm {
//			mov dl,al;
			mov si,ax;
			mov dl,divsub[si];
			inc di;
			dec cx;

			xor ax,ax;
			add al,es:[di-(BUFF_WIDTH+1)];
			add al,es:[di];
			add al,es:[di-1];
			add al,es:[di+BUFF_WIDTH];
//			shr ax,2;
//			jz jp32b;
//			dec ax;
//			}
//jp32b:		_asm {
//			mov dh,al;
			mov si,ax;
			mov dh,divsub[si];

			mov es:[di-BUFF_WIDTH-1],dx;
			inc di;
			loop jp31;

			popa;

	}
}

// Flame over water effect
static void flame_watersubtle(void)
{
	src=buff;
	srcseg=FP_SEG(src);
	srcoff=FP_OFF(src);
		_asm {
			pusha;
			EVEN;

			mov cx,32318+BUFF_WIDTH;
			mov dx,srcseg;
			mov es,dx;
			mov dx,srcoff;
			mov di,BUFF_WIDTH;
			}
jp41:    _asm {
			xor ax,ax;
			mov al,es:[di-1];
			add al,es:[di];
			add al,es:[di+1];
			add al,es:[di+BUFF_WIDTH];
//			}
//jp42b: 	_asm {
			shr ax,2;
			jz jp42;
			dec ax;
			}
jp42:    _asm {
			mov byte ptr es:[di-BUFF_WIDTH],al;
			inc di;
			loop jp41;

			popa;
	}
		_asm {
			pusha;

			mov cx,32318;
			mov dx,srcseg;
			mov es,dx;
			mov dx,srcoff;
			mov di,64636;
			}

jpz41:   _asm {
			xor ax,ax;
			mov al,es:[di-(BUFF_WIDTH-1)];
			add al,es:[di];
			add al,es:[di+1];
			add al,es:[di-BUFF_WIDTH];
			shr ax,2;
//			jz jpz42;
//			dec ax;
//			}
//jpz42:	_asm {
			mov byte ptr es:[di+BUFF_WIDTH],al;
			dec di;
			loop jpz41;

			popa;
	}
}


static void flame_weird(void)
{
	src=buff;
	srcseg=FP_SEG(src);
	srcoff=FP_OFF(src);
		_asm {
			pusha;
			EVEN;

//			mov cx,64636;
			mov cx,32318;
			mov dx,srcseg;
			mov es,dx;
			mov dx,srcoff;
			mov di,BUFF_WIDTH;
			}
jpa11:    _asm {
			xor ax,ax;
			mov al,es:[di];
			or al,es:[di-1];
			or al,es:[di+1];
			or al,es:[di+BUFF_WIDTH];

//			shr ax,2;

			jz jpa12;
			dec ax;

			}
jpa12:    _asm {
			mov dl,al;
			inc di;
//			dec cx;

			xor ax,ax;
			mov al,es:[di];
			or al,es:[di-1];
			or al,es:[di+1];
			or al,es:[di+BUFF_WIDTH];

//			shr ax,2;

			jz jpa12b;
			dec ax;

			}
jpa12b:    _asm {
			mov dh,al;

			mov es:[di-BUFF_WIDTH-1],dx;
			inc di;
			loop jpa11;

			popa;

		}
}

static void flame_fade(void)
{
	src=buff;
	srcseg=FP_SEG(src);
	srcoff=FP_OFF(src);
		_asm {
			pusha;

//			mov cx,64636;
			mov cx,32318;
			mov dx,srcseg;
			mov es,dx;
			mov dx,srcoff;
			mov di,BUFF_WIDTH;
			xor bx,bx;
			}
jp11:    _asm {
			xor ax,ax;
			mov ax,es:[di];
			mov bl,ah;
			test bl,bl;
			jz jp11a;
			dec bl;
			mov ah,bl;
			}
jp11a:	_asm {
			test bl,bl;
			jz jp11b;
			dec bl;
			mov ah,bl;
			}
jp11b:	_asm {
			mov bl,al;

			test bl,bl;
			jz jp11c;
			dec bl;
			mov al,bl;
			}
jp11c:	_asm {
			test bl,bl;
			jz jp11d;
			dec bl;
			mov al,bl;
			}
jp11d:	_asm {

			mov es:[di],ax;
			inc di;
			inc di;
			loop jp11;

			popa;
		}
}


static void flame_zzz(void)
{
	src=buff;
	srcseg=FP_SEG(src);
	srcoff=FP_OFF(src);
		_asm {
			pusha;

			mov cx,64636;
			mov dx,srcseg;
			mov es,dx;
			mov dx,srcoff;
			mov di,BUFF_WIDTH;
			xor bx,bx;
			}
jp11:    _asm {
			xor ax,ax;
			mov al,es:[di-1];
			add al,es:[di+BUFF_WIDTH];
			shr ax,1;
			jz jp12;
			dec ax;
			}
jp12:    _asm {
			mov dl,al;
			inc di;
			dec cx;

			xor ax,ax;
//			xor bx,bx;
			mov al,es:[di-1];
			add al,es:[di+BUFF_WIDTH];
			shr ax,1;
			jz jp12b;
			dec ax;
			}
jp12b:    _asm {
			mov dh,al;

			mov es:[di-BUFF_WIDTH-1],dx;
			inc di;
			loop jp11;

			popa;
		}
}
