//
// Cthugha - Audio Seeded Image Processing
//
// Zaph, Digital Aasvogel Group, Torps Productions 1993-1995
//
// Copyright Information:
// ======================
// 
// Some parts of the source are from the public domain and are not
// copyrighted.
// 
// Some parts of the source bear explicit copyright notices from the
// author and are subject to the conditions listed there by the author.
// 
// The remainder of the source (not already public domain, no explicit
// author's copyright notice) is Copyright 1995 by Torps Productions
// (a loosely associated and ever-growing group of fanatic programmers).
//
// The source code may be copied freely and may be used in other programs
// under the following conditions:
//  It may not be used in a commercial program without prior permission.
//  Please credit the author (in general, credit Cthugha and Torps
//  Productions) as the source of the code.
// 
// This copyright notice is grafted from the Fractint copyright notice.
//
//
// Modifying the code:
// ===================
//
// Feel free to modify this source code, HOWEVER, please send any working
// changes/fixes to me (zaph@torps.apana.org.au) for inclusion in future
// versions of the code.
//
// Distributing the code:
// ======================
//
// Feel free to distribute this code, as long as it is complete and contains
// all copyright information that was included in the original.
//
// Legal Issues:
// =============
//
// What legal issues ???
//
// Come on guys, this is for *fun*, get on with it, make it great, make us
// all famous!!!
//
//												zaph, 12May94


// Please define this #define while testing, so you dont accidentally
// give out the wrong version.
// #define BETA 1

#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <math.h>
#include <conio.h>
#include <time.h>
//#include <sys\types.h>
//#include <sys\stat.h> 
#include <string.h>
#include <memory.h>


#define OLD_SDK 1

#include "sb.h"
#include "cthugha.h"
#include "cmdfiles.h"
#include "charset.h"
#include "zorilkey.h"
#include "initscrn.h"
#include "maps.h"
#include "translat.h"
#include "options.h"
#include "showp.h"
#include "hi.h"
#include "display.h"
#include "pete.h"

#include "audio.h"
#include "patch.h"

#include "mouse.h"
#include "vesa.h"

int useinifile=0;
int massageStyle=0;
int minnoise=4;
int was_quiet=0;
int time_to_change=0;
int allow_fft=1,use_fft=0;
int useVesa=1;

int stop_cd=0;
int iniline=0;

extern int pcxtime;
extern void cd_stop(void);
extern void cd_player(void);

extern char stringtable[20][21];

extern function_opt flamearray[];

#define FUNC1 03

void WriteBuff(unsigned char *buff);

unsigned char LUTbuffer[LUTSIZE];

int table[NUMTABLES][256];
int curtable=0;
int stereo[BUFF_WIDTH][2];
int curflame=0;
int curdisplay=0;
int locked=0;
int starttrack=-1;

int checkcpu=1;
int curpal=0;
int usepersonal=2;

#define MAXPCX  20

union REGS regset;

int nrpcx=0,actpcx=0;
_vmhnd_t pcxh[MAXPCX],palh=0;

unsigned char xshadow[BUFF_HEIGHT][BUFF_WIDTH];
unsigned char xbuff[BUFF_HEIGHT][BUFF_WIDTH];
unsigned char *buff=&xbuff[0][0];
unsigned char *shadow=&xshadow[0][0];

extern void fill_buff(void);
extern void flame_cro(void);
extern int optind;	/* index of which argument is next	  */
extern char *optarg;  /* pointer to argument of current option */
extern int opterr;	/* allow error message  */
extern int getopt(int argc, char *argv[], char *optionS);

extern void init_cd(int track);

static int LoadLuts( char * fn, unsigned char *pal);

int in_vol=-1;
int min_time=200;
int rand_time=750;
int quiet_change=1;
extern void draw_text(int xpos, int ypos, int size, int colour, char *tbuf);
extern void init_pete(void);
#ifdef OLD_SDK
extern int SDK_init(void);
#endif
extern int GUS_init(void);
extern int SB_init(void);

unsigned int tempBuff;
long buffer_size=0x20000L;
char far *voice_buffer;
unsigned  int voice_seg=0;
int debug_mode=0;
unsigned int sample_rate=44100;

int mouse_inst;


extern char maptabfile[255];
char stringfile[255];
char inifile[255];

//char string[255];

#define MAX_INI_SETTINGS 50

INIsettings personalINI[MAX_INI_SETTINGS];

int sound_card=UNKNOWN;

int pause=0;

void show_opts(void)
{

		gotoxy(0,23);
		printf("Cthugha: Command line options\n");
		printf("Please read Cthugha.DOC for a complete list of commands");
#if 0
		printf("(These are Case sensitive commands)\n");
		printf("  -L,-M,-C  : Use Line/Mic/CD as input\n");
		printf("  -c <num>  : Use CD as input, and start playing track <num>\n");
		printf("  -G,-S,-P  : Use GUS/SB/PAS (default: search)\n");
		printf("  -O        : Use Old SB code (for incompatible cards)\n");
		printf("  -s,-m     : Default to STEREO/MONO\n");
		printf("  -i,-e     : Disable Inbuilt/External Palettes\n");
		printf("  -T <num>  : Minimum frames before changing\n");
		printf("  -R <num>  : extra random frames before changing\n");
		printf("  -V <0-255>: Set input volume to <0-255>\n");
		printf("  -v <rate> : VU bar sample rate (Default=4000)\n");
		printf("  -Q <num>  : Number of frames before silence change <def:200>\n");

		printf("<press any key for more options>");
		_getch();
		printf("\n");

		printf("  -f <num>  : Start with flame   #<num>\n");
		printf("  -w <num>  : Start with wave    #<num>\n");
		printf("  -p <num>  : Start with palette #<num>\n\n");
		printf("  -l        : Lock to first wave/flame/palette\n");
		printf("  -d        : Pause just before running (usually for debug)\n");
		printf("  -t <fname>: Load alternate Translation table\n");
		printf("  -q <fname>: Load alternate Quiet messages\n");
//		printf("  -I <fname>: Load INI file\n");
		printf("  -B <num>  : Set beat peak level to <num>\n");
		printf("  -b <num>  : Set # of beats to <num>   (-ve to disable)\n");
		printf("  -X        : Disable PCX image files\n\n");

		printf("  -x        : Debug mode (no sound source needed)\n\n");
		printf("  -r        : Enable Video synch refresh waiting\n\n");
#endif
}

extern long memavail(void);

void title(void)
{
	regset.x.ax = 0x0003;	/* AL = 3 selects 80x25 text mode */
	_int86(0x10, &regset, &regset);

	start_screen();

	gotoxy(23,16);
	printf("%06ld",memavail());

	gotoxy(0,21);
	printf("CTHUGHA v5.3    Compiled on %s %s      ",__DATE__,__TIME__);
#ifdef BETA
	gotoxy(0,22);
	printf("Public BETA - Beware of the bugs... %c",7);
#endif

}

int use_internal_palettes=TRUE;
int use_external_palettes=TRUE;
int use_pcx_files=TRUE,pcxcount=0,pcxev=0;

void pcx_and_palettes(void)
{
	struct find_t dos_f;
//	FILE *fp;
	int i,j;
	char fname[20];

	if (use_internal_palettes) {
		for (i=0; i<numluts; i++)
			for (j=0; j<255; j++)
				LUTfiles[i][j]=LUTfiles[i][j]>>2;

		for( i=0,j=0;i < 64;i++ ) {
				LUTfiles[numluts][j++] = i;
				LUTfiles[numluts][j++] = 0;
				LUTfiles[numluts][j++] = 0;
		}
		for( i=0;i < 128;i++ ) {
				LUTfiles[numluts][j++] = 63;
				LUTfiles[numluts][j++] = 0;
				LUTfiles[numluts][j++] = i>>1;
		}
		for( i=0;i < 64;i++ ) {
				LUTfiles[numluts][j++] = 63-i;
				LUTfiles[numluts][j++] = 0;
				LUTfiles[numluts][j++] = 63;
		}
		numluts++;
	} else {
		numluts=0;
	}

	hiinit();
	if(!pinghi()){
		gotoxy(0,23);
		printf("No EMS/XMS available - Disabling PCX files and TAB files");
		use_pcx_files=0;
		nrtrans=0;
	}


	//Palette fr pcx-files
	for(i=0;i<MAXPCX;i++)
		pcxh[i]=0;

	if(use_pcx_files){
//		printf("--- PCX loading ---\n");
		pcxinit("-e0 -c");

		pcxluts=numluts;

		memcpy(LUTfiles[pcxluts],LUTfiles[pcxluts-1],3*256);
		nrpcx=0;
		palh=himalloc(MAXPCX*3*256);
		if(!palh){
			gotoxy(0,23);
			printf("No Himem for palettes - try a clean boot with himem.sys");

			exit(1);
		}
//		if (!_dos_findfirst("PCX\\*.pcx",_A_NORMAL,&dos_f)) {
		if (!_dos_findfirst("*.pcx",_A_NORMAL,&dos_f)) {
			do {
//				sprintf(fname,"PCX\\%s",dos_f.name);
				sprintf(fname,"%-12s",dos_f.name);
//				printf("\rreading PCX file %d: %s     ",nrpcx+1,fname);
				gotoxy(11,18);
				printf(fname);

				//if (putpcx(dos_f.name,buff,LUTfiles[pcxluts])==0)
				//	  i++;
				//else
				//	  printf("problem with palette file: %s\n",dos_f.name);
		
				//regset.x.ax = 0x0013; 
				//_int86(0x10, &regset, &regset);
				pcxfilebuf(fname,(unsigned char far*)buff,LUTfiles[pcxluts]);
				if( (pcxh[nrpcx]=himalloc(BUFF_SIZE))==0) {
					gotoxy(0,23);
					printf("No Himem for PCX - try a clean boot with himem.sys");
						break;
				}
				real2hi(pcxh[nrpcx],0,buff,BUFF_SIZE);
				real2hi(palh,nrpcx*3*256,LUTfiles[pcxluts],3*256);							  
				nrpcx++;
				//FillLUTBuffer(pcxluts);
				//display_up();
				//regset.x.ax = 0x0010; 
				//_int86(0x10, &regset, &regset);
			} while (!_dos_findnext(&dos_f) && nrpcx<MAXPCX);
		} else {
			gotoxy(11,18);
			printf("none found");

		}
	} else {
		nrpcx=0;
		gotoxy(11,18);
		printf("disabled");
	}

	if (nrpcx>0)
		numluts++;

	if (use_external_palettes) {
		i=numluts;

//		if (!_dos_findfirst("MAP\\*.map",_A_NORMAL,&dos_f)) {
		if (!_dos_findfirst("*.map",_A_NORMAL,&dos_f)) {
			do {
//				sprintf(fname,"MAP\\%s",dos_f.name);
				sprintf(fname,"%-12s",dos_f.name);
//				printf("\rreading %s as palette %d    ",fname,i+1);
				gotoxy(11,19);
				printf(fname);

				if (LoadLuts(fname,LUTfiles[i])==0)
					i++;
				else {
					gotoxy(0,23);
					printf("problem with palette file: %s  ",fname);
				}
			} while (!_dos_findnext(&dos_f) && i<MAXLUTS);
		} else {
			gotoxy(11,19);
			printf("None found");
		}
		
		numluts=i;
	} else {
		gotoxy(11,19);
		printf("disabled");
	}

	if (numluts<=0) {
		gotoxy(0,23);
		printf("No Palettes loaded, exiting  ");
		exit(2);
	}
}

char *nosound="No Sound source, exiting  ";
int initstuff()
{
	int i,j;
	FILE *fp;

	mouse_inst = mouse_init();
	gotoxy(11,16);
	printf("%c",(mouse_inst)?'':'X');

	if (!debug_mode) {
		switch (sound_card) {
#ifdef OLD_SDK
			case OLDSB:
				gotoxy(11,17);
				printf("OldSB?");
				if (SDK_init()) {
					gotoxy(0,23);
					printf(nosound);
					exit(1);
				}
				gotoxy(16,17);
				printf("");
				break;
#endif
			case PAS:
				gotoxy(11,17);
				printf("PAS  ?");
				if (PAS_init()) {
					gotoxy(0,23);
					printf(nosound);
					exit(1);
				}
				gotoxy(16,17);
				printf("");
				break;
			case GUS:
				gotoxy(11,17);
				printf("GUS  ?");
				if (GUS_init()) {
					gotoxy(0,23);
					printf(nosound);
					exit(1);
				}
				gotoxy(16,17);
				printf("");
				break;
			case SBPRO:
				gotoxy(11,17);
				printf("SBpro?");
				if (SB_init()) {
					gotoxy(0,23);
					printf(nosound);
					exit(1);
				}

				gotoxy(16,17);
				printf("");
				break;

			default: // Try Everything!!
				gotoxy(11,17);
				printf("GUS  ?");
				if (!GUS_init()) {
					gotoxy(16,17);
					printf("");
					break;
				}
				gotoxy(11,17);
				printf("PAS  ?");
				if (!PAS_init()) {
					gotoxy(16,17);
					printf("");
					break;
				}
				gotoxy(11,17);
				printf("SBpro?");
				if (!SB_init()) {
					gotoxy(16,17);
					printf("");
					break;
				}
#ifdef OLD_SDK
				gotoxy(11,17);
				printf("OLDSB?");
				if (!SDK_init()) {
					gotoxy(16,17);
					printf("");
					break;
				}
#endif
				gotoxy(0,23);
				printf(nosound);
				exit(1);
				break;
		}
	}


	if( in_vol > 0 ) {
		in_vol = min(in_vol,255);

		switch( device ) {
			case CDInput:		set_level(MIXcd		,in_vol); break;
			case LineInput:   set_level(MIXline	  ,in_vol); break;
			case MicInput:	set_level(MIXmicrophone,in_vol); break;
		}
	}

	if (stringfile[0]!=0) {
		if ((fp=fopen(stringfile,"r"))!=NULL) {
			i=0;
			fgets(stringfile,254,fp);
			while (!feof(fp) && i<19) {
				stringfile[strlen(stringfile)-1]=0;
				stringfile[20]=0;
				sprintf(stringtable[i],"%s",stringfile);
				i++;
				fgets(stringfile,254,fp);
			}
			fclose(fp);
			
		} else {
			printf("Unable to find string file: %s\n",stringfile);
		}
	}

	gotoxy(23,16);
	printf("%06ld",memavail());

	pcx_and_palettes();

	gotoxy(23,16);
	printf("%06ld",memavail());

	init_pete();
	init_translate();


//	for (i=0; i<BUFF_WIDTH; i++) {
//		buff[BUFF_BOTTOM+1][i]=0;
//		buff[BUFF_BOTTOM+2][i]=0;
//	}

	memset(buff+(unsigned int)(BUFF_BOTTOM+1)*BUFF_WIDTH,0,BUFF_WIDTH*2);



	for (j=0; j<NUMTABLES; j++) {
		for (i=0; i<256; i++)
			switch(j) {
				default:
				case 0:
					table[j][i]=abs(128-i)*2;
					break;
				case 1:
					table[j][i]=255-abs(128-i)*2;
					break;

				case 2:
					table[j][i]=i;
					break;

				case 3:
					table[j][i]=255-i;
					break;

				case 4:
					table[j][i]=abs(128-i)+127;
					break;

				case 5:
					table[j][i]=255-abs(128-i)+127;
					break;

				case 6:
					table[j][i]=abs(i-128)+127;
					break;

				case 7:
					if (abs(128-i)<64)
						table[j][i]=255;
					else
						table[j][i]=(abs(128-i)*4);
					break;

				case 8:
					table[j][i]=abs(128-i);
					break;

				case 9:
					table[j][i]=255-abs(128-i);
					break;
			}
	}

}

int main(int argc, char *argv[])
{
	int i,n;
	int doit=0;
	int error=0,help=0;
	int ch;
	int finished;
	long l;
	int current=0,lastmode=0;
	FILE *fp;

	int oldpal=curpal;
	int xmin,ymin,xdest,ydest,y,b,h;
	int xt[]={4,8,20,40,160};
	int yt[]={4,8,20,40,100};
//	int delx;
	int cpu=0;

	title();

	fp=fopen("cthugha.dbg","w");
	if (fp!=NULL) {
		vesaInfo vinfo;
		vesaModeInfo vminfo;

		if (getVesaInfo(&vinfo)) {
			printVesaInfo(fp,&vinfo);
			getVesaModeInfo(g640x400,&vminfo);
			printVesaModeInfo(fp,&vminfo);
			gotoxy(59,16);
			printf("");
		} else {
			gotoxy(59,16);
			printf("X");
			fprintf(fp,"No VESA modes detected\n");
			useVesa=0;
		}
		fclose(fp);
	}

	sound_card = UNKNOWN;

	if( getenv("ULTRASND") )
		 sound_card = GUS;

	sprintf(inifile,"CTHUGHA.INI");

	newwave=rand();
	change_wave(newwave);
	curflame=rand();
	change_flame(curflame);
	curdisplay=rand()%255;
	curdisplay=change_display(curdisplay);
	stringfile[0]=0;
	maptabfile[0]=0;

	cmdfiles("CTHUGHA.INI");

	while((ch = getopt(argc,argv,"?DOGPXxLlMmCeidSsrT:aQ:V:v:R:f:w:p:t:q:b:B:c:")) != EOF) {
		switch(ch) {
			case 'r':
				norefresh=FALSE;
				break;
			case 'B':
				peaklevel = atoi(optarg);
				break;
			case 'b':
				peakframes = atoi(optarg);
				break;
			case 'q':
				strcpy(stringfile,optarg);
				break;
			case 't':
				strcpy(maptabfile,optarg);
				break;
			case 'P':
				sound_card=PAS;

				break;
			case 'd':
				pause=1;
				break;
			case 'Q':
				quiet_change=atoi(optarg);
				if (quiet_change<0)
					quiet_change=0;

				break;
			case 'L':
				device=LineInput;
				break;
			case 'v':
				vu_rate = (unsigned)(atol(optarg));

				if (vu_rate<4000)
					vu_rate=0;

				break;
			case 'V':
				in_vol = atoi(optarg);
				break;
			case 'e':
				use_external_palettes=FALSE;
				break;
			case 'i':
				use_internal_palettes=FALSE;
				break;
			case 'M':
				device=MicInput;
				break;
			case 'C':
				device=CDInput;
				break;
			case 'c':
				starttrack = atoi(optarg);
				device=CDInput;
				break;
			case 'T':
				min_time = atoi(optarg);
				min_time = min(min_time,32000);
				min_time = max(min_time,0);
				break;
			case 'R':
				rand_time = atoi(optarg);
				rand_time = min(rand_time,32000);
				rand_time = max(rand_time,1);
				break;

			case 'G':
				sound_card=GUS;
				break;
			case 'S':
				sound_card=SBPRO;
				break;
			case 'O':
				sound_card=OLDSB;
				break;
			case 's':
				sample_stereo=1;
				break;
			case 'm':
				sample_stereo=0;
				break;
			default:
				gotoxy(0,23);
				printf("Unknown/bad option -%c  ",ch);
				error++;
				break;
			case '?':
				help++;
				break;
			case 'X':
				use_pcx_files=FALSE;
				break;
			case 'D':
			case 'x':
				debug_mode++;
				gotoxy(0,23);
				printf("Debug Mode (Soundcard not used) (level %d)  ",debug_mode);
				break;
			case 'f':
				curflame = atoi(optarg);
				if (curflame<0)
					curflame=0;
				break;
			case 'p':
				curpal = atoi(optarg);
				if (curpal<0)
					curpal=0;
				break;
			case 'w':
				newwave = atoi(optarg)%numwaves;
				if (newwave<0)
					newwave=0;
				break;
			case 'l':
				locked=1;
				break;
		}
	 }

	if( (error)||(help) ) {
		show_opts();
		exit(1);
	}

	if (checkcpu) {
		cpu=cpu_check();
		gotoxy(42,16);
		printf("80%d",cpu);

		if (cpu<386) {
			gotoxy(0,23);
			printf("Cthugha requires a 386 or higher to run. Aborting  ");
			exit(1);
		}
	}

	if (debug_mode>1) {
		srand(0);
	} else {
		time(&l);
		srand(l);
	}


	initstuff();


	lastmode=0;
	current=0;
	finished=0;

	gotoxy(23,16);
	printf("%06ld",memavail());

#ifdef BETA
	delay(1000);
#endif

	if (pause) {
		gotoxy(0,23);
		printf("Pausing, press any key to continue:  ");
		_getch();
	} else {
		delay(2000);
	}

	set_display_mode(useVesa);

	curpal=curpal%numluts;
	curflame=change_flame(curflame);
	change_wave(newwave);
	curdisplay=change_display(curdisplay);

	FillLUTBuffer(curpal);

	if ((usepersonal>0) && (iniline>0))
		if ((usepersonal==1) || (rand()%3)) {
			n=rand()%iniline;

			min_time=personalINI[n].min_time;
			rand_time=personalINI[n].rand_time;
			quiet_change=personalINI[n].quiet_change;
			curtable=personalINI[n].curtable;
			curflame=personalINI[n].curflame;
			curdisplay=personalINI[n].curdisplay;
			locked=personalINI[n].locked;
			minnoise=personalINI[n].minnoise;
			massageStyle=personalINI[n].massageStyle;
			allow_fft=personalINI[n].allow_fft;
			use_fft=personalINI[n].use_fft;
			peaklevel=personalINI[n].peaklevel;
			peakframes=personalINI[n].peakframes;
			newwave=personalINI[n].newwave;
			usewave=personalINI[n].usewave;
	//	extra=personalINI[n].extra;
			curpal=personalINI[n].curpal;
			sample_rate=personalINI[n].sample_rate;
			sample_stereo=personalINI[n].sample_stereo;
			translate=personalINI[n].translate;

			FillLUTBuffer(curpal%numluts);
			curflame=change_flame(curflame);
			change_wave(usewave);
			curdisplay=change_display(curdisplay);


	}

	init_cd(starttrack);

	pcxcount=rand()%5;

//	finished=1;
	while (!finished) {

		switch (current) {
			case 0:
				time_to_change=0;

	memset(buff+(BUFF_BOTTOM+1)*BUFF_WIDTH,0,BUFF_WIDTH*2);
//				for (i=0; i<BUFF_WIDTH; i++) {
//					buff[BUFF_BOTTOM+1][i]=0;
//					buff[BUFF_BOTTOM+2][i]=0;
//				}
				flame_cro();
				pcxcount--;
				if (pcxcount<=0) {
					if (nrpcx && !locked)
						pcxev=1;
					pcxcount=rand()%5;
				}
				doit=0;
				break;
			default:
			case 1:  // Change everything (In Theory)

				current=0;
				n=0;   
				if (usepersonal==1 && iniline)  // No INI lines, always random
					n=1;		 // Personal INI file, no random
				else if (usepersonal==2 && iniline) {
					n=rand()%3;  // Default INI file, plus random
				}

				if (!n) {
					time_to_change=0;
					curtable=rand()%NUMTABLES;
					FillLUTBuffer(rand()%numluts);
					curflame=change_flame(rand());
					change_wave(rand()%numwaves);
					curdisplay=rand()%numdisplays;
					curdisplay=change_display(curdisplay);
					if (nrtrans && !(rand()%5))
						translate = rand()%nrtrans;
					if ((rand()%5)==0)
						use_fft=!use_fft;
					doit=1;
				} else {
					doit=1;
					time_to_change=0;

					n=rand()%iniline;

					min_time=personalINI[n].min_time;
					rand_time=personalINI[n].rand_time;
					quiet_change=personalINI[n].quiet_change;
					curtable=personalINI[n].curtable;
					curflame=personalINI[n].curflame;
					curdisplay=personalINI[n].curdisplay;
					locked=personalINI[n].locked;
					minnoise=personalINI[n].minnoise;
					massageStyle=personalINI[n].massageStyle;
					allow_fft=personalINI[n].allow_fft;
					use_fft=personalINI[n].use_fft;
					peaklevel=personalINI[n].peaklevel;
					peakframes=personalINI[n].peakframes;
					newwave=personalINI[n].newwave;
					usewave=personalINI[n].usewave;
//					extra=personalINI[n].extra;
					curpal=personalINI[n].curpal;
					sample_rate=personalINI[n].sample_rate;
					sample_stereo=personalINI[n].sample_stereo;
					translate=personalINI[n].translate;

					FillLUTBuffer(curpal%numluts);
					curflame=change_flame(curflame);
					change_wave(usewave);
					curdisplay=change_display(curdisplay);

				}
				break;
		}

		switch (z_keypress()) {
			case Z_NOKEY:
				if (doit) {
					current=0;
					doit=0;
				} else {
					if (!locked) {
						current=rand()%NUMCOMBINATIONS+1;
					}
				}

				if(pcxev&&nrpcx){
					pcxtime=5+rand()%20;
				  current=doit=0;
				  if( rand()%2 )
						actpcx=rand()%nrpcx;
				  pcxev=rand()%2;

								  if(pcxev==0){
										xmin=rand()%(BUFF_WIDTH-50);
										ymin=rand()%(BUFF_HEIGHT-50);
										xdest=rand()%(BUFF_WIDTH-50);
										ydest=rand()%(BUFF_HEIGHT-50);
										//hi2real(buff,pcxh[actpcx],0,BUFF_SIZE);
										b=50+rand()%(BUFF_WIDTH-50);
										h=50+rand()%(BUFF_HEIGHT-50);
																
										if(xmin+b>=BUFF_WIDTH) b=BUFF_WIDTH-1-xmin;
										if(ymin+h>=BUFF_HEIGHT) h=BUFF_HEIGHT-1-ymin;
										if(xdest+b>=BUFF_WIDTH) b=BUFF_WIDTH-1-xdest;
										if(ydest+h>=BUFF_HEIGHT) h=BUFF_HEIGHT-1-ydest;
										if(b%2) b--;
										for(y=0;y<h;y++){
												hi2real((char far*)buff+(ydest+y)*BUFF_WIDTH+xdest,
														pcxh[actpcx],
														(unsigned long)(ymin+y)*BUFF_WIDTH+xmin,
														b);
										}
								  }
#if 0
								  if(pcxev==1){
										del=rand()%5;
										if(rand()%3)
											mod2=0;
										else{
												mod2=1; 
												p2=rand()%nrpcx;
										}
										delx=xt[del]/2;
										delx=2*(delx/2);
										delx1=xt[del]-delx;
										for(y=0;y<BUFF_HEIGHT;y+=yt[del]){
											if (_kbhit())
												break;
										  for(x=0;x<BUFF_WIDTH;x+=xt[del]){
											for(co=0;co<yt[del]/2;co++){
												hi2real((char far*)buff+(y+co)*BUFF_WIDTH+x,
														pcxh[actpcx],
														(unsigned long)(y+co)*BUFF_WIDTH+x,
														delx);
#if 0
												if(mod2) hi2real((char far*)buff+(y+co)*BUFF_WIDTH+x+delx,
														pcxh[p2],
														(unsigned long)(y+co)*BUFF_WIDTH+x+delx,
														delx1);
#endif
											}
											for( ;co<yt[del];co++){	 
												hi2real((char far*)buff+(y+co)*BUFF_WIDTH+x+delx,
														pcxh[actpcx],
														(unsigned long)(y+co)*BUFF_WIDTH+x+delx,
														delx1);
#if 0
												if(mod2) hi2real((char far*)buff+(y+co)*BUFF_WIDTH+x,
														pcxh[p2],
														(unsigned long)(y+co)*BUFF_WIDTH+x,
														delx);
#endif
											}
										  }
										}
								  }
#endif

								  if(pcxev==1)
									hi2real(buff,pcxh[actpcx],0,BUFF_SIZE);
								  pcxev=1;
								  hi2real(LUTfiles[pcxluts],palh,actpcx*3*256,3*256);
								  if(rand()%3){ 
										FillLUTBuffer(pcxluts);
										pcxev=0;
								  }

								  //display();
								  //if(!(rand()%2)) delay(rand()%600);
								  if(pcxev){
										if(!(rand()%3)) 
												FillLUTBuffer(pcxluts);
								   }
								  if(!pcxev){
										if(!(rand()%3)) 
												FillLUTBuffer(oldpal);
								  }
								}
				break;
			case Z_PCX:
				if (nrpcx) {
					actpcx=++actpcx%nrpcx;
					hi2real(buff,pcxh[actpcx],0,BUFF_SIZE);
					hi2real(LUTfiles[pcxluts],palh,actpcx*3*256,3*256);
					if(rand()%2)
						FillLUTBuffer(pcxluts);
					display();
					pcxtime=5+rand()%20;
//					pcxtime=5+rand()%20;
//					delay(1000);
				}
				break;
			case Z_ESC:
				finished=1;
				break;

			case Z_FFT:
				use_fft=!use_fft;
				FillLUTBuffer((curpal)%numluts);
//				allow_fft= !allow_fft;
				break;
			case Z_NOISE_DN:
				minnoise=max(minnoise-1,0);
				break;

			case Z_SAMPLE_DN:
				sample_rate -= 1000;
				break;

			case Z_NOISE_UP:
				minnoise=min(minnoise+1,127);
				break;

			case Z_SAMPLE_UP:
				sample_rate += 1000;
				break;

			case Z_STEREO:
				sample_stereo = !sample_stereo;
				sample_rate = 0;
				break;

			case Z_CD:
				if (!debug_mode)
					cd_player();
				break;

			case Z_WAVE:
				next_wave();
				break;

			case Z_FLAME:
				curflame++;
				curflame=change_flame(curflame);
				break;

			case Z_PALETTE:
				FillLUTBuffer((curpal+1)%numluts);
				break;

			case Z_TABLE:
				curtable=(curtable+1)%NUMTABLES;
				break;

			case Z_DISPLAY:
				curdisplay=(curdisplay+1)%numdisplays;
				curdisplay=change_display(curdisplay);
				break;

			case Z_OTHERKEY:
			case Z_SPACE:
				current=rand()%NUMCOMBINATIONS+1;
				break;

			case Z_NEWWAVE:
				change_wave(newwave);
				break;

			case Z_MASSAGE:
				massageStyle = (massageStyle+1)%NUMMASSAGES;
				break;

			case Z_LOCK:
				locked=(!locked);
				if (!locked)
					current=rand()%NUMCOMBINATIONS+1;
				break;

			case Z_HELP:
				regset.x.ax = 0x0003;	/* AL = 3 selects 80x25 text mode */
				_int86(0x10, &regset, &regset);

				help_screen();


				while (z_keypress()==Z_NOKEY)
					;

				set_display_mode(useVesa);

				FillLUTBuffer((curpal)%numluts);
				break;

			case Z_STATS:
				regset.x.ax = 0x0003;	/* AL = 3 selects 80x25 text mode */
				_int86(0x10, &regset, &regset);

				stats_screen();

				while (z_keypress()==Z_NOKEY)
					;

				set_display_mode(useVesa);

				FillLUTBuffer((curpal)%numluts);
				break;

			case Z_FLAMESTATS:
#ifdef BETA
				regset.x.ax = 0x0003;	/* AL = 3 selects 80x25 text mode */
				_int86(0x10, &regset, &regset);
				printf("You have pressed F9, thats my beta-test code for timing\n");
				printf("the flame and display routines so that I can speed them up...\n");
				printf("Now you have to wait while they all get timed...\n");
				printf("Timing all flames to FLAMES.DBG, please wait...\n");

				timeflames();

				printf("Done! - press a key...");

				while (z_keypress()==Z_NOKEY)
					;
				
				set_display_mode(useVesa);

				FillLUTBuffer((curpal)%numluts);
#endif
				break;

			case Z_TRANSLATE:
				if (nrtrans)
					translate = ++translate%nrtrans;
				break;

			case Z_FLAMEOPTION:
				regset.x.ax = 0x0003;	/* AL = 3 selects 80x25 text mode */
				_int86(0x10, &regset, &regset);

				flame_option();   // Play with the flame settings
				curflame=check_flame_ok(curflame);   // Pick a good flame

				while (z_keypress()!=Z_NOKEY)  // Clean keypresses up...
					;

				set_display_mode(useVesa);

				FillLUTBuffer((curpal)%numluts);
				break;

			case Z_WAVEOPTION:
				regset.x.ax = 0x0003;	/* AL = 3 selects 80x25 text mode */
				_int86(0x10, &regset, &regset);

				wave_option();   // Play with the flame settings
				usewave=check_wave_ok(usewave);   // Pick a good flame

				while (z_keypress()!=Z_NOKEY)  // Clean keypresses up...
					;

				set_display_mode(useVesa);

				FillLUTBuffer((curpal)%numluts);
				break;

			case Z_DISPOPTION:
				regset.x.ax = 0x0003;	/* AL = 3 selects 80x25 text mode */
				_int86(0x10, &regset, &regset);

				disp_option();   // Play with the flame settings
				curdisplay=check_disp_ok(curdisplay);   // Pick a good flame

				while (z_keypress()!=Z_NOKEY)  // Clean keypresses up...
					;

				set_display_mode(useVesa);

				FillLUTBuffer((curpal)%numluts);
				break;

			case Z_ADDINI:

				if ((fp=fopen(inifile,"a"))!=NULL) {
					memset(buff,0,BUFF_SIZE);

					draw_text(0,0,2,255,"Adding to inifile");
					if (iniline>=MAX_INI_SETTINGS) {
						draw_text(0,30,2,255,"Too many settings..");
					} else {

						personalINI[iniline].min_time=min_time;
						personalINI[iniline].rand_time=rand_time;
						personalINI[iniline].quiet_change=quiet_change;
						personalINI[iniline].curtable=curtable;
						personalINI[iniline].curflame=curflame;
						personalINI[iniline].curdisplay=curdisplay;
						personalINI[iniline].locked=locked;
						personalINI[iniline].minnoise=minnoise;
						personalINI[iniline].massageStyle=massageStyle;
						personalINI[iniline].allow_fft=allow_fft;
						personalINI[iniline].use_fft=use_fft;
						personalINI[iniline].peaklevel=peaklevel;
						personalINI[iniline].peakframes=peakframes;
						personalINI[iniline].newwave=newwave;
						personalINI[iniline].usewave=usewave;
						personalINI[iniline].extra=0;
						personalINI[iniline].curpal=curpal;
						personalINI[iniline].sample_rate=sample_rate;
						personalINI[iniline].sample_stereo=sample_stereo;
						personalINI[iniline].translate=translate;

						fprintf(fp,"[oldini]\n");
						fprintf(fp,"; Auto Added from Cthugha v5.3\n");
						fprintf(fp,"oldini=%d_%d_%d_%d_%d_%d_%d_%d_%d_%d_%d_%d_%d_%d_%d_%d_%d_%u_%d_%d\n\n",
						personalINI[iniline].min_time,
						personalINI[iniline].rand_time,
						personalINI[iniline].quiet_change,
						personalINI[iniline].curtable,
						personalINI[iniline].curflame,
						personalINI[iniline].curdisplay,
						personalINI[iniline].locked,
						personalINI[iniline].minnoise,
						personalINI[iniline].massageStyle,
						personalINI[iniline].allow_fft,
						personalINI[iniline].use_fft,
						personalINI[iniline].peaklevel,
						personalINI[iniline].peakframes,
						personalINI[iniline].newwave,
						personalINI[iniline].usewave,
						personalINI[iniline].extra,
						personalINI[iniline].curpal,
						personalINI[iniline].sample_rate,
						personalINI[iniline].sample_stereo,
						personalINI[iniline].translate);
						fclose(fp);

						iniline++;
					}

				} else {
					draw_text(0,0,2,255,"Cannot open INI");
				}
				display();
				delay(500);

				break;

			default:
				break;
		}
	}


	regset.x.ax = 0x0003;	/* AL = 3 selects 80x25 text mode */
	_int86(0x10, &regset, &regset);

	if (pinghi()) {
		for(i=0;i<MAXPCX;i++)
			if(pcxh[i])
				hifree(pcxh[i]);
		if(palh)
			hifree(palh);
	}

	if (!debug_mode) {
		close_audio();
		if (stop_cd)
			cd_stop();
	}

	if (pinghi())
		_vheapterm();


	show_credits();
	_getch();
	quit_screen();

	return 0;
}

void FillLUTBuffer(int pal)
{
	/* fills the buffer with 8 bit values */

	int i;
	char *p;

	if (pal>=0) {
		curpal=pal%numluts;
		memcpy(LUTbuffer,LUTfiles[curpal],768);
	}

	outp(0x3c6,0xff);

	p = LUTbuffer;
	for(i=0;i<256;i++)
	{
		outp(0x3c8,i);
		outp(0x3c9,(*p++));
		outp(0x3c9,(*p++));
		outp(0x3c9,(*p++));
	}
}

static int LoadLuts( char * fn, unsigned char *pal)
{
	FILE *f;
	int n;
	unsigned		r, g, b, index;
	char	line[160];
	char	temp[81];

	strcpy (temp,fn);
	if (strchr(temp,'.') == NULL) /* Did name have an extension? */
		strcat(temp,".map");  /* No? Then add .map */

	f = fopen( temp, "r" );
	if (f == NULL) {
		return 1;
	}
	for( index = 0; index < 256; index++ ) {
		if (fgets(line,100,f) == NULL)
			return 1;
		n=sscanf( line, "%u %u %u", &r, &g, &b );
		if (n<3)
			return 1;
		/** load global dac values **/
		pal[index*3]   = (r%256) >> 2;	 /* maps default to 8 bits */
		pal[index*3+1] = (g%256) >> 2;	 /* DAC wants 6 bits */
		pal[index*3+2] = (b%256) >> 2;
	}
	fclose( f );
	if (index==0) {
		pal[0]=pal[1]=pal[2]=0;
		index++;
	}

	while (index < 256)  { /* zap unset entries */
		pal[index*3] =  pal[(index-1)*3];
		pal[index*3+1] = pal[(index-1)*3+1];
		pal[index*3+2] = pal[(index-1)*3+2]; 
		++index;
	}
	return 0;
}


