//
// Cthugha - Audio Seeded Image Processing
//
// Zaph, Digital Aasvogel Group, Torps Productions 1993-1995



#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include <assert.h>
#include <bios.h>
#include <string.h>
#include <ctype.h>

#include "\sbpro\msc\include\sbc.h"
#include "\sbpro\msc\include\sbcvoice.h"

#include "audio.h"
#include "cthugha.h"
#include "sb.h"

extern void draw_text(int xpos, int ypos, int size, int colour, char *tbuf);

int SDKok=0;

int sample_stereo;
extern char	 far * near voice_drv ;
extern int in_vol;


unsigned SbIOaddr=0x220;
unsigned SbDMAchan=1;
extern unsigned SBirq;
extern int SBtype;

static int Sbpro_Get_Params(void);

void SDK_close(void);
int SDK_firsttime(void);
int SDK_everytime(int wait);
int SDK_get_level(int channel);
static int Sbpro_Get_Params(void);
int SDK_set_input(enum device_list device);
int SDK_set_level(int channel, int level);
int SDK_level_incr(int channel);

int SDK_init(void)
{
	Sbpro_Get_Params();

printf("\n\nGot Params....\n\n");
	ct_io_addx = SbIOaddr;
	buffer_size=2*BUFF_WIDTH+80;
//	buffer_size=0x20000L;

	if (sbc_check_card() & 4) {
		if (sbc_scan_int()) {
printf("\n\nA%x I%d D%d\n",SbIOaddr, SBirq, SbDMAchan );
			if (!ctvm_init()) {

				if (!_dos_allocmem((int)((buffer_size+15)>>4),&tempBuff)) {
					FP_SEG(voice_buffer) = tempBuff ;
					FP_OFF(voice_buffer) = 0 ;

					voice_seg=FP_SEG(voice_buffer);

				} else {
					ctvm_terminate() ;
					return -2;

				}


				SDKok=1;

				close_audio = SDK_close;
				audio_firsttime = SDK_firsttime;
				audio_everytime = SDK_everytime;

				set_input = SDK_set_input;

				get_level = SDK_get_level;
				set_level = SDK_set_level;

				level_incr = SDK_level_incr;

				return 0;

			}else {
				printf("Failed to init driver\n");
			}
		}
		return 1;
	} else {
//		printf("Sound Blaster card not found.\n") ;
		return -1;
	}
}

void SDK_close(void)
{
	if (SDKok) {
		ctvm_stop();
		_dos_freemem(FP_SEG(voice_buffer));
		ctvm_speaker(0);
		ctvm_terminate();
	}
}


int SDK_firsttime(void)
{
	set_input(device);

	ctvm_speaker(0) ;
	ctvm_input(voice_buffer,(long)(2*BUFF_WIDTH+80),sample_rate);

	last_rate = sample_rate;

	return 0;
}

int SDK_everytime(int wait)
{
	int x,y;
	static int prev=128;
	unsigned char far *sbuff ;
//	unsigned char far *sbuff2 ;
	int noisy=0,last=0;
	static int firsttime=1;
//	int ln,hn;
//	int v1,v2;

	while (ct_voice_status) {
		if (_kbhit())
			ctvm_stop() ;
	}

	sbuff=voice_buffer;
	sbuff+=6;

	last=*sbuff;
	sbuff++;
	for (x=0; x<30; x+=2) {
		//align...
		if ((*sbuff)>=prev && last<prev-1) {
			break;
		} else {
			last= *sbuff;
		}
	}

	prev=*sbuff;

	for (y=0; y<2; y++)
		for (x=0; x<BUFF_WIDTH; x++) {
			stereo[x][y]=*sbuff++;
		}

	ctvm_speaker(0) ;

	ctvm_input(voice_buffer,(long)(2*BUFF_WIDTH+80),sample_rate);

	return 1;

}

#define MASTER_VOL  0x22
#define VOC_VOL     0x04
#define LINE_VOL    0x2E
#define FM_VOL	    0x26
#define CD_VOL	    0x28
#define MIC_VOL	    0x0A
#define RECORD_SRC  0x0C

#define MIC	    0x11
#define LINE	    0x17
#define CD	    0x13

int SDK_get_level(int channel)
{
	int vol,left,right;

	switch (channel) {
		case MIXline:
    		outp(SbIOaddr+4, 0x2e);
		    vol = inp(SbIOaddr+5);

		    left = vol >> 4;
		    right = vol & 0x0f;
			break;
		case MIXmicrophone:
		    outp(SbIOaddr+4, 0x0A );
		    vol = inp(SbIOaddr+5);

		    left = vol >> 4;
		    right = vol & 0x0f;
			break;
		case MIXmaster:
    		outp(SbIOaddr+4, 0x22);
		    vol = inp(SbIOaddr+5);

		    left = vol >> 4;
		    right = vol & 0x0f;
			break;
		case MIXcd:
		    outp(SbIOaddr+4, 0x28);
		    vol = inp(SbIOaddr+5);

		    left = vol >> 4;
		    right = vol & 0x0f;
			break;
		default:
		case MIXtreble:
		case MIXbass:
			left=0;
			right=0;
			break;

	}
//	printf("(%d) R:%d L:%d\n",channel,right,left);
	return ((right+left)/2)<<4;
//	return right;
}

#if 0
{
	unsigned char data_buf[(2*BUFF_WIDTH)+80];

	int i,left,right;

	int lmin = 255, lmax = 0, rmin = 255, rmax = 0;

	if( last_rate != 1 ) {
		last_rate = 1;
		dsp_set_record(4000,sample_stereo,8,0);
	}

	if( dsp_read(data_buf) > 1 )
		return 0;

	for( i = 0; i < buffer_size; i += 2 )
	{
		lmin = data_buf[i  ] < lmin ? data_buf[i] : lmin;
		lmax = data_buf[i  ] > lmax ? data_buf[i] : lmax;

		rmin = data_buf[i+1] < rmin ? data_buf[i] : rmin;
		rmax = data_buf[i+1] > rmax ? data_buf[i] : rmax;
	}

	left  = abs(lmax-lmin);
	right = abs(rmax-rmin);

	if( (lmax==255) || (lmin==0) )
		left = 255;

	if( (rmax==255) || (rmin==0) )
		right = 255;


	return ((left+right)/2)<<4;
}
#endif

static int Sbpro_Get_Params(void)
{
    char *t, *t1, *blaster;

    /* Set arguments to reasonable values (Soundblaster defaults) */
//	SbIOaddr = 0x220;
//	SbIRQ = 7;
//	SbDMAchan = 1;
//	SBtype=2;


	if (audio_port!=0)
		SbIOaddr=audio_port;
	if (audio_irq!=0)
		SbIRQ=audio_irq;
	if (audio_dma!=0)
		SbDMAchan=audio_dma;

    /* Attempt to read environment variable */
    t = getenv("BLASTER");

    /* Is the environment variable set? */
    if(t == NULL)
		return 1;

    /* Duplicate the string so that we don't trash our environment */
    blaster = _strdup(t);

    /* Now parse the BLASTER variable */
    t = strtok(blaster," \t");
    while(t) {
		switch(toupper(t[0])) {
	    	case 'A':                               /* I/O address */
				SbIOaddr = (int)strtol(t+1,&t1,16);
				break;
	    	case 'I':                               /* Hardware IRQ */
				SbIRQ = atoi(t+1);
				break;
	    	case 'D':                               /* DMA channel */
				SbDMAchan = atoi(t+1);
				break;
	    	case 'T':                               /* Soundblaster type */
				SBtype = atoi(t+1);
				break;
	    	default:
				printf("Unknown BLASTER option %c\n",t[0]);
				break;
		}
		t = strtok(NULL," \t");
    }
    free(blaster);
    return 0;
}


int SDK_set_input(enum device_list device)
{

	switch (device) {
		case CDInput:
			writemixer(RECORD_SRC,CD);
			break;
		case MicInput:
			writemixer(RECORD_SRC,MIC);
			break;
		default:
		case LineInput:
			writemixer(RECORD_SRC,LINE);
			break;
	}
}

int SDK_set_level(int channel, int level)
{
	int temp;

	temp=(level & 0xf0) + (level>>4);

//	printf("Set(%d) %d -> %d\n",channel,level,temp);
	switch (channel) {
		case MIXline:
			writemixer(0x2e,temp);  // LINE 
			break;
		case MIXmicrophone:
			writemixer(0x0A,temp>>1);      // MIC  
			break;
		case MIXcd:
			writemixer(0x28,temp);      // CD   
			break;
		case MIXmaster:
			writemixer(0x22,temp);      // Master
			break;
	}
	return 0;
}

int SDK_level_incr(int channel)
{
	return( channel == MIXmicrophone ? 64 : 32 );
}
