//
// Cthugha - Audio Seeded Image Processing
//
// Zaph, Digital Aasvogel Group, Torps Productions 1993-1995
//


#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include <assert.h>
#include <bios.h>

#include "cthugha.h"
//#include "audio.h"
//#include "sb.h"

enum device_list { CDInput, LineInput, MicInput } device = CDInput;

extern void draw_text(int xpos, int ypos, int size, int colour, char *tbuf);

#if 0
unsigned  tempBuff;
//long	  buffer_size = 0x20000L;
//long buffer_size = (2*BUFF_WIDTH)+80;
unsigned int buffer_size = (2*BUFF_WIDTH)+80;
char	  far *voice_buffer ;
unsigned int voice_seg;
int load_drv(void);
int SBok=0;
#endif

int sample_stereo=1;
int display_flag;
int wait_flag=1;
int peaknoise=0;
int peaklevel=220;
int peakframes=16;
int peaks=0;
int audioWait=1;

extern int debug_mode;
int (*init_audio)(void)=NULL;
int (*close_audio)(void)=NULL;
int (*audio_firsttime)(void)=NULL;
int (*audio_everytime)(int wait)=NULL;

int (*get_level)(int channel)=NULL;
void (*set_level)(int channel, int level)=NULL;
int  (*level_incr)(int channel)=NULL;

void (*set_input)(enum device_list device)=NULL;

unsigned last_rate = 65535;
unsigned actual_rate;

unsigned vu_rate = 11000;

int audio_port=0;
int audio_irq=0;
int audio_dma=0;
int audio_dma16=0;

int get_stereo(void)
{
	int x,y;
	int noisy=0,last=0;
	int ln,hn;
//	int do_display = 0;
	static int prev=128;
	static int firsttime=1;
	static int v1=0, v2=0, maxdv=2;


	if( sample_rate != last_rate )
	{
		if( last_rate == 65535 )
			display_flag = 1;

//		if( !display_flag )
//			do_display = 1;

		if( sample_rate != 0 )
			last_rate = sample_rate;
		else
			sample_rate = last_rate;

		display_flag = 0;
	}

	if( sample_rate == 0 )
	{
		sample_rate = last_rate;
		last_rate = 0;
	}

	if (debug_mode) {
		stereo[0][0]=144;
		stereo[0][1]=112;
		for (x=1; x<BUFF_WIDTH; x++) {
	

			if (rand()%256 > stereo[x-1][0])
				v1+=rand()%maxdv;
			else
				v1-=rand()%maxdv;

			if (rand()%256 > stereo[x-1][1])
				v2+=rand()%maxdv;
			else
				v2-=rand()%maxdv;

			stereo[x][0]=stereo[x-1][0]+v1;
			stereo[x][1]=stereo[x-1][1]+v2;

			if (stereo[x][0]<0) {
				stereo[x][0]=0;
				v1=1;
			} else if (stereo[x][0]>255) {
				stereo[x][0]=255;
				v1=-1;
			}
			if (stereo[x][1]<0) {
				stereo[x][1]=0;
				v2=1;
			} else if (stereo[x][1]>255) {
				stereo[x][1]=255;
				v2=-1;
			}
		}
		return 1;
	}

	if (firsttime) {

		firsttime=0;
		audio_firsttime();
	}

	if (audioWait) {
		if( audio_everytime(!wait_flag)==0 )
			return -1;
	} else {
		if( audio_everytime(0)==0 )
			return -1;
	}

	wait_flag = 0;

	ln=255;
	hn=0;
	noisy=0;
	peaknoise=0;

	for (y=0; y<2; y++) {
		ln=255;
		hn=0;
		for (x=0; x<BUFF_WIDTH; x++) {
			hn=max(hn,stereo[x][y]);
			ln=min(ln,stereo[x][y]);
		}
		if ((hn-ln)>(minnoise)) 
			noisy=1;
		if (!peaknoise && peakframes>0)
			if ((hn-ln)>(peaklevel)) {
				peaknoise=1;
			}
	}

	return noisy;
}


int get_levels(int *left, int *right)
{
	unsigned last;

	int i;

	int lmin = 255, lmax = 0, rmin = 255, rmax = 0;

	last = sample_rate;

	display_flag = 1;	 // Suppress display of sample rate
	wait_flag = 1;		 // Don't wait for data


	if( vu_rate > 0 )
		sample_rate = vu_rate;

	if( get_stereo() == -1 )
	{
		sample_rate = last;
		display_flag = 1;

		return 0;
	}

	for( i = 0; i < BUFF_WIDTH; i++ )
	{
		lmin = stereo[i][0] < lmin ? stereo[i][0] : lmin;
		lmax = stereo[i][0] > lmax ? stereo[i][0] : lmax;

		rmin = stereo[i][1] < rmin ? stereo[i][1] : rmin;
		rmax = stereo[i][1] > rmax ? stereo[i][1] : rmax;
	}

	*left  = abs(lmax-lmin);
	*right = abs(rmax-rmin);

	if( (lmax==255) || (lmin==0) )
		*left = 255;

	if( (rmax==255) || (rmin==0) )
		*right = 255;

	if( !sample_stereo )
		*left = *right = max(*left,*right);

	display_flag = 1;
	sample_rate = last;

	return 1;
}

