/*
  Face INI file prep    04Mar92 moles

	###  Please remember to update   "FACE_INI.TXT"


  10Mar92 zaph  : Added more prepable things, like Station Type,
                  password, ask_date
  12Mar92 zaph  : Added Help colors
  16Apr92 zaph  : Added temp file and debug
	02Sep92 moles + error wait
	02Sep92 moles + tmp/local/net_drv spec's
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <direct.h>
#include <dos.h>
#include <conio.h>

#include "face.h"
#include "faceglob.h"

#include    <fnfunc.h>
#include    <helpdecl.h>

extern struct hx_struct hxd;

/*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ Proto */
void varval_err(char *area, char *var, char *val);

/*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ Funcs */
void general_prep(char *var, char *val, int yesno)
{
/* 	char *point,*oldpoint; */

	if (strcmp(var,"debug") == 0) {
		if (yesno < 0)
			goto badarg;
		G_debug = (yesno)?TRUE:FALSE;
		if (G_debug) {
			/* 16Apr92 zaph  : Make it look a bit better... */
			printf("\n---  Entering Debug Mode  ---\n");
			printf("Section == [general]\ndebug set to On\n");
		}
		return;
	}

	if (strcmp(var,"language_fn") == 0) {
		strncpy(G_lang_file,val,_MAX_PATH-1);
		G_lang_file[_MAX_PATH-1]=0;
		return;
	}

	if (strcmp(var,"cscape_help_fn") == 0) {
		strncpy(G_cscape_hlp_fn,val,_MAX_PATH-1);
		G_cscape_hlp_fn[_MAX_PATH-1]=0;
		return;
	}
	if (strcmp(var,"clip_help_fn") == 0) {
		strncpy(G_clip_hlp_fn,val,_MAX_PATH-1);
		G_clip_hlp_fn[_MAX_PATH-1]=0;
		return;
	}
	if (strcmp(var,"pixel_editor") == 0) {
		strncpy(G_pixel_editor,val,_MAX_PATH-1);
		G_pixel_editor[_MAX_PATH-1]=0;
		return;
	}
	if (strcmp(var,"pixel_editor_dir") == 0) {
		strncpy(G_pixel_editor_dir,val,_MAX_PATH-1);
		G_pixel_editor_dir[_MAX_PATH-1]=0;
		return;
	}

	if (strcmp(var,"ask_date") == 0) {
		if (yesno < 0)
			goto badarg;
		G_ask_date = (yesno)?TRUE:FALSE;
		return;
	}


	/* 16Apr92 zaph  : Temporary file name,  ideally should be the path,
		and the file name gets added...   ######  */

	if (strcmp(var,"temp_fn") == 0) {
		strncpy(G_temp_file,val,_MAX_PATH-1);
		G_temp_file[_MAX_PATH-1]=0;
		return;
	}

	if (strcmp(var,"station_type") == 0) {
		if (stricmp(val,"master") == 0) {
			G_station_type=MASTER;
			return;
		}
		if (stricmp(val,"slave") == 0) {
			G_station_type=SLAVE;
			return;
		}
		if (stricmp(val,"portable") == 0) {
			G_station_type=PORTABLE;
			return;
		}
		goto badarg;
	}

	if (strcmp(var,"password") == 0) {
		if (yesno < 0)
			goto badarg;
		G_password = (yesno)?TRUE:FALSE;
		return;
	}

	if (strcmp(var,"dongle_port") == 0) {
		G_dongle_port = atoi(val);
		return;
	}

	if (strcmp(var,"scroll_speed") == 0) {
		G_scroll_milli = atoi(val);

		if (G_scroll_milli <0)
			G_scroll_milli=0;

		if (G_scroll_milli >10000)
			G_scroll_milli=10000;

		return;
	}

	if (strcmp(var,"tmp_drv") == 0) {
		G_tmp_drv = val[0];
		return;
	}

	if (strcmp(var,"local_drv") == 0) {
		G_local_drv = val[0];
		return;
	}

	if (strcmp(var,"net_drv") == 0) {
		G_net_drv = val[0];
		return;
	}

	if (strcmp(var,"video_type") == 0) {
		if ((strcmp(val,"PAL") == 0) || (strcmp(val,"PAL") == 0)) {
			G_video_PAL=1;
		}
		return;
	}



badarg:
	varval_err("general",var, val);
}

void colors_prep(char *var, char *val, int yesno)
{
	/* --------------- Blinking  ---------------- */
	if (strcmp(var,"blink") == 0) {
		if (yesno < 0)
			goto badarg;
		G_blink = (yesno)?TRUE:FALSE;
		return;
	}

	/* --------------- Screen Colors  ---------------- */
	if (strcmp(var,"backscreen") == 0) {
		G_backgnd = atoi(val);
		return;
	}

	/* --------------- Help stuff ---------------- */
	if (strcmp(var,"hlp_bgnd") == 0) {
		hxd.bk_clr = atoi(val);
		return;
	}

	if (strcmp(var,"hlp_border") == 0) {
		hxd.bd_clr = atoi(val);
		return;
	}

	if (strcmp(var,"hlp_choice") == 0) {
		hxd.reg_clr = atoi(val);
		return;
	}
	if (strcmp(var,"hlp_select") == 0) {
		hxd.sel_clr = atoi(val);
		return;
	}

badarg:
	varval_err("colors",var, val);
}

void varval_err(char *area, char *var, char *val)
{
	printf("ERROR - BADINI area [%s] %s = %s\n",area, var, val);
	printf("press any key to continue\n");
	_getch();
}


