/* crypth.c */
/* Copyright 1995 Willis E. Howard, III */
/* Willis E. Howard, III  email: WEHoward@aol.com  mail: POB 1473 Elkhart, IN  46515 */

#include <stdio.h>
char *documentation[] = {
"DESCRIPTION",
"      This program will encrypt and decrypt a file based on a key.",
"      The required key format will depend on the cipher.",
"",
"OPTIONS",
"      All options are processed before any file names are processed on",
"      any line.  When command input is from a file, the input will be",
"      processed line by line.  Options that require an argument must be ",
"      separated from the argument by at least one space.  Neither input",
"      nor output may be the standard input or standard output.",
"",
"      -e        The -e option selects encryption (default).",
"",
"      -d        The -d option selects decryption.",
"",
"      -c        Display the copyright notice.",
"",
"      -o name   Option to indicate that the following file name is the",
"                output file name.  With this flag, input and output file",
"                names may contain no wildcards.  If the -o option is given,",
"                the input file will not be deleted unless the -G or -Q",
"                option is given.  If the -o option is given, only one input",
"                file name and one output file name may appear on the command",
"                line.  It is an error to give the -o option without also",
"                specifying the input and output file names. If command input",
"                is from a command file (with -f) and the -o option is used,",
"                the input and output file names must appear on the same line",
"                as the -o option.  Separate command input lines may contain",
"                separate -o option lines.  If the -o option is not given,",
"                the input file will always be deleted.  If the -o option is",
"                not given, multiple input file names may appear on the",
"                command line, and the input file names may contain MSDOS",
"                wildcards.",  
"",
"      -k \"key\"  Encryption key.  If the key contains no blanks and does",
"                not start with \"-\", the quotes are not required.  This",
"                overrides any key in the crypt key file that is read by",
"                default.  If the key is \"?\", you will be prompted to",
"                enter the key on the keyboard, and after the key is entered",
"                the screen will be cleared.  If there is no crypt key",
"                file and no key is given on the command line, you will",
"                be prompted for a key.  The name of the crypt key file",
"                is the same as this program, but with a .KEY extension.",
"                The contents of the key are described below.",
"",
"      -f name   The named file is taken as a command file and may",
"                contain options and file names to encrypt.",
"",
"      -# number If the output file name is not given with the -o",
"                option, the output file is renamed to the input name.",
"                The original file is overwritten with the number 85",
"                (character 'U') and then deleted.  If a number is given",
"                with the -# option, the deleted file is filled with",
"                that decimal number.",
"",
"      -q        This option selects a quick delete of the input",
"                file when the -o option has not been given.  The",
"                quick delete writes 85's (U) to the file.  If a number",
"                is defined with the # option, that number is used",
"                in place of the 85's.  If the -o option has been",
"                given, using this -q option will not cause the input",
"                file to be deleted.  This is the default.",
"",
"      -Q        This option selects a quick delete of the input",
"                file whether or not the -o option was given.",
"",
"      -g        This option selects the U.S.Government slow delete",
"                of the input file when the -o option has not been",
"                given.  It deletes the file according to DOD 5220.22M",
"                where the input file is overwritten with ones, zeroes,",
"                ones, zeroes, ones, zeroes, and then decimal 85.  If ",
"                a number is defined with the # option, that number is ",
"                used in place of the 85.  If the -o option has been",
"                given, using this -g option will not cause the input",
"                file to be deleted.",
"",
"      -G        This option selects the U.S.Government slow delete",
"                of the input file per DOD 5220.22M whether or not the",
"                -o option was given.",
"",
"      -?        Give help on the program and cipher.  This must",
"                be the only argument on the command line.",
NULL } ;

