/* File: codrle1.c
   Author: David Bourgin
   Creation date: 28/1/94
   Last update: 22/5/94
   Purpose: Example of RLE type 1 encoding with a file source to compress.
*/

#include <stdio.h>
/* For routines printf,fgetc,fputc and fwrite */
#include <stdlib.h>
/* For routine exit */

/* Error codes sent to the caller */
#define NO_ERROR      0
#define BAD_FILE_NAME 1
#define BAD_ARGUMENT  2

/* Useful constants */
#define FALSE 0
#define TRUE  1

/* Global variables */
FILE *source_file,*dest_file;

                             /* Being that fgetc=EOF only after an access
                                then 'byte_stored_status' is 'TRUE' if a byte has been stored by 'fgetc'
                                or 'FALSE' if there's no valid byte not already read and not handled in 'val_byte_stored' */
int byte_stored_status=FALSE;
int val_byte_stored;

/* Pseudo procedures */
#define end_of_data()  (byte_stored_status?FALSE:!(byte_stored_status=((val_byte_stored=fgetc(source_file))!=EOF)))
#define read_byte()  (byte_stored_status?byte_stored_status=FALSE,(unsigned char)val_byte_stored:(unsigned char)fgetc(source_file))
#define write_byte(byte)  ((void)fputc((byte),dest_file))
#define write_array(array,byte_nb_to_write)  ((void)fwrite((array),1,(byte_nb_to_write),dest_file))

void rle1encoding()
/* Returned parameters: None
   Action: Compresses with RLE type 1 method all bytes read by the function 'read_byte'
   Errors: An input/output error could disturb the running of the program
*/
{ register unsigned char byte1,byte2,frame_size,
                         array[129];

  if (!end_of_data())
     { byte1=read_byte();    /* Is there at least a byte to analyze? */
       frame_size=1;
       if (!end_of_data())
                             /* Are there at least two bytes to analyze? */
          { byte2=read_byte();
            frame_size=2;
            do { if (byte1==byte2)
                             /* Is there a repetition? */
                    { while ((!end_of_data())&&(byte1==byte2)&&(frame_size<129))
                            { byte2=read_byte();
                              frame_size++;
                            }
                      if (byte1==byte2)
                             /* Do we meet only a sequence of bytes? */
                        { write_byte(126+frame_size);
                          write_byte(byte1);
                          if (!end_of_data())
                             { byte1=read_byte();
                               frame_size=1;
                             }
                          else frame_size=0;
                        }
                      else   /* No, then don't handle the last byte */
                           { write_byte(125+frame_size);
                             write_byte(byte1);
                             byte1=byte2;
                             frame_size=1;
                           }
                      if (!end_of_data())
                         { byte2=read_byte();
                           frame_size=2;
                         }
                    }
                 else        /* Prepare the array of comparisons
                                where will be stored all the identical bytes */
                      { *array = byte1;
                        array[1]=byte2;
                        while ((!end_of_data())&&(array[frame_size-2]!=array[frame_size-1])&&(frame_size<128))
                              { array[frame_size]=read_byte();
                                frame_size++;
                              }
                        if (array[frame_size-2]==array[frame_size-1])
                             /* Do we meet a sequence of all different bytes followed by identical byte? */
                           { /* Yes, then don't count the two last bytes */
                             write_byte(frame_size-3);
                             write_array(array,frame_size-2);
                             byte1=array[frame_size-2];
                             byte2=byte1;
                             frame_size=2;
                           }
                        else { write_byte(frame_size-1);
                               write_array(array,frame_size);
                               if (end_of_data())
                                  frame_size=0;
                               else { byte1=read_byte();
                                      if (end_of_data())
                                         frame_size=1;
                                      else { byte2=read_byte();
                                             frame_size=2;
                                           }
                                    }
                             }
                      }
               }
            while ((!end_of_data())||(frame_size>=2));
          }
       if (frame_size==1)
          { write_byte(0);
            write_byte(byte1);
          }
     }
}

void help()
/* Returned parameters: None
   Action: Displays the help of the program and then stops its running
   Errors: None
*/
{ printf("This utility enables you to compress a file by using RLE type 1 method\n");
  printf("as given in 'La Video et Les Imprimantes sur PC'\n");
  printf("\nUse: codrle1 source target\n");
  printf("source: Name of the file to compress\n");
  printf("target: Name of the compressed file\n");
}

int main(argc,argv)
/* Returned parameters: Returns an error code (0=None)
   Action: Main procedure
   Errors: Detected, handled and an error code is returned, if any
*/
int argc;
char *argv[];
{ if (argc!=3)
     { help();
       exit(BAD_ARGUMENT);
     }
  else if ((source_file=fopen(argv[1],"rb"))==NULL)
          { help();
            exit(BAD_FILE_NAME);
          }
       else if ((dest_file=fopen(argv[2],"wb"))==NULL)
               { help();
                 exit(BAD_FILE_NAME);
               }
            else { rle1encoding();
                   fclose(source_file);
                   fclose(dest_file);
                 }
  printf("Execution of codrle1 completed.\n");
  return (NO_ERROR);
}
