/* Fichier: dcodrle4.c
   Auteur: David Bourgin
   Date de creation: 1/2/94
   Date de derniere mise a jour: 22/5/94
   Dessein: Exemple de decodage RLE type 4 avec comme donnees a decompresser le contenu d'un fichier.
*/

#include <stdio.h>
/* Pour les routines printf,fgetc,fread et fwrite */
#include <memory.h>
/* Pour les routines memset,memcpy */
#include <stdlib.h>
/* Pour la routine exit */

/* Codes d'erreur renvoyes a l'appelant */
#define NO_ERROR      0
#define BAD_FILE_NAME 1
#define BAD_ARGUMENT  2

/* Constantes pratiques */
#define FALSE 0
#define TRUE  1

/* Variables globales */
FILE *f_source,*f_dest;

                             /* Puisque fgetc=EOF uniquement apres un acces
                                alors statut_octet_stocke vaut TRUE si un octet a ete engrange par fgetc
                                ou FALSE s'il n'y aucun octet valide, deja lu et non traite dans val_octet_stocke */
int statut_octet_stocke=FALSE;
int val_octet_stocke;

/* Pseudo procedures */
#define fin_des_donnees() (statut_octet_stocke?FALSE:!(statut_octet_stocke=((val_octet_stocke=fgetc(f_source))!=EOF)))
#define lire_octet()  (statut_octet_stocke?statut_octet_stocke=FALSE,(unsigned char)val_octet_stocke:(unsigned char)fgetc(f_source))
#define lire_tableau(tableau,nb_a_lire)  { if (statut_octet_stocke)\
                                              { *(tableau)=(unsigned char)val_octet_stocke;\
                                                statut_octet_stocke=FALSE;\
                                                if ((nb_a_lire)>1)\
                                                   (void)fread(&((tableau)[1]),1,(nb_a_lire)-1,f_source);\
                                              }\
                                           else (void)fread((tableau),1,(nb_a_lire),f_source);\
                                         }
#define ecrire_tableau(tableau,taille_tableau)  ((void)fwrite((tableau),1,(taille_tableau),f_dest))
#define remplir_tableau(tableau,nb_a_remplir,valeur)  ((void)memset((tableau),(valeur),(nb_a_remplir)))
#define recopier_bloc(source,destination,taille_source,nb_fois)  { register unsigned int i, index=0;\
                                                                   for (i=1;i<=(nb_fois);i++)\
                                                                   { (void)memcpy(&((destination)[index]),(source),(taille_source));\
                                                                     index += (taille_source);\
                                                                   }\
                                                                 }

void decodagerle4()
/* Parametres en sortie: Aucun
   Action: Decompresse suivant la methode RLE type 4 tous les octets lus par la fonction lire_octet
   Erreurs: Une erreur d'entree/sortie peut perturber le deroulement de l'algorithme
*/
{ unsigned char octet_code;
  unsigned int taille_trame,nb_trames;
  unsigned char trame[16705];

  while (!fin_des_donnees())
        { octet_code=lire_octet();
          switch (octet_code & 192)
          { case 0:          /* Repetition de trames de 1 octet
                                Codage [00xxxxxx|1 octet] */
                   taille_trame=(octet_code & 63)+2;
                   remplir_tableau(trame,taille_trame,lire_octet());
                   break;
            case 64:         /* Repetition de trames d'au moins 66 octets
                                Codage [01xxxxxx|xxxxxxxx|1 octet] */
                    taille_trame=(((unsigned int)(octet_code & 63)) << 8)+lire_octet()+66;
                    remplir_tableau(trame,taille_trame,lire_octet());
                    break;
            case 128:        /* Trame a plusieurs octets
                                Codage [10xxxxxx|yyyyyyyy|n octets] */
                     taille_trame=(octet_code & 63)+2;
                     nb_trames=((unsigned int)lire_octet())+2;
                     lire_tableau(trame,taille_trame);
                     recopier_bloc(trame,trame+taille_trame,taille_trame,nb_trames);
                     taille_trame *= nb_trames;
                     break;
            case 192:        /* Non repetition
                                Codage [110xxxxxx|n octets] ou [111xxxxxx|yyyyyyyy|n octets] */
                     taille_trame=octet_code & 31;
                     if (!(octet_code & 32))
                             /* Non repetition de moins de 33 octets [110xxxxxx|n octets] ? */
                        taille_trame++;
                     else taille_trame=((taille_trame << 8)|lire_octet())+33;
                     lire_tableau(trame,taille_trame);
                     break;
          }
          ecrire_tableau(trame,taille_trame);
        }
}

void aide()
/* Parametres en sortie: Aucun
   Action: Affiche l'aide du programme et termine son execution
   Erreurs: Aucune
*/
{ printf("Cet utilitaire permet de decompresser un fichier par la methode RLE type 4\n");
  printf("telle qu'elle est exposee dans 'La Video et Les Imprimantes sur PC'\n");
  printf("\nUsage: dcodrle4 source destination\n");
  printf("source: Nom du fichier a decompresser\n");
  printf("destination: Nom du fichier decompresse\n");
}

int main(argc,argv)
/* Parametres en sortie: Renvoie un code d'erreur (0=Aucune)
   Action: Procedure principale
   Erreurs: Detectee, traitee et un code d'erreur est renvoye si necessaire
*/
int argc;
char *argv[];
{ if (argc!=3)
     { aide();
       exit(BAD_ARGUMENT);
     }
  else if ((f_source=fopen(argv[1],"rb"))==NULL)
          { aide();
            exit(BAD_FILE_NAME);
          }
       else if ((f_dest=fopen(argv[2],"wb"))==NULL)
               { aide();
                 exit(BAD_FILE_NAME);
               }
            else { decodagerle4();
                   fclose(f_source);
                   fclose(f_dest);
                 }
  printf("Execution de dcodrle4 achevee.\n");
  return (NO_ERROR);
}
