/* File: dcodrle3.c
   Author: David Bourgin
   Creation date: 1/2/94
   Last update: 22/5/94
   Purpose: Example of RLE type 3 decoding with a file source to decompress.
*/

#include <stdio.h>
/* For routines printf,fgetc,fputc and fread */
#include <stdlib.h>
/* For routine exit */

/* Error codes sent to the caller */
#define NO_ERROR      0
#define BAD_FILE_NAME 1
#define BAD_ARGUMENT  2

/* Useful constants */
#define FALSE 0
#define TRUE  1

/* Global variables */
FILE *f_source,*f_dest;

                             /* Being that fgetc=EOF only after an access
                                then 'byte_stored_status' is 'TRUE' if a byte has been stored by 'fgetc'
                                or 'FALSE' if there's no valid byte not already read and not handled in 'val_byte_stored' */
int byte_stored_status=FALSE;
int val_byte_stored;

/* Pseudo procedures */
#define end_of_data()  (byte_stored_status?FALSE:!(byte_stored_status=((val_byte_stored=fgetc(f_source))!=EOF)))
#define read_byte()  (byte_stored_status?byte_stored_status=FALSE,(unsigned char)val_byte_stored:(unsigned char)fgetc(f_source))
#define read_array(tableau,nb_a_lire)  ((void)fread((tableau),1,(nb_a_lire),f_source))
#define write_byte(octet)  ((void)fputc((octet),f_dest))
#define write_array(tableau,nb_octets_a_ecrire)  ((void)fwrite((tableau),1,(nb_octets_a_ecrire),f_dest))

void rle3decoding()
/* Returned parameters: None
   Action: Decompresses with RLE type 3 method all bytes read by the function read_byte
   Erreurs: An input/output error could disturb the running of the program
*/
{ unsigned char header_byte,byte_read,nb_repetitions,
                raster[256];
  register unsigned int frame_length,
                        i;

  if (!end_of_data())
     { header_byte=read_byte();
       do {                  /* Being that header byte is present, then there are bytes to decompress */
            byte_read=read_byte();
            if (byte_read==header_byte)
                             /* Encoding of a repetition of the header byte */
               { nb_repetitions=read_byte();
                 frame_length=((unsigned int)read_byte())+1;
                 if (!nb_repetitions)
                    for (i=1;i<=frame_length;i++)
                        write_byte(header_byte);
                 else { read_array(raster,frame_length);
                        for (i=0;i<=nb_repetitions;i++)
                            write_array(raster,frame_length);
                      }
               }
            else write_byte(byte_read);
          }
       while (!end_of_data());
     }
}

void help()
/* Returned parameters: None
   Action: Displays the help of the program and the stop its running
   Erreurs: None
*/
{ printf("This utility enables you to decompress a file by using RLE type 3 method\n");
  printf("as given in 'La Video et Les Imprimantes sur PC'\n");
  printf("\nUse: dcodrle3 source target\n");
  printf("source: Name of the file to decompress\n");
  printf("target: Name of the restored file\n");
}

int main(argc,argv)
/* Returned parameters: Returns an error code (0=None)
   Action: Main procedure
   Erreurs: Detected, handled and an error code is returned, if any
*/
int argc;
char *argv[];
{ if (argc!=3)
     { help();
       exit(BAD_ARGUMENT);
     }
  else if ((f_source=fopen(argv[1],"rb"))==NULL)
          { help();
            exit(BAD_FILE_NAME);
          }
       else if ((f_dest=fopen(argv[2],"wb"))==NULL)
               { help();
                 exit(BAD_FILE_NAME);
               }
            else { rle3decoding();
                   fclose(f_source);
                   fclose(f_dest);
                 }
  printf("Execution of dcodrle3 completed.\n");
  return (NO_ERROR);
}
