// BMSCALER.CPP
//
// last modified: May 20, 1994, 8:14pm
//
// coded by Tumblin / Bodies In Motion
//
//

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include "xlib_all.h"

#include "bitmap.h"
#include "palette.h"

#define SOURCE_WIDTH 79
#define SOURCE_HEIGHT 69
#define CNTR_X 160
#define CNTR_Y 120


// Oh, set the tabs in your editor to 2 so it will look like mine.

//=================== Stuff for this demo program ========================

// function prototypes
int main(void);
void bmscaler(int top_left_x, int top_left_y,
							int bottom_right_x, int bottom_right_y,
							int source_width, int source_height,
							int page_offset, char * bitmap);

// main program
int main(void)
{
	int count;
	x_text_mode();
	printf("\n\n\n\n\n\n\n");
	printf("                              BITMAP SCALING\n\n");
	printf("                       by Tumblin / Bodies In Motion\n\n\n");
	printf("          Press any key to see a scaling bitmap of your's truly :-)\n");
	printf("                        Press any key again to end.\n\n");
	getch();
	x_set_mode(X_MODE_320x240,320);
	x_set_doublebuffer(240);
	x_put_pal_raw(palette,64,0);
	do
	{
		for(count=0;count <50; count++)
		{
			x_rect_fill(CNTR_X-51,CNTR_Y-51,CNTR_X+51,CNTR_Y+51,HiddenPageOffs,0);
			bmscaler(CNTR_X-count,CNTR_Y-count,CNTR_X+count,CNTR_Y+count,
							 SOURCE_WIDTH,SOURCE_HEIGHT,HiddenPageOffs,bitmap);
			x_page_flip(0,0);
			if(kbhit()) break;
		}
		for(count=50;count >=0; count--)
		{
			x_rect_fill(CNTR_X-51,CNTR_Y-51,CNTR_X+51,CNTR_Y+51,HiddenPageOffs,0);
			bmscaler(CNTR_X-count,CNTR_Y-count,CNTR_X+count,CNTR_Y+count,
							 SOURCE_WIDTH,SOURCE_HEIGHT,HiddenPageOffs,bitmap);
			x_page_flip(0,0);
			if(kbhit()) break;
		}
	} while(!kbhit());
	getch();
	x_text_mode();
	printf("Thank you for taking a look at this source code.\n\n");
	printf("Here's how you can contact me:\n\n");
	printf("mail:     Terry Sznober (a.k.a. Tumblin / Bodies In Motion)\n");
	printf("          193 Churchill Blvd. Apt.4\n");
	printf("          Saint John, New Brunswick\n");
	printf("          Canada\n");
	printf("          E2K 3E2\n\n");
	printf("Internet: m9cl@acad1.unbsj.ca\n");
	printf("          m9cl@unbsj.ca\n");
	printf("          m9cl@unb.ca\n\n");
	printf("Phone:    (506) 652-3516\n\n");
	printf("Greetings go to:\n");
	printf("Psi Gore Pixel Skaven & Purple Motion / Future Crew\n");
	printf("Fear / Mental Design, Pelusa & Necros / Psychic Monks\n");
	printf("Lord Logics, Vogue Mr.H & Lizardking / Trition,\n");
	printf("Themie Gouthas, Chris & Barry Egerter, and Ronski.\n");
	return(0);
}


//======================== Bitmap Scaling Code =============================

void bmscaler(int top_left_x, int top_left_y,
							int bottom_right_x, int bottom_right_y,
							int source_width, int source_height,
							int page_offset, char * bitmap)
{
	// declare local variables
	int color,error_term_x,error_term_y,source_x,source_y,screen_x,screen_y;
	int destination_width,destination_height;

	// initialize local variables
	source_x=0;
	source_y=0;
	error_term_x=0;
	error_term_y=0;
	screen_x=top_left_x;	// starting x coordinate to draw
	screen_y=top_left_y;	// starting y coordinate to draw
	destination_width=bottom_right_x-top_left_x;
	destination_height=bottom_right_y-top_left_y;

	// here we go, into the scaling stuff.  Pick which case we have and do it

	//---------------------------------------------------------
	// case #1: fatter and taller destination bitmap
	if((destination_width  > source_width) &&
		 (destination_height > source_height))
	{
		do	// destination fatter (x-axis) than source bitmap
		{
			error_term_x+=source_width;
			if(error_term_x > destination_width)
			{
				error_term_x-=destination_width;
				source_x++;
			}
			screen_x++;
			screen_y=top_left_y;
			source_y=0;
			do	// destination taller (y-axis) than source bitmap
			{
				color=bitmap[source_y*source_width+source_x];
				x_put_pix(screen_x,screen_y,page_offset,color);
				error_term_y+=source_height;
				if(error_term_y > destination_height)
				{
					error_term_y-=destination_height;
					source_y++;
				}
				screen_y++;
			} while(screen_y < (bottom_right_y));
		} while(screen_x < (bottom_right_x));
	}
	else
	//---------------------------------------------------------
	// case #2: fatter and shorter destination bitmap
	if((destination_width > source_width) &&
		 (destination_height < source_height))
	{
		do	// destination fatter (x-axis) than source bitmap
		{
			error_term_x+=source_width;
			if(error_term_x > destination_width)
			{
				error_term_x-=destination_width;
				source_x++;
			}
			screen_x++;
			screen_y=top_left_y;
			source_y=0;
			do	// destination shorter (y-axis) than source bitmap
			{
				color=bitmap[source_y*source_width+source_x];
				x_put_pix(screen_x,screen_y,page_offset,color);
				error_term_y+=destination_height;
				if(error_term_y > source_height)
				{
					error_term_y-=source_height;
					screen_y++;
				}
				source_y++;
			} while(screen_y < (bottom_right_y));
		} while(screen_x < (bottom_right_x));
	}
	//---------------------------------------------------------
	// case #3: skinnier and taller destination bitmap
	if((destination_width < source_width) &&
		 (destination_height > source_height))
	{
		do	// destination skinnier (x-axis) than source bitmap
		{
			error_term_x+=destination_width;
			if(error_term_x > source_width)
			{
				error_term_x-=source_width;
				screen_x++;
			}
			source_x++;
			screen_y=top_left_y;
			source_y=0;
			do	// destination taller (y-axis) than source bitmap
			{
				color=bitmap[source_y*source_width+source_x];
				x_put_pix(screen_x,screen_y,page_offset,color);
				error_term_y+=source_height;
				if(error_term_y > destination_height)
				{
					error_term_y-=destination_height;
					source_y++;
				}
				screen_y++;
			} while(screen_y < (bottom_right_y));
		} while(screen_x < (bottom_right_x-2));
	}
	//---------------------------------------------------------
	// case#4: skinnier and shorter destination bitmap
	if((destination_width <= source_width) &&
		 (destination_height <= source_height))
	{
		do	// destination skinnier (x-axis) than source bitmap
		{
			error_term_x+=destination_width;
			if(error_term_x > source_width)
			{
				error_term_x-=source_width;
				screen_x++;
			}
			source_x++;
			screen_y=top_left_y;
			source_y=0;
			do	// destination shorter (y-axis) than source bitmap
			{
				color=bitmap[source_y*source_width+source_x];
				x_put_pix(screen_x,screen_y,page_offset,color);
				error_term_y+=destination_height;
				if(error_term_y > source_height)
				{
					error_term_y-=source_height;
					screen_y++;
				}
				source_y++;
			} while(screen_y < (bottom_right_y));
		} while(screen_x < (bottom_right_x-2));
	}
	//---------------------------------------------------------
	// end of the four cases
}
