/*==========================================================================
 *
 *  !BEST003.C                                       Tuesday, April 12, 1994
 *
 *  640x480x16 graphics mode windows routines
 *  supplementary source file 3 for The BESTLibrary
 *
 *  Authored independently by George Vanous
 *
 *==========================================================================*/


/* ------------------------------------------------------------------------ */
/* ----------------------------  INCLUDE FILES  --------------------------- */

#include <alloc.h>
#include <stdlib.h>
#include <graphics.h>
#include "!bestlib.h"                  // include !BESTLIB.H in compilation

/* ------------------------------------------------------------------------ */
/* -------------------------  GLOBAL DEFINITIONS  ------------------------- */

extern mousedata msdata;
extern asciiscan key;
extern char *textstring;

/* ------------------------------------------------------------------------ */


/*----------------------------------------------------------------------------
 * Pop up a column in 640x480x16 graphics mode.
 *
 * [see !BESTLIB.DOC for a description of each parameter]
 * [see !BESTLIB.DOC for a description of the return values]
 */
int _16_popupcolumn(int x, int y, int choice, int maxmenus, char *ptr[], int ms)
{
  #define MAXDATA 20	                  // maximum number of menu options
  #define BORDERTHICKNESS 3            // thickness of border in pixels
  #define BORDERCOLOR YELLOW           // color of surrounding border
  #define INNERXSPACE 3                // space between left border and text
  #define INNERYSPACE 2                // space between top border and text
  #define INTERSPACE 33                // space between horizontal submenus
  #define INNERCOLOR BLUE              // inner color of menu
  #define FILLSTYLE 1                  // fill pattern of inner menu
  #define TEXTCOLOR YELLOW             // color of text
  #define INACTIVECOLOR LIGHTRED       // color of inactive text
  #define BARCOLOR WHITE               // color of choosebar
  int barx, bary,
      barlength,
      flength, fheight,
      textx, texty,
      height = 0, length = 0;
  imagedata *menubg;
  register int i, ii;

  choice--;
  for (i = 0; i < maxmenus; i++) {
    if (textwidth(ptr[i]) > length) length = textwidth(ptr[i]);
    if (textheight(ptr[i]) > height) height = textheight(ptr[i]);
  }
  height++;
  fheight = height * maxmenus + BORDERTHICKNESS * 2 + INNERYSPACE * 2,
  flength = length + BORDERTHICKNESS * 2 + INNERXSPACE * 2;
  if ((menubg = (void *) malloc(_16_i_need(flength, fheight))) == NULL)
    return(-1);                        // return code for error
  _16_i_save(x, y, flength, fheight, menubg, FALSE, TRUE);
  for (i = 0; i < BORDERTHICKNESS; i++)
    _16_boxoutline(x + i, y + i, flength - i - i, fheight - i - i, BORDERCOLOR, COPY_IMAGE);

  _16_boxfill(x + i, y + i, flength - i - i, fheight - i - i, BLACK, COPY_IMAGE);
  textx = x + BORDERTHICKNESS + INNERXSPACE,
  texty = y + BORDERTHICKNESS + INNERYSPACE;
  setfillstyle(FILLSTYLE, INNERCOLOR);
  floodfill(textx, texty, BORDERCOLOR);
  setcolor(TEXTCOLOR);
  for (ii = texty - 1, i = 0; i < maxmenus; ii += height, i++)
    outtextxy(textx, ii, ptr[i]);
  barlength = length + INNERXSPACE * 2,
  fheight -= BORDERTHICKNESS,
  barx = textx - INNERXSPACE,
  bary = texty + choice * height;

  if (ms) {
    msdata.pos[0] = msdata.npos[0] = MAXX / 2,
    msdata.pos[1] = msdata.npos[1] = MAXY / 2;
    ms_set(msdata.pos[0], msdata.pos[1]);
  }
 while (TRUE)
 {
   _16_boxfill(barx, bary, barlength, height, BARCOLOR, XOR_IMAGE);
   key.ascii = key.scan = 0;
   if (ms) while (TRUE) {
     if (keyhit()) {
       getchr();
       break;
     }
     ms_stat();
     if (msdata.buts[0] != msdata.nbuts[0]) {
       msdata.buts[0] = msdata.nbuts[0];
       if (!msdata.nbuts[0]) { key.ascii = 13; break; }
     }
     if (msdata.buts[1] != msdata.nbuts[1]) {
       msdata.buts[1] = msdata.nbuts[1];
       if (!msdata.nbuts[1]) { key.ascii = 27; break; }
     }
     if (abs(length = msdata.npos[0] - msdata.pos[0]) > 40) {
       if (length > 0) key.scan = 'M';
       else key.scan = 'K';
       msdata.pos[0] = msdata.npos[0] = MAXX / 2,
       msdata.pos[1] = msdata.npos[1] = MAXY / 2;
       ms_set(msdata.pos[0], msdata.pos[1]);
       break;
     }
     if (abs(length = msdata.npos[1] - msdata.pos[1]) > 10) {
       if (length > 0) key.scan = 'P';
       else key.scan = 'H';
       msdata.pos[0] = msdata.npos[0] = MAXX / 2,
       msdata.pos[1] = msdata.npos[1] = MAXY / 2;
       ms_set(msdata.pos[0], msdata.pos[1]);
       break;
     }
   }
   else
     getchr();
   _16_boxfill(barx, bary, barlength, height, BARCOLOR, XOR_IMAGE);
   if (key.ascii == 9 || key.ascii == 13 || key.ascii == 27) {
     if (key.ascii == 9 || key.ascii == 27) choice = -1;
     break;
   }                                   // 'H' = 1, 'P' = 4
   if (key.scan == 'H') {
     if (--choice < 0) choice = maxmenus - 1, bary = texty + height * (maxmenus - 1);
     else bary -= height;
   }
   else if (key.scan == 'P') {
     if (++choice == maxmenus) choice = 0, bary = texty;
     else bary += height;
   }
 }
  _16_i_show(x, y, menubg, COPY_IMAGE);
  free(menubg);
  return(++choice);
}

/*----------------------------------------------------------------------------
 * Pop up a menu in 640x480x16 graphics mode.
 *
 * [see !BESTLIB.DOC for a description of each parameter]
 * [see !BESTLIB.DOC for a description of the return values]
 */
int _16_popupmenu(int x, int y, int choice, int maxmenus, char *ptr[], int data[][3], char *text[], int ms)
{
  #define MAXDATA 20                  // maximum number of menu options
  #define BORDERTHICKNESS 3           // thickness of border in pixels
  #define BORDERCOLOR YELLOW          // color of surrounding border
  #define INNERXSPACE 3               // space between left border and text
  #define INNERYSPACE 2               // space between top border and text
  #define INTERSPACE 33               // space between horizontal submenus
  #define INNERCOLOR BLUE             // inner color of menu
  #define FILLSTYLE 1                 // fill pattern of inner menu
  #define TEXTCOLOR YELLOW            // color of text
  #define INACTIVECOLOR LIGHTRED      // color of inactive text
  #define BARCOLOR WHITE              // color of choosebar
  int datalength[MAXDATA] = { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
  int a, b, bgx, bgy, bx, barx, bary, barlength, choicex = 0,
      length, flength, height, fheight, textx, texty;
  imagedata *bg, *bg2, *menubg;
  register int i, ii;

  choice--;
  for (a = i = 0; i < maxmenus; i++) {
    for (ii = 0; ii < data[i][0]; ii++) {
      if (!data[i][1])
        datalength[i] = 0;
      else
        datalength[i] += textwidth( text[ data[i][1] + ii] ) + INTERSPACE;
    }
    if (datalength[i] > a)
      a = datalength[i];
  }
  for (b = i = ii = 0; i < maxmenus; i++) {
    if (textwidth(ptr[i]) > ii)
      ii = length = textwidth(ptr[i]);
    if (textheight(ptr[i]) > b)
      b = height = textheight(ptr[i]);
  }
  height++;
  bg = (void *) malloc(_16_i_need(a + BORDERTHICKNESS * 2, height + BORDERTHICKNESS * 2 + INNERYSPACE * 2));
  bg2 = (void *) malloc(_16_i_need(BORDERTHICKNESS, height + BORDERTHICKNESS * 2 + INNERYSPACE * 2));
  fheight = height * maxmenus + BORDERTHICKNESS * 2 + INNERYSPACE * 2,
  flength = length + BORDERTHICKNESS * 2 + INNERXSPACE * 2;
  menubg = (void *) malloc(_16_i_need(flength, fheight));
  if (menubg == NULL || bg2 == NULL || bg == NULL) {
    if (bg != NULL) free(bg);
    if (bg2 != NULL) free(bg2);
    if (menubg != NULL) free(menubg);
    return(-1);                        // return code for error
  }
  _16_i_save(x, y, flength, fheight, menubg, FALSE, TRUE);
  for (i = 0; i < BORDERTHICKNESS; i++)
    _16_boxoutline(x + i, y + i, flength - i - i, fheight - i - i, BORDERCOLOR, COPY_IMAGE);

  _16_boxfill(x + i, y + i, flength - i - i, fheight - i - i, BLACK, COPY_IMAGE);
  textx = x + BORDERTHICKNESS + INNERXSPACE,
  texty = y + BORDERTHICKNESS + INNERYSPACE;
  setfillstyle(FILLSTYLE, INNERCOLOR);
  floodfill(textx, texty, BORDERCOLOR);
  setcolor(TEXTCOLOR);
  for (b = texty - 1, i = 0, ii = 0x0001; i < maxmenus; b += height, i++, ii = ii << 1) {
    if (ii & (unsigned int)text[0])
      setcolor(TEXTCOLOR);
    else
      setcolor(INACTIVECOLOR);
    outtextxy(textx, b, ptr[i]);
  }
  setcolor(TEXTCOLOR);

  barlength = length + INNERXSPACE * 2,
  fheight -= BORDERTHICKNESS,
  barx = textx - INNERXSPACE,
  bary = texty + choice * height;

  for (i = ii = 1; i < choice + 1; i++) ii = ii << 1;
  for (i = 0; i < maxmenus; i++, ii = ii << 1, bary += height, choice++)
    if (ii & (unsigned int)text[0]) break;
  if (i == maxmenus) return(-1);

  bgx = barx + barlength + BORDERTHICKNESS,
  bgy = bary - BORDERTHICKNESS - INNERYSPACE,
  flength = datalength[choice] + BORDERTHICKNESS * 2,
  fheight = height + BORDERTHICKNESS * 2 + INNERYSPACE * 2;
  _16_i_save(bgx, bgy, flength, fheight, bg, FALSE, TRUE);
  if (data[choice][1]) {
    b = bgx - BORDERTHICKNESS * 2;
    _16_i_save(b, bgy, BORDERTHICKNESS, fheight, bg2, FALSE, TRUE);
    for (i = 0; i < BORDERTHICKNESS; i++)
      _16_boxoutline(b + i, bgy + i, flength - i - i + BORDERTHICKNESS, fheight - i - i, BORDERCOLOR, COPY_IMAGE);
    _16_boxfill(b + i, bgy + BORDERTHICKNESS, flength - i, fheight - BORDERTHICKNESS * 2, BLACK, COPY_IMAGE);
    floodfill(b + i, bgy + BORDERTHICKNESS, BORDERCOLOR);
    _16_i_show(b, bgy, bg2, COPY_IMAGE);

    b = barx + barlength + BORDERTHICKNESS + INTERSPACE / 2;
    for (i = 0, ii = 0x0001; i < data[choice][0]; i++, ii = ii << 1) {
      if (ii & (unsigned int)data[choice][2])
        setcolor(TEXTCOLOR);
      else
        setcolor(INACTIVECOLOR);
      outtextxy(b, bary - 1, text[ data[choice][1] + i ]);
      b += textwidth(text[ data[choice][1] + i ]) + INTERSPACE;
    }
  }
  a = barx, bx = barlength;
  if (ms) {
    msdata.pos[0] = msdata.npos[0] = MAXX / 2,
    msdata.pos[1] = msdata.npos[1] = MAXY / 2;
    ms_set(msdata.pos[0], msdata.pos[1]);
  }
 while (TRUE)
 {
  _16_boxfill(barx, bary, barlength, height, BARCOLOR, XOR_IMAGE);
  key.ascii = key.scan = 0;
  if (ms) while (TRUE) {
    if (keyhit()) {
      getchr();
      break;
    }
    ms_stat();
    if (msdata.buts[0] != msdata.nbuts[0]) {
      msdata.buts[0] = msdata.nbuts[0];
      if (!msdata.nbuts[0]) {
        key.ascii = 13;
        break;
      }
    }
    if (msdata.buts[1] != msdata.nbuts[1]) {
      msdata.buts[1] = msdata.nbuts[1];
      if (!msdata.nbuts[1]) { key.ascii = 27; break; }
    }
    if (abs(length = msdata.npos[0] - msdata.pos[0]) > 40) {
      if (length > 0) key.scan = 'M';
      else key.scan = 'K';
      msdata.pos[0] = msdata.npos[0] = MAXX / 2,
      msdata.pos[1] = msdata.npos[1] = MAXY / 2;
      ms_set(msdata.pos[0], msdata.pos[1]);
      break;
    }
    if (abs(length = msdata.npos[1] - msdata.pos[1]) > 10) {
      if (length > 0) key.scan = 'P';
      else key.scan = 'H';
      msdata.pos[0] = msdata.npos[0] = MAXX / 2,
      msdata.pos[1] = msdata.npos[1] = MAXY / 2;
      ms_set(msdata.pos[0], msdata.pos[1]);
      break;
    }
  }
  else
    getchr();
  _16_boxfill(barx, bary, barlength, height, BARCOLOR, XOR_IMAGE);
  if (key.ascii == 9 || key.ascii == 13 || key.ascii == 27) {
    if (key.ascii == 9 || key.ascii == 27)
      choice = -1, choicex = 0;
    break;
  }                          // 'H' = 1, 'K' = 2, 'M' = 3, 'P' = 4
  if (key.scan == 'H') {
    barx = a, barlength = bx, choicex = 0;
    if (--choice < 0) choice = maxmenus - 1, bary = texty + height * (maxmenus - 1);
    else bary -= height;

    for (i = ii = 1; i < choice + 1; i++) ii = ii << 1;
    for (i = 0; ; i++) {
      if (ii & (unsigned int)text[0]) break;
      if (--choice < 0) {
        choice = maxmenus - 1,
        bary = texty + height * choice;
        for (i = ii = 1; i < maxmenus; i++) ii = ii << 1;
        i = 0;
        continue;
      }
      else bary -= height, ii = ii >> 1;
    }
    _16_i_show(bgx, bgy, bg, COPY_IMAGE);
    _16_boxfill(bgx - BORDERTHICKNESS, bgy, BORDERTHICKNESS, fheight, BORDERCOLOR, COPY_IMAGE);
    if (data[choice][1]) {
      bgx = barx + barlength + BORDERTHICKNESS,
      bgy = bary - BORDERTHICKNESS - INNERYSPACE,
      flength = datalength[choice] + BORDERTHICKNESS * 2;
      _16_i_save(bgx, bgy, flength, fheight, bg, FALSE, TRUE);
      b = bgx - BORDERTHICKNESS * 2;
      _16_i_save(b, bgy, BORDERTHICKNESS, fheight, bg2, FALSE, TRUE);
      for (i = 0; i < BORDERTHICKNESS; i++)
        _16_boxoutline(b + i, bgy + i, flength - i - i + BORDERTHICKNESS, fheight - i - i, BORDERCOLOR, COPY_IMAGE);
      _16_boxfill(b + i, bgy + BORDERTHICKNESS, flength - i, fheight - BORDERTHICKNESS * 2, BLACK, COPY_IMAGE);
      floodfill(b + i, bgy + BORDERTHICKNESS, BORDERCOLOR);
      _16_i_show(b, bgy, bg2, COPY_IMAGE);

      b = barx + barlength + BORDERTHICKNESS + INTERSPACE / 2;
      for (i = 0, ii = 0x0001; i < data[choice][0]; i++, ii = ii << 1) {
        if (ii & (unsigned int)data[choice][2])
          setcolor(TEXTCOLOR);
        else
          setcolor(INACTIVECOLOR);
        outtextxy(b, bary - 1, text[ data[choice][1] + i ]);
        b += textwidth(text[ data[choice][1] + i ]) + INTERSPACE;
      }
    }
    choicex = 0;
  }
  else if (key.scan == 'P') {
    barx = a, barlength = bx, choicex = 0;
    if (++choice == maxmenus) choice = 0, bary = texty;
    else bary += height;

    for (i = ii = 1; i < choice + 1; i++) ii = ii << 1;
    for (i = 0; ; i++) {
      if (ii & (unsigned int)text[0]) break;
      if (++choice == maxmenus) {
        choice = 0, bary = texty, ii = 1, i = 0;
        continue;
      }
      else bary += height, ii = ii << 1;
    }
    _16_i_show(bgx, bgy, bg, COPY_IMAGE);
    _16_boxfill(bgx - BORDERTHICKNESS, bgy, BORDERTHICKNESS, fheight, BORDERCOLOR, COPY_IMAGE);
    if (data[choice][1]) {
      bgx = barx + barlength + BORDERTHICKNESS,
      bgy = bary - BORDERTHICKNESS - INNERYSPACE,
      flength = datalength[choice] + BORDERTHICKNESS * 2;
      _16_i_save(bgx, bgy, flength, fheight, bg, FALSE, TRUE);
      b = bgx - BORDERTHICKNESS * 2;
      _16_i_save(b, bgy, BORDERTHICKNESS, fheight, bg2, FALSE, TRUE);
      for (i = 0; i < BORDERTHICKNESS; i++)
        _16_boxoutline(b + i, bgy + i, flength - i - i + BORDERTHICKNESS, fheight - i - i, BORDERCOLOR, COPY_IMAGE);
      _16_boxfill(b + i, bgy + BORDERTHICKNESS, flength - i, fheight - BORDERTHICKNESS * 2, BLACK, COPY_IMAGE);
      floodfill(b + i, bgy + BORDERTHICKNESS, BORDERCOLOR);
      _16_i_show(b, bgy, bg2, COPY_IMAGE);

      b = barx + barlength + BORDERTHICKNESS + INTERSPACE / 2;
      for (i = 0, ii = 0x0001; i < data[choice][0]; i++, ii = ii << 1) {
        if (ii & (unsigned int)data[choice][2])
          setcolor(TEXTCOLOR);
        else
          setcolor(INACTIVECOLOR);
        outtextxy(b, bary - 1, text[ data[choice][1] + i ]);
        b += textwidth(text[ data[choice][1] + i ]) + INTERSPACE;
      }
    }
    choicex = 0;
  }
  else if (key.scan == 'K') { if (data[choice][1]) {
    switch(choicex) {
     case 0:
      _16_boxfill(bgx - BORDERTHICKNESS, bgy, BORDERTHICKNESS, fheight, BORDERCOLOR, COPY_IMAGE);
     case 1:
      choicex = data[choice][0],
      barx = a + bx + BORDERTHICKNESS + datalength[choice] - textwidth(text[ data[choice][1] + choicex - 1 ]) - INTERSPACE;
      break;
     default:
      choicex--,
      barx -= textwidth(text[ data[choice][1] + choicex - 1 ]) + INTERSPACE;
    }
    for (i = ii = 1; i < choicex; i++)
      ii = ii << 1;
    for (b = i = 0; b != data[choice][0]; i++, b++) {
      if (ii & (unsigned int)data[choice][2]) break;
      if (--choicex < 1) {
        choicex = data[choice][0],
        barx = a + bx + BORDERTHICKNESS + datalength[choice] - textwidth(text[ data[choice][1] + choicex - 1 ]) - INTERSPACE;
        for (i = ii = 1; i < data[choice][0]; i++) ii = ii << 1;
        i = 0;
        continue;
      }
      else
        ii = ii >> 1,
        barx -= textwidth(text[ data[choice][1] + choicex - 1 ]) + INTERSPACE;
    }
    if (b == data[choice][0])
      barx = a, barlength = bx, choicex = 0;
    else
      barlength = textwidth(text[ data[choice][1] + choicex - 1 ]) + INTERSPACE;
  } }
  else if (key.scan == 'M') if (data[choice][1]) {
    if (!choicex) {
       _16_boxfill(bgx - BORDERTHICKNESS, bgy, BORDERTHICKNESS, fheight, BORDERCOLOR, COPY_IMAGE);
       choicex = 0, barx = a + bx + BORDERTHICKNESS;
    }
    else if (choicex == data[choice][0])
      choicex = 0, barx = a + bx + BORDERTHICKNESS;
    else
      barx += textwidth(text[ data[choice][1] + choicex - 1 ]) + INTERSPACE;

    for (i = ii = 1; i < choicex + 1; i++)
      ii = ii << 1;
    for (b = i = 0; b != data[choice][0]; i++, b++) {
      if (ii & (unsigned int)data[choice][2]) break;
      if (++choicex == data[choice][0]) {
        choicex = 0, barx = a + bx + BORDERTHICKNESS,
        ii = 0x0001, i = 0;
        continue;
      }
      else
        ii = ii << 1,
        barx += textwidth(text[ data[choice][1] + choicex - 1 ]) + INTERSPACE;
    }
    if (b == data[choice][0])
      barx = a, barlength = bx, choicex = 0;
    else
      barlength = textwidth(text[ data[choice][1] + choicex++ ]) + INTERSPACE;
  }
 }
  _16_i_show(x, y, menubg, COPY_IMAGE);
  _16_i_show(bgx, bgy, bg, COPY_IMAGE);
  free(menubg);
  free(bg2);
  free(bg);
  return(choicex | (++choice << 4));
}

/*==============================  END-OF-FILE  =============================*/
