#include <stdio.h>
#include <libbcc.h>

void test(char *txt, int gd, int gm)
{
  int ogd = gd;
  int ogm = gm;

  set_BGI_mode(&gd, &gm);
  printf("%s : %4dx%4dx%3d", txt, __gr_BGI_w, __gr_BGI_h, __gr_BGI_c);
  if (gd != ogd || gm != ogm)
    printf( "  gd: %2d -> %2d,   gm: %2d -> %2d", ogd, gd, ogm, gm);
  printf("\n");
}

void main(void)
{
  int i;

  printf( "Available modes :\n");
  for (i = 0; i <= getmaxmode(); ++i)
    printf( "\tgraphics mode %2d : %s\n" , i, getmodename(i));
  printf("\n");
  
  test("VGA       VGALO     ", VGA     , VGALO     );
  test("VGA       VGAMED    ", VGA     , VGAMED    );
  test("VGA       VGAHI     ", VGA     , VGAHI     );
  test("IBM8514   IBM8514LO ", IBM8514 , IBM8514LO );
  test("IBM8514   IBM8514HI ", IBM8514 , IBM8514HI );
  test("HERCMONO  HERCMONOHI", HERCMONO, HERCMONOHI);
  test("CGA       CGAC0     ", CGA     , CGAC0     );
  test("CGA       CGAC1     ", CGA     , CGAC1     );
  test("CGA       CGAC2     ", CGA     , CGAC2     );
  test("CGA       CGAC3     ", CGA     , CGAC3     );
  test("CGA       CGAHI     ", CGA     , CGAHI     );
  test("MCGA      MCGAC0    ", MCGA    , MCGAC0    );
  test("MCGA      MCGAC1    ", MCGA    , MCGAC1    );
  test("MCGA      MCGAC2    ", MCGA    , MCGAC2    );
  test("MCGA      MCGAC3    ", MCGA    , MCGAC3    );
  test("MCGA      MCGAMED   ", MCGA    , MCGAMED   );
  test("MCGA      MCGAHI    ", MCGA    , MCGAHI    );
  test("ATT400    ATT400C0  ", ATT400  , ATT400C0  );
  test("ATT400    ATT400C1  ", ATT400  , ATT400C1  );
  test("ATT400    ATT400C2  ", ATT400  , ATT400C2  );
  test("ATT400    ATT400C3  ", ATT400  , ATT400C3  );
  test("ATT400    ATT400MED ", ATT400  , ATT400MED );
  test("ATT400    ATT400HI  ", ATT400  , ATT400HI  );
  test("EGA64     EGA64LO   ", EGA64   , EGA64LO   );
  test("EGA64     EGA64HI   ", EGA64   , EGA64HI   );
  test("EGA       EGALO     ", EGA     , EGALO     );
  test("EGA       EGAHI     ", EGA     , EGAHI     );
  test("EGAMONO   EGAMONOHI ", EGAMONO , EGAMONOHI );
  test("PC3270    PC3270HI  ", PC3270  , PC3270HI  );
}
