/*
 * BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 * Copyright (C) 1993-96 by Hartmut Schirmer
 *
 * This library is copyrighted (see above). It might be used and
 * distributed freely as long as all copyright notices are left
 * intact.
 *
 * You may not distribute any changed versions of BCC2GRX without
 * written permission by Hartmut Schirmer.
 *
 * You are permitted to distribute an application linked with BCC2GRX
 * in binary only, provided that the documentation of the program:
 *
 *    a)   informs the user that BCC2GRX is used in the program, AND
 *
 *    b)   provides the user with the necessary information about
 *         how to obtain BCC2GRX. (i.e. ftp site, etc..)
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Contact :                Hartmut Schirmer
 *                          Feldstrasse 118
 *                  D-24105 Kiel
 *                          Germany
 *
 * e-mail : hsc@techfak.uni-kiel.d400.de
 */

#include "bccgrx00.h"

static struct arccoordstype  ac;

#ifdef GRX_VERSION
#define GrGetLastArcCoords GrLastArcCoords
#endif

/* ----------------------------------------------------------------- */
void __gr_ellipse(int x, int y, int st, int en,
				int xradius, int yradius  )
{
  _DO_INIT_CHECK;
  st *= 10;
  en *= 10;
  GrEllipseArc(x+VL,y+VT,XR(xradius),YR(yradius),st,en,
	       #ifdef GRX_VERSION
	       (en-st!=0&&(en-st)%3600==0) ? GR_ARC_STYLE_CLOSE1 : GR_ARC_STYLE_OPEN,
	       #endif
	       COL);
  {
#if defined(GR_DRV_VER_GRD) || defined(GRX_VERSION)
    /* GRX 1.03 or newer */
    int xs, ys, xc, yc, xe, ye;
    GrGetLastArcCoords(&xs,&ys,&xe,&ye,&xc,&yc);
#else
    /* GRX 1.02+ */
# define xs _grx_arc_xs
# define ys _grx_arc_ys
# define xc _grx_arc_xc
# define yc _grx_arc_yc
# define xe _grx_arc_xe
# define ye _grx_arc_ye
#endif
    ac.x      = xc - VL;
    ac.y      = yc - VT;
    ac.xstart = xs - VL;
    ac.ystart = ys - VT;
    ac.xend   = xe - VL;
    ac.yend   = ye - VT;
  }
}

/* ----------------------------------------------------------------- */
void getarccoords(struct arccoordstype  *arccoords)
{
  _DO_INIT_CHECK;
  memcpy( arccoords, &ac, sizeof(ac));
}
